/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml.behavior;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.xml.XmlPsiPolicy;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class DefaultXmlPsiPolicy
implements XmlPsiPolicy {
    private static final Logger LOG = Logger.getInstance(DefaultXmlPsiPolicy.class);

    @Override
    public ASTNode encodeXmlTextContents(String displayText, PsiElement text) {
        if (displayText.isEmpty()) {
            return null;
        }
        CharTable charTable = SharedImplUtil.findCharTableByTree((ASTNode)text.getNode());
        FileElement dummyParent = DummyHolderFactory.createHolder((PsiManager)text.getManager(), null, (CharTable)charTable).getTreeElement();
        XmlTag rootTag = ((XmlFile)PsiFileFactory.getInstance((Project)text.getProject()).createFileFromText("a.xml", text.getLanguage(), (CharSequence)this.buildTagForText(text, displayText), false, true)).getRootTag();
        assert (rootTag != null);
        XmlTagChild[] tagChildren = rootTag.getValue().getChildren();
        XmlTagChild child = tagChildren.length > 0 ? tagChildren[0] : null;
        LOG.assertTrue(child != null, (Object)("Child is null for tag: " + rootTag.getText()));
        TreeElement element = (TreeElement)child.getNode();
        DebugUtil.performPsiModification((String)this.getClass().getName(), () -> {
            ((TreeElement)tagChildren[tagChildren.length - 1].getNode().getTreeNext()).rawRemoveUpToLast();
            dummyParent.rawAddChildren(element);
        });
        TreeUtil.clearCaches((TreeElement)dummyParent);
        return element.getFirstChildNode();
    }

    @NotNull
    protected String buildTagForText(PsiElement text, String displayText) {
        return "<a>" + displayText + "</a>";
    }
}

