/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.HintedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.meta.MetaRegistry;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.impl.source.xml.XmlTagDelegate;
import com.intellij.psi.impl.source.xml.XmlTagValueImpl;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.IXmlAttributeElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.XmlUtil;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTagImpl
extends XmlElementImpl
implements XmlTag,
HintedReferenceHost {
    private static final Logger LOG = Logger.getInstance(XmlTagImpl.class);
    private final int myHC = ourHC++;
    @Nullable
    private volatile XmlTagDelegate myImpl;
    private volatile XmlTagValue myValue;
    private volatile XmlAttribute[] myAttributes;

    public XmlTagImpl() {
        this(XmlElementType.XML_TAG);
    }

    protected XmlTagImpl(IElementType type) {
        super(type);
    }

    @NotNull
    private XmlTagDelegate getImpl() {
        XmlTagDelegate impl = this.myImpl;
        if (impl != null) {
            return impl;
        }
        this.myImpl = impl = this.createDelegate();
        return impl;
    }

    @NotNull
    protected XmlTagDelegate createDelegate() {
        return new XmlTagImplDelegate();
    }

    public final int hashCode() {
        return this.myHC;
    }

    @Override
    public void clearCaches() {
        this.myImpl = null;
        this.myAttributes = null;
        this.myValue = null;
        super.clearCaches();
    }

    @Deprecated
    public final PsiReference @NotNull [] getReferences() {
        return this.getReferences(PsiReferenceService.Hints.NO_HINTS);
    }

    public boolean shouldAskParentForReferences(@NotNull PsiReferenceService.Hints hints) {
        return false;
    }

    public PsiReference @NotNull [] getReferences(@NotNull PsiReferenceService.Hints hints) {
        return this.getImpl().getDefaultReferences(hints);
    }

    public XmlNSDescriptor getNSDescriptor(String namespace, boolean strict) {
        return this.getImpl().getNSDescriptor(namespace, strict);
    }

    public boolean isEmpty() {
        return XmlChildRole.CLOSING_TAG_START_FINDER.findChild((ASTNode)this) == null;
    }

    public void collapseIfEmpty() {
        this.getImpl().collapseIfEmpty();
    }

    @Nullable
    @NonNls
    public String getSubTagText(@NonNls String qname) {
        XmlTag tag = this.findFirstSubTag(qname);
        if (tag == null) {
            return null;
        }
        return tag.getValue().getText();
    }

    public PsiReference getReference() {
        return (PsiReference)ArrayUtil.getFirstElement((Object[])this.getReferences(PsiReferenceService.Hints.NO_HINTS));
    }

    public XmlElementDescriptor getDescriptor() {
        return this.getImpl().getDescriptor();
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == XmlTokenType.XML_NAME || i == XmlTokenType.XML_TAG_NAME) {
            return 224;
        }
        if (i instanceof IXmlAttributeElementType) {
            return 240;
        }
        return 0;
    }

    @NotNull
    public String getName() {
        return this.getImpl().getName();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        return this.getImpl().setName(name);
    }

    public XmlAttribute @NotNull [] getAttributes() {
        XmlAttribute[] attributes = this.myAttributes;
        if (attributes == null) {
            this.myAttributes = attributes = this.getImpl().calculateAttributes();
        }
        return (XmlAttribute[])attributes.clone();
    }

    public String getAttributeValue(String qname) {
        return this.getImpl().getAttributeValue(qname);
    }

    public String getAttributeValue(String _name, String namespace) {
        return this.getImpl().getAttributeValue(_name, namespace);
    }

    public XmlTag @NotNull [] getSubTags() {
        return this.getSubTags(XmlTagImpl.shouldProcessIncludesNow());
    }

    public XmlTag[] getSubTags(boolean processIncludes) {
        return this.getImpl().getSubTags(processIncludes);
    }

    public static boolean shouldProcessIncludesNow() {
        return FileBasedIndex.getInstance().getFileBeingCurrentlyIndexed() == null && !XmlUtil.isStubBuilding();
    }

    public XmlTag @NotNull [] findSubTags(String name) {
        return this.findSubTags(name, null);
    }

    public XmlTag @NotNull [] findSubTags(String name, @Nullable String namespace) {
        return this.getImpl().findSubTags(name, namespace);
    }

    public XmlTag findFirstSubTag(String name) {
        return this.getImpl().findFirstSubTag(name);
    }

    public XmlAttribute getAttribute(String name, String namespace) {
        return this.getImpl().getAttribute(name, namespace);
    }

    @Nullable
    public XmlAttribute getAttribute(String qname) {
        return this.getImpl().getAttribute(qname);
    }

    @NotNull
    public String getNamespace() {
        return (String)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.getNamespaceByPrefix(this.getNamespacePrefix()), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @NotNull
    public String getNamespacePrefix() {
        return this.getImpl().getNamespacePrefix(this.getName());
    }

    @NotNull
    public String getNamespaceByPrefix(String prefix) {
        return this.getImpl().getNamespaceByPrefix(prefix);
    }

    public String getPrefixByNamespace(String namespace) {
        return this.getImpl().getPrefixByNamespace(namespace);
    }

    public String[] knownNamespaces() {
        return this.getImpl().knownNamespaces();
    }

    @NotNull
    public String getLocalName() {
        return this.getImpl().getLocalName();
    }

    public boolean hasNamespaceDeclarations() {
        return this.getImpl().hasNamespaceDeclarations();
    }

    @NotNull
    public Map<String, String> getLocalNamespaceDeclarations() {
        return this.getImpl().getLocalNamespaceDeclarations();
    }

    public XmlAttribute setAttribute(String qname, String value) throws IncorrectOperationException {
        return this.getImpl().setAttribute(qname, value);
    }

    public XmlAttribute setAttribute(String name, String namespace, String value) throws IncorrectOperationException {
        return this.getImpl().setAttribute(name, namespace, value);
    }

    public XmlTag createChildTag(String localName, String namespace, String bodyText, boolean enforceNamespacesDeep) {
        return XmlUtil.createChildTag(this, localName, namespace, bodyText, enforceNamespacesDeep);
    }

    protected XmlTagValue createXmlTagValue() {
        return XmlTagValueImpl.createXmlTagValue(this);
    }

    public XmlTag addSubTag(XmlTag subTag, boolean first) {
        return this.getImpl().addSubTag(subTag, first);
    }

    @NotNull
    public XmlTagValue getValue() {
        XmlTagValue tagValue = this.myValue;
        if (tagValue == null) {
            this.myValue = tagValue = this.createXmlTagValue();
        }
        return tagValue;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlTag((XmlTag)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "XmlTag:" + this.getName();
    }

    public PsiMetaData getMetaData() {
        return MetaRegistry.getMeta((PsiElement)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean beforeB) {
        TreeElement firstAppended = null;
        boolean before = beforeB == null || beforeB != false;
        try {
            TreeElement next;
            do {
                next = first.getTreeNext();
                if (firstAppended == null) {
                    firstAppended = this.getImpl().addInternal(first, anchor, before);
                    anchor = firstAppended;
                    continue;
                }
                anchor = this.getImpl().addInternal(first, anchor, false);
            } while (first != last && (first = next) != null);
        }
        finally {
            this.clearCaches();
        }
        return firstAppended;
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        this.getImpl().deleteChildInternal(child);
    }

    protected void deleteChildInternalSuper(@NotNull ASTNode child) {
        super.deleteChildInternal(child);
    }

    protected TreeElement addInternalSuper(TreeElement first, ASTNode last, @Nullable ASTNode anchor, @Nullable Boolean before) {
        return super.addInternal(first, last, anchor, before);
    }

    public XmlTag getParentTag() {
        PsiElement parent = this.getParent();
        if (parent instanceof XmlTag) {
            return (XmlTag)parent;
        }
        return null;
    }

    public XmlTagChild getNextSiblingInTag() {
        PsiElement nextSibling = this.getNextSibling();
        if (nextSibling instanceof XmlTagChild) {
            return (XmlTagChild)nextSibling;
        }
        return null;
    }

    public XmlTagChild getPrevSiblingInTag() {
        PsiElement prevSibling = this.getPrevSibling();
        if (prevSibling instanceof XmlTagChild) {
            return (XmlTagChild)prevSibling;
        }
        return null;
    }

    public Icon getElementIcon(int flags) {
        return PlatformIcons.XML_TAG_ICON;
    }

    protected class XmlTagImplDelegate
    extends XmlTagDelegate {
        public XmlTagImplDelegate() {
            super(XmlTagImpl.this);
        }

        @Override
        protected void deleteChildInternalSuper(@NotNull ASTNode child) {
            XmlTagImpl.this.deleteChildInternalSuper(child);
        }

        @Override
        protected TreeElement addInternalSuper(TreeElement first, ASTNode last, @Nullable ASTNode anchor, @Nullable Boolean before) {
            return XmlTagImpl.this.addInternalSuper(first, last, anchor, before);
        }
    }
}

