/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.dtd.DTDLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.PsiCachedValueImpl;
import com.intellij.psi.impl.meta.MetaRegistry;
import com.intellij.psi.impl.source.html.dtd.HtmlNSDescriptorImpl;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.IXmlTagElementType;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.util.XmlNSDescriptorSequence;
import com.intellij.xml.util.XmlPsiUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlDocumentImpl
extends XmlElementImpl
implements XmlDocument {
    private static final Key<Boolean> AUTO_GENERATED = Key.create((String)"auto-generated xml schema");
    private static final Logger LOG = Logger.getInstance(XmlDocumentImpl.class);
    private static final AtomicFieldUpdater<XmlDocumentImpl, XmlProlog> MY_PROLOG_UPDATER = AtomicFieldUpdater.forFieldOfType(XmlDocumentImpl.class, XmlProlog.class);
    private static final AtomicFieldUpdater<XmlDocumentImpl, XmlTag> MY_ROOT_TAG_UPDATER = AtomicFieldUpdater.forFieldOfType(XmlDocumentImpl.class, XmlTag.class);
    private volatile XmlProlog myProlog;
    private volatile XmlTag myRootTag;
    private volatile long myExtResourcesModCount = -1L;
    private ConcurrentMap<String, CachedValue<XmlNSDescriptor>> myDefaultDescriptorsCacheStrict = new ConcurrentHashMap<String, CachedValue<XmlNSDescriptor>>();
    private ConcurrentMap<String, CachedValue<XmlNSDescriptor>> myDefaultDescriptorsCacheNotStrict = new ConcurrentHashMap<String, CachedValue<XmlNSDescriptor>>();

    public static boolean isAutoGeneratedSchema(XmlFile file) {
        return file.getUserData(AUTO_GENERATED) != null;
    }

    public XmlDocumentImpl() {
        this(XmlElementType.XML_DOCUMENT);
    }

    protected XmlDocumentImpl(IElementType type) {
        super(type);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlDocument((XmlDocument)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == XmlElementType.XML_PROLOG) {
            return 225;
        }
        if (i instanceof IXmlTagElementType) {
            return 241;
        }
        return 0;
    }

    public XmlProlog getProlog() {
        XmlProlog prolog = this.myProlog;
        if (prolog == null && !MY_PROLOG_UPDATER.compareAndSet((Object)this, null, (Object)(prolog = (XmlProlog)this.findElementByTokenType(XmlElementType.XML_PROLOG)))) {
            prolog = (XmlProlog)MY_PROLOG_UPDATER.get((Object)this);
        }
        return prolog;
    }

    public XmlTag getRootTag() {
        XmlTag rootTag = this.myRootTag;
        if (rootTag == null) {
            rootTag = (XmlTag)XmlPsiUtil.findElement(this, IXmlTagElementType.class::isInstance);
            if (!MY_ROOT_TAG_UPDATER.compareAndSet((Object)this, null, (Object)rootTag)) {
                rootTag = (XmlTag)MY_ROOT_TAG_UPDATER.get((Object)this);
            }
        }
        return rootTag;
    }

    public XmlNSDescriptor getRootTagNSDescriptor() {
        XmlTag rootTag = this.getRootTag();
        return rootTag != null ? rootTag.getNSDescriptor(rootTag.getNamespace(), false) : null;
    }

    @Override
    public void clearCaches() {
        this.myDefaultDescriptorsCacheStrict.clear();
        this.myDefaultDescriptorsCacheNotStrict.clear();
        this.myRootTag = null;
        this.myProlog = null;
        super.clearCaches();
    }

    @Nullable
    public XmlNSDescriptor getDefaultNSDescriptor(String namespace, boolean strict) {
        ConcurrentMap<String, CachedValue<XmlNSDescriptor>> defaultDescriptorsCache;
        CachedValue cachedValue;
        long curExtResourcesModCount = ExternalResourceManagerEx.getInstanceEx().getModificationCount(this.getProject());
        if (this.myExtResourcesModCount != curExtResourcesModCount) {
            this.myDefaultDescriptorsCacheNotStrict.clear();
            this.myDefaultDescriptorsCacheStrict.clear();
            this.myExtResourcesModCount = curExtResourcesModCount;
        }
        if ((cachedValue = (CachedValue)(defaultDescriptorsCache = strict ? this.myDefaultDescriptorsCacheStrict : this.myDefaultDescriptorsCacheNotStrict).get(namespace)) == null) {
            cachedValue = new PsiCachedValueImpl((PsiManager)this.getManager(), () -> {
                XmlNSDescriptor defaultNSDescriptorInner = this.getDefaultNSDescriptorInner(namespace, strict);
                if (this.isGeneratedFromDtd(defaultNSDescriptorInner)) {
                    return new CachedValueProvider.Result((Object)defaultNSDescriptorInner, new Object[]{this, ExternalResourceManager.getInstance()});
                }
                return new CachedValueProvider.Result((Object)defaultNSDescriptorInner, new Object[]{defaultNSDescriptorInner != null ? defaultNSDescriptorInner.getDependencies() : ExternalResourceManager.getInstance()});
            });
            defaultDescriptorsCache.put(namespace, (CachedValue<XmlNSDescriptor>)cachedValue);
        }
        return (XmlNSDescriptor)cachedValue.getValue();
    }

    private boolean isGeneratedFromDtd(XmlNSDescriptor defaultNSDescriptorInner) {
        if (defaultNSDescriptorInner == null) {
            return false;
        }
        XmlFile descriptorFile = defaultNSDescriptorInner.getDescriptorFile();
        if (descriptorFile == null) {
            return false;
        }
        String otherName = XmlUtil.getContainingFile((PsiElement)this).getName() + ".dtd";
        return descriptorFile.getName().equals(otherName);
    }

    private XmlNSDescriptor getDefaultNSDescriptorInner(String namespace, boolean strict) {
        XmlFile xmlFile;
        XmlNSDescriptor descr;
        XmlFile containingFile = XmlUtil.getContainingFile((PsiElement)this);
        if (containingFile == null) {
            return null;
        }
        XmlProlog prolog = this.getProlog();
        XmlDoctype doctype = prolog != null ? prolog.getDoctype() : null;
        boolean dtdUriFromDocTypeIsNamespace = false;
        if ("http://www.w3.org/1999/html".equals(namespace)) {
            XmlFile descriptorFile;
            XmlNSDescriptor nsDescriptor;
            XmlNSDescriptor xmlNSDescriptor = nsDescriptor = doctype != null ? this.getNsDescriptorFormDocType(doctype, containingFile, true) : null;
            if (doctype != null) {
                LOG.debug("Descriptor from doctype " + doctype + " is " + (nsDescriptor != null ? nsDescriptor.getClass().getCanonicalName() : "NULL"));
            }
            if (nsDescriptor == null) {
                String htmlns = ExternalResourceManagerEx.getInstanceEx().getDefaultHtmlDoctype(this.getProject());
                if (htmlns.isEmpty()) {
                    htmlns = Html5SchemaProvider.getHtml5SchemaLocation();
                }
                nsDescriptor = this.getDefaultNSDescriptor(htmlns, false);
            }
            if (nsDescriptor != null && (descriptorFile = nsDescriptor.getDescriptorFile()) != null) {
                return XmlDocumentImpl.getCachedHtmlNsDescriptor(descriptorFile);
            }
            return new HtmlNSDescriptorImpl(nsDescriptor);
        }
        if ("http://www.w3.org/1999/xhtml".equals(namespace)) {
            String xhtmlNamespace = XmlUtil.getDefaultXhtmlNamespace(this.getProject());
            if (xhtmlNamespace == null || xhtmlNamespace.isEmpty()) {
                xhtmlNamespace = Html5SchemaProvider.getXhtml5SchemaLocation();
            }
            return this.getDefaultNSDescriptor(xhtmlNamespace, false);
        }
        if (namespace != null && namespace != "") {
            if (doctype == null || !namespace.equals(XmlUtil.getDtdUri(doctype))) {
                XmlDocument document;
                XmlFile xmlFile2;
                boolean documentIsSchemaThatDefinesNs = namespace.equals(XmlUtil.getTargetSchemaNsFromTag(this.getRootTag()));
                XmlFile xmlFile3 = xmlFile2 = documentIsSchemaThatDefinesNs ? containingFile : XmlUtil.findNamespace((PsiFile)containingFile, namespace);
                if (xmlFile2 != null && (document = (XmlDocument)AstLoadingFilter.forceAllowTreeLoading((PsiFile)xmlFile2, () -> xmlFile2.getDocument())) != null) {
                    return (XmlNSDescriptor)document.getMetaData();
                }
            } else {
                dtdUriFromDocTypeIsNamespace = true;
            }
        }
        if (strict && !dtdUriFromDocTypeIsNamespace) {
            return null;
        }
        if (doctype != null && (descr = this.getNsDescriptorFormDocType(doctype, containingFile, false)) != null) {
            return XmlExtension.getExtension((PsiFile)containingFile).getDescriptorFromDoctype(containingFile, descr);
        }
        if (strict) {
            return null;
        }
        if (namespace == "" && (xmlFile = XmlUtil.findNamespace((PsiFile)containingFile, namespace)) != null) {
            return (XmlNSDescriptor)xmlFile.getDocument().getMetaData();
        }
        try {
            PsiFile fileFromText = PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText(containingFile.getName() + ".dtd", (Language)DTDLanguage.INSTANCE, (CharSequence)XmlUtil.generateDocumentDTD(this, false), false, false);
            if (fileFromText instanceof XmlFile) {
                fileFromText.putUserData(AUTO_GENERATED, (Object)Boolean.TRUE);
                return (XmlNSDescriptor)((XmlFile)fileFromText).getDocument().getMetaData();
            }
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public static XmlNSDescriptor getCachedHtmlNsDescriptor(@NotNull XmlFile descriptorFile) {
        return XmlDocumentImpl.getCachedHtmlNsDescriptor(descriptorFile, "");
    }

    @Nullable
    public static XmlNSDescriptor getCachedHtmlNsDescriptor(@NotNull XmlFile descriptorFile, @NotNull String prefix) {
        Map descriptorsByPrefix = (Map)CachedValuesManager.getCachedValue((PsiElement)descriptorFile, () -> CachedValueProvider.Result.create(new ConcurrentHashMap(), (Object[])new Object[]{descriptorFile}));
        return descriptorsByPrefix.computeIfAbsent(prefix, p -> {
            XmlDocument document = descriptorFile.getDocument();
            if (document == null) {
                return null;
            }
            return new HtmlNSDescriptorImpl((XmlNSDescriptor)document.getMetaData());
        });
    }

    @NotNull
    private static String getFilePathForLogging(@Nullable PsiFile file) {
        if (file == null) {
            return "NULL";
        }
        VirtualFile vFile = file.getVirtualFile();
        return vFile != null ? vFile.getPath() : "NULL_VFILE";
    }

    @Nullable
    private XmlNSDescriptor getNsDescriptorFormDocType(XmlDoctype doctype, XmlFile containingFile, boolean forHtml) {
        XmlNSDescriptor descriptor = this.getNSDescriptorFromMetaData((PsiMetaOwner)doctype.getMarkupDecl(), true);
        String filePath = XmlDocumentImpl.getFilePathForLogging((PsiFile)containingFile);
        String dtdUri = XmlUtil.getDtdUri(doctype);
        LOG.debug("DTD url for doctype " + doctype.getText() + " in file " + filePath + " is " + dtdUri);
        if (dtdUri != null && !dtdUri.isEmpty()) {
            XmlFile xmlFile = XmlUtil.findNamespace((PsiFile)containingFile, dtdUri);
            if (xmlFile == null) {
                xmlFile = XmlNamespaceIndex.guessDtd(dtdUri, (PsiFile)containingFile);
            }
            String schemaFilePath = XmlDocumentImpl.getFilePathForLogging((PsiFile)xmlFile);
            LOG.debug("Schema file for " + filePath + " is " + schemaFilePath);
            XmlNSDescriptor descriptorFromDtd = this.getNSDescriptorFromMetaData(xmlFile == null ? null : (PsiMetaOwner)AstLoadingFilter.forceAllowTreeLoading((PsiFile)xmlFile, () -> ((XmlFile)xmlFile).getDocument()), forHtml);
            LOG.debug("Descriptor from meta data for schema file " + schemaFilePath + " is " + (descriptorFromDtd != null ? descriptorFromDtd.getClass().getCanonicalName() : "NULL"));
            if (descriptor != null && descriptorFromDtd != null) {
                descriptor = new XmlNSDescriptorSequence(new XmlNSDescriptor[]{descriptor, descriptorFromDtd});
            } else if (descriptorFromDtd != null) {
                descriptor = descriptorFromDtd;
            }
        }
        return descriptor;
    }

    @Nullable
    private XmlNSDescriptor getNSDescriptorFromMetaData(@Nullable PsiMetaOwner metaOwner, boolean nonEmpty) {
        if (metaOwner == null) {
            return null;
        }
        XmlNSDescriptor descriptor = (XmlNSDescriptor)metaOwner.getMetaData();
        if (descriptor == null) {
            return null;
        }
        if (nonEmpty && descriptor.getRootElementsDescriptors((XmlDocument)this).length == 0) {
            return null;
        }
        return descriptor;
    }

    @NotNull
    public CompositePsiElement clone() {
        HashMap<String, CachedValue<XmlNSDescriptor>> cacheStrict = new HashMap<String, CachedValue<XmlNSDescriptor>>(this.myDefaultDescriptorsCacheStrict);
        HashMap<String, CachedValue<XmlNSDescriptor>> cacheNotStrict = new HashMap<String, CachedValue<XmlNSDescriptor>>(this.myDefaultDescriptorsCacheNotStrict);
        XmlDocumentImpl copy = (XmlDocumentImpl)super.clone();
        this.updateSelfDependentDtdDescriptors(copy, cacheStrict, cacheNotStrict);
        return copy;
    }

    public PsiElement copy() {
        HashMap<String, CachedValue<XmlNSDescriptor>> cacheStrict = new HashMap<String, CachedValue<XmlNSDescriptor>>(this.myDefaultDescriptorsCacheStrict);
        HashMap<String, CachedValue<XmlNSDescriptor>> cacheNotStrict = new HashMap<String, CachedValue<XmlNSDescriptor>>(this.myDefaultDescriptorsCacheNotStrict);
        XmlDocumentImpl copy = (XmlDocumentImpl)super.copy();
        this.updateSelfDependentDtdDescriptors(copy, cacheStrict, cacheNotStrict);
        return copy;
    }

    private void updateSelfDependentDtdDescriptors(XmlDocumentImpl copy, HashMap<String, CachedValue<XmlNSDescriptor>> cacheStrict, HashMap<String, CachedValue<XmlNSDescriptor>> cacheNotStrict) {
        XmlNSDescriptor nsDescriptor;
        copy.myDefaultDescriptorsCacheNotStrict = new ConcurrentHashMap<String, CachedValue<XmlNSDescriptor>>();
        copy.myDefaultDescriptorsCacheStrict = new ConcurrentHashMap<String, CachedValue<XmlNSDescriptor>>();
        for (Map.Entry<String, CachedValue<XmlNSDescriptor>> e : cacheStrict.entrySet()) {
            if (!e.getValue().hasUpToDateValue() || this.isGeneratedFromDtd(nsDescriptor = (XmlNSDescriptor)e.getValue().getValue())) continue;
            copy.myDefaultDescriptorsCacheStrict.put(e.getKey(), e.getValue());
        }
        for (Map.Entry<String, CachedValue<XmlNSDescriptor>> e : cacheNotStrict.entrySet()) {
            if (!e.getValue().hasUpToDateValue() || this.isGeneratedFromDtd(nsDescriptor = (XmlNSDescriptor)e.getValue().getValue())) continue;
            copy.myDefaultDescriptorsCacheNotStrict.put(e.getKey(), e.getValue());
        }
    }

    public PsiMetaData getMetaData() {
        return MetaRegistry.getMeta((PsiElement)this);
    }
}

