/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.impl.source.resolve.reference.impl.manipulators.SimpleTagManipulator;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlText;
import org.jetbrains.annotations.NotNull;

public class XmlTagManipulator
extends SimpleTagManipulator<XmlTag> {
    @NotNull
    public TextRange getRangeInElement(@NotNull XmlTag tag) {
        if (tag.getSubTags().length > 0) {
            return TextRange.EMPTY_RANGE;
        }
        XmlTagValue value = tag.getValue();
        XmlText[] texts = value.getTextElements();
        switch (texts.length) {
            case 0: {
                return value.getTextRange().shiftRight(-tag.getTextOffset());
            }
            case 1: {
                return XmlTagManipulator.getValueRange(texts[0]);
            }
        }
        return TextRange.EMPTY_RANGE;
    }

    private static TextRange getValueRange(XmlText xmlText) {
        int offset = xmlText.getStartOffsetInParent();
        String value = xmlText.getValue();
        String trimmed = value.trim();
        int i = value.indexOf(trimmed);
        int start = xmlText.displayToPhysical(i) + offset;
        return trimmed.isEmpty() ? new TextRange(start, start) : new TextRange(start, xmlText.displayToPhysical(i + trimmed.length() - 1) + offset + 1);
    }

    public static TextRange[] getValueRanges(@NotNull XmlTag tag) {
        XmlTagValue value = tag.getValue();
        XmlText[] texts = value.getTextElements();
        if (texts.length == 0) {
            return new TextRange[]{value.getTextRange().shiftRight(-tag.getTextOffset())};
        }
        TextRange[] ranges = new TextRange[texts.length];
        for (int i = 0; i < texts.length; ++i) {
            ranges[i] = XmlTagManipulator.getValueRange(texts[i]);
        }
        return ranges;
    }
}

