/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.html;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.html.HtmlScriptInjectionBlockerExtension;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlScriptLanguageInjector
implements MultiHostInjector {
    @Nullable
    public static Language getScriptLanguageToInject(@NotNull XmlTag xmlTag) {
        Collection languages;
        if (!HtmlUtil.isScriptTag(xmlTag)) {
            return null;
        }
        String mimeType = xmlTag.getAttributeValue("type");
        if (mimeType != null && mimeType.endsWith("+json")) {
            mimeType = "application/json";
        }
        return !(languages = Language.findInstancesByMimeType((String)mimeType)).isEmpty() ? (Language)languages.iterator().next() : Language.ANY;
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        if (!(host.isValid() && host instanceof XmlText && HtmlUtil.isHtmlTagContainingFile(host))) {
            return;
        }
        XmlTag scriptTag = ((XmlText)host).getParentTag();
        if (scriptTag == null) {
            return;
        }
        Language language = HtmlScriptLanguageInjector.getScriptLanguageToInject(scriptTag);
        if (language == null || HtmlScriptInjectionBlockerExtension.isInjectionBlocked(scriptTag, language)) {
            return;
        }
        if (LanguageUtil.isInjectableLanguage((Language)language)) {
            List elements = ContainerUtil.filter((Object[])host.getChildren(), child -> !(child instanceof OuterLanguageElement));
            if (elements.isEmpty()) {
                return;
            }
            registrar.startInjecting(language);
            for (PsiElement child2 : elements) {
                registrar.addPlace(null, null, (PsiLanguageInjectionHost)host, child2.getTextRangeInParent());
            }
            registrar.doneInjecting();
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        return Collections.singletonList(XmlText.class);
    }
}

