/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lang.HtmlInlineScriptTokenTypesProvider;
import com.intellij.lang.HtmlScriptContentProvider;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageHtmlInlineScriptTokenTypesProvider;
import com.intellij.lexer.BaseHtmlLexer;
import com.intellij.lexer.EmbedmentLexer;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.lexer._HtmlLexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlHighlightingLexer
extends BaseHtmlLexer {
    private static final Logger LOG = Logger.getInstance(HtmlHighlightingLexer.class);
    private final int EMBEDDED_LEXER_ON = 1 << this.getBaseStateShift();
    private final int EMBEDDED_LEXER_STATE_SHIFT = this.getBaseStateShift() + 1;
    private final FileType ourStyleFileType;
    protected Lexer elLexer;
    private Lexer embeddedLexer;
    private final Map<String, Lexer> scriptLexers = new HashMap<String, Lexer>();
    private final Map<String, Lexer> styleLexers = new HashMap<String, Lexer>();
    private boolean hasNoEmbeddments;
    private final boolean hasNoLayers = Boolean.TRUE.equals(LayeredLexer.ourDisableLayersFlag.get());

    public HtmlHighlightingLexer() {
        this(null);
    }

    public HtmlHighlightingLexer(FileType styleFileType) {
        this((Lexer)new MergingLexerAdapter((Lexer)new FlexAdapter((FlexLexer)new _HtmlLexer()), TOKENS_TO_MERGE), true, styleFileType);
    }

    protected HtmlHighlightingLexer(Lexer lexer, boolean caseInsensitive, FileType styleFileType) {
        super(lexer, caseInsensitive);
        this.ourStyleFileType = styleFileType;
        XmlEmbeddmentHandler value = new XmlEmbeddmentHandler();
        this.registerHandler(XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, value);
        this.registerHandler(XmlTokenType.XML_START_TAG_START, value);
        this.registerHandler(XmlTokenType.XML_DATA_CHARACTERS, value);
        this.registerHandler(XmlTokenType.XML_COMMENT_CHARACTERS, value);
    }

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        super.start(buffer, startOffset, endOffset, initialState);
        if ((initialState & this.EMBEDDED_LEXER_ON) != 0) {
            int state = this.getEmbeddedLexerState(initialState);
            this.setEmbeddedLexer();
            LOG.assertTrue(this.embeddedLexer != null);
            this.embeddedLexer.start(buffer, startOffset, this.skipToTheEndOfTheEmbeddment(), state);
        } else {
            this.embeddedLexer = null;
            this.scriptLexers.clear();
            this.styleLexers.clear();
        }
    }

    protected int getEmbeddedLexerState(int initialState) {
        return initialState >> this.EMBEDDED_LEXER_STATE_SHIFT;
    }

    protected Lexer getInlineScriptHighlightingLexer() {
        HtmlInlineScriptTokenTypesProvider provider = LanguageHtmlInlineScriptTokenTypesProvider.getInlineScriptProvider(Language.findLanguageByID((String)"JavaScript"));
        FileType fileType = provider != null ? provider.getFileType() : null;
        SyntaxHighlighter syntaxHighlighter = fileType != null ? SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)fileType, null, null) : null;
        return syntaxHighlighter != null ? syntaxHighlighter.getHighlightingLexer() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEmbeddedLexer() {
        if (this.hasNoLayers) {
            LayeredLexer.ourDisableLayersFlag.set(Boolean.TRUE);
        }
        try {
            Lexer newLexer = null;
            if (this.hasSeenStyle()) {
                Lexer styleLexer = this.styleLexers.get(this.styleType);
                if (styleLexer == null) {
                    if (this.hasSeenTag()) {
                        IElementType currentStylesheetElementType = this.getCurrentStylesheetElementType();
                        if (currentStylesheetElementType != null) {
                            Language language = currentStylesheetElementType.getLanguage();
                            styleLexer = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, null, null).getHighlightingLexer();
                        } else if (this.ourStyleFileType != null) {
                            SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)this.ourStyleFileType, null, null);
                            LOG.assertTrue(highlighter != null, (Object)this.ourStyleFileType);
                            styleLexer = highlighter.getHighlightingLexer();
                        }
                        this.styleLexers.put(this.styleType, styleLexer);
                    } else if (this.hasSeenAttribute() && this.ourStyleFileType != null) {
                        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)this.ourStyleFileType, null, null);
                        LOG.assertTrue(highlighter != null, (Object)this.ourStyleFileType);
                        styleLexer = highlighter.getHighlightingLexer();
                    }
                }
                newLexer = styleLexer;
            } else if (this.hasSeenScript()) {
                Lexer scriptLexer = this.scriptLexers.get(this.scriptType);
                if (scriptLexer == null) {
                    if (this.hasSeenTag()) {
                        HtmlScriptContentProvider provider = this.findScriptContentProvider(this.scriptType);
                        scriptLexer = provider != null ? provider.getHighlightingLexer() : SyntaxHighlighterFactory.getSyntaxHighlighter((Language)PlainTextLanguage.INSTANCE, null, null).getHighlightingLexer();
                    } else if (this.hasSeenAttribute()) {
                        scriptLexer = this.getInlineScriptHighlightingLexer();
                    }
                    this.scriptLexers.put(this.scriptType, scriptLexer);
                }
                newLexer = scriptLexer;
            } else {
                newLexer = this.createELLexer(newLexer);
            }
            if (newLexer != null) {
                this.embeddedLexer = newLexer;
            }
        }
        finally {
            if (this.hasNoLayers) {
                LayeredLexer.ourDisableLayersFlag.set(null);
            }
        }
    }

    @Nullable
    protected Lexer createELLexer(Lexer newLexer) {
        return newLexer;
    }

    @Override
    public void advance() {
        if (this.embeddedLexer != null) {
            this.embeddedLexer.advance();
            if (this.embeddedLexer.getTokenType() == null) {
                this.embeddedLexer = null;
            }
        }
        if (this.embeddedLexer == null) {
            super.advance();
        }
    }

    public IElementType getTokenType() {
        int state;
        if (this.embeddedLexer != null) {
            return this.embeddedLexer.getTokenType();
        }
        IElementType tokenType = super.getTokenType();
        if (tokenType == null) {
            return null;
        }
        if (tokenType == XmlTokenType.XML_NAME) {
            int state2 = this.getState() & 0x3F;
            if (this.isHtmlTagState(state2)) {
                tokenType = XmlTokenType.XML_TAG_NAME;
            }
        } else if (tokenType == XmlTokenType.XML_WHITE_SPACE || tokenType == XmlTokenType.XML_REAL_WHITE_SPACE) {
            tokenType = this.hasSeenTag() && (this.hasSeenStyle() || this.hasSeenScript()) ? XmlTokenType.XML_WHITE_SPACE : (this.getState() != 0 ? XmlTokenType.TAG_WHITE_SPACE : XmlTokenType.XML_REAL_WHITE_SPACE);
        } else if ((tokenType == XmlTokenType.XML_CHAR_ENTITY_REF || tokenType == XmlTokenType.XML_ENTITY_REF_TOKEN) && (state = this.getState() & 0x3F) == 4) {
            return XmlTokenType.XML_COMMENT_CHARACTERS;
        }
        return tokenType;
    }

    public int getTokenStart() {
        if (this.embeddedLexer != null) {
            return this.embeddedLexer.getTokenStart();
        }
        return super.getTokenStart();
    }

    public int getTokenEnd() {
        if (this.embeddedLexer != null) {
            return this.embeddedLexer.getTokenEnd();
        }
        return super.getTokenEnd();
    }

    @Override
    public int getState() {
        int state = super.getState();
        state |= this.embeddedLexer != null ? this.EMBEDDED_LEXER_ON : 0;
        if (this.embeddedLexer != null) {
            state |= this.embeddedLexer.getState() << this.EMBEDDED_LEXER_STATE_SHIFT;
        }
        return state;
    }

    @Override
    protected boolean isHtmlTagState(int state) {
        return state == 6 || state == 8;
    }

    public void setHasNoEmbeddments(boolean hasNoEmbeddments) {
        this.hasNoEmbeddments = hasNoEmbeddments;
    }

    public class ElEmbeddmentHandler
    implements BaseHtmlLexer.TokenHandler {
        @Override
        public void handleElement(Lexer lexer) {
            HtmlHighlightingLexer.this.setEmbeddedLexer();
            if (HtmlHighlightingLexer.this.embeddedLexer != null) {
                HtmlHighlightingLexer.this.embeddedLexer.start(HtmlHighlightingLexer.this.getBufferSequence(), HtmlHighlightingLexer.super.getTokenStart(), HtmlHighlightingLexer.super.getTokenEnd());
            }
        }
    }

    public class XmlEmbeddmentHandler
    implements BaseHtmlLexer.TokenHandler {
        @Override
        public void handleElement(Lexer lexer) {
            if (!HtmlHighlightingLexer.this.hasSeenStyle() && !HtmlHighlightingLexer.this.hasSeenScript() || HtmlHighlightingLexer.this.hasNoEmbeddments) {
                return;
            }
            IElementType tokenType = lexer.getTokenType();
            if (tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && HtmlHighlightingLexer.this.hasSeenAttribute() || tokenType == XmlTokenType.XML_START_TAG_START && HtmlHighlightingLexer.this.hasSeenTag() || tokenType == XmlTokenType.XML_DATA_CHARACTERS && HtmlHighlightingLexer.this.hasSeenTag() || tokenType == XmlTokenType.XML_COMMENT_CHARACTERS && HtmlHighlightingLexer.this.hasSeenTag()) {
                HtmlHighlightingLexer.this.setEmbeddedLexer();
                if (HtmlHighlightingLexer.this.embeddedLexer != null) {
                    HtmlHighlightingLexer.this.embeddedLexer.start(HtmlHighlightingLexer.this.getBufferSequence(), HtmlHighlightingLexer.super.getTokenStart(), HtmlHighlightingLexer.this.skipToTheEndOfTheEmbeddment(), HtmlHighlightingLexer.this.embeddedLexer instanceof EmbedmentLexer ? ((EmbedmentLexer)HtmlHighlightingLexer.this.embeddedLexer).getEmbeddedInitialState(tokenType) : 0);
                    if (HtmlHighlightingLexer.this.embeddedLexer.getTokenType() == null) {
                        HtmlHighlightingLexer.this.embeddedLexer = null;
                    }
                }
            }
        }
    }
}

