/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.ide.impl.StructureViewWrapperImpl;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.xml.XmlStructureViewTreeModel;
import com.intellij.ide.structureView.xml.XmlStructureViewBuilderProvider;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointUtil;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlStructureViewBuilderFactory
implements PsiStructureViewFactory {
    public XmlStructureViewBuilderFactory() {
        XmlStructureViewBuilderProvider.EP_NAME.addChangeListener(() -> ((Runnable)ApplicationManager.getApplication().getMessageBus().syncPublisher(StructureViewWrapperImpl.STRUCTURE_CHANGED)).run(), ExtensionPointUtil.createKeyedExtensionDisposable((Object)this, (ExtensionPoint)PsiStructureViewFactory.EP_NAME.getPoint()));
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder(final @NotNull PsiFile psiFile) {
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        StructureViewBuilder builder = XmlStructureViewBuilderFactory.getStructureViewBuilderForExtensions(psiFile);
        if (builder != null) {
            return builder;
        }
        for (XmlStructureViewBuilderProvider xmlStructureViewBuilderProvider : XmlStructureViewBuilderFactory.getStructureViewBuilderProviders()) {
            StructureViewBuilder structureViewBuilder = xmlStructureViewBuilderProvider.createStructureViewBuilder((XmlFile)psiFile);
            if (structureViewBuilder == null) continue;
            return structureViewBuilder;
        }
        return new TreeBasedStructureViewBuilder(){

            @NotNull
            public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                return new XmlStructureViewTreeModel((XmlFile)psiFile, editor);
            }
        };
    }

    private static XmlStructureViewBuilderProvider[] getStructureViewBuilderProviders() {
        return (XmlStructureViewBuilderProvider[])Extensions.getRootArea().getExtensionPoint(XmlStructureViewBuilderProvider.EP_NAME).getExtensions();
    }

    @Nullable
    private static StructureViewBuilder getStructureViewBuilderForExtensions(@NotNull PsiFile psiFile) {
        for (Language language : XMLLanguage.INSTANCE.getLanguageExtensionsForFile(psiFile)) {
            StructureViewBuilder builder;
            PsiStructureViewFactory factory = (PsiStructureViewFactory)LanguageStructureViewBuilder.INSTANCE.forLanguage(language);
            if (factory == null || (builder = factory.getStructureViewBuilder(psiFile)) == null) continue;
            return builder;
        }
        return null;
    }
}

