/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter;

import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.XmlLikeFileType;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.XmlCharsetDetector;
import com.intellij.xml.psi.XmlPsiBundle;
import com.intellij.xml.util.HtmlUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlFileType
extends XmlLikeFileType {
    @NonNls
    public static final String DOT_DEFAULT_EXTENSION = ".html";
    public static final HtmlFileType INSTANCE = new HtmlFileType();

    private HtmlFileType() {
        super((Language)HTMLLanguage.INSTANCE);
    }

    protected HtmlFileType(Language language) {
        super(language);
    }

    @NotNull
    public String getName() {
        return "HTML";
    }

    @NotNull
    public String getDescription() {
        return XmlPsiBundle.message((String)"filetype.description.html", (Object[])new Object[0]);
    }

    @NotNull
    public String getDefaultExtension() {
        return "html";
    }

    public Icon getIcon() {
        return AllIcons.FileTypes.Html;
    }

    @Override
    public String getCharset(@NotNull VirtualFile file, byte @NotNull [] content) {
        String charset;
        LoadTextUtil.DetectResult guessed = LoadTextUtil.guessFromContent((VirtualFile)file, (byte[])content);
        String string = charset = guessed.hardCodedCharset != null ? guessed.hardCodedCharset.name() : XmlCharsetDetector.extractXmlEncodingFromProlog((byte[])content);
        if (charset != null) {
            return charset;
        }
        String strContent = new String(content, StandardCharsets.ISO_8859_1);
        Charset c = HtmlUtil.detectCharsetFromMetaTag(strContent);
        return c == null ? null : c.name();
    }

    @Override
    public Charset extractCharsetFromFileContent(@Nullable Project project, @Nullable VirtualFile file, @NotNull CharSequence content) {
        String name = XmlCharsetDetector.extractXmlEncodingFromProlog((CharSequence)content);
        Charset charset = CharsetToolkit.forName((String)name);
        if (charset != null) {
            return charset;
        }
        return HtmlUtil.detectCharsetFromMetaTag(content);
    }
}

