/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.embedding;

import com.intellij.embedding.EmbeddingElementType;
import com.intellij.embedding.MasqueradingLexer;
import com.intellij.embedding.MasqueradingPsiBuilderAdapter;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmbeddedLazyParseableElementType
extends ILazyParseableElementType
implements EmbeddingElementType {
    public EmbeddedLazyParseableElementType(@NotNull @NonNls String debugName, @Nullable Language language) {
        super(debugName, language);
    }

    public Lexer createLexer(@NotNull ASTNode chameleon, @NotNull Project project, @NotNull Language parentLanguage) {
        Language language = chameleon.getElementType().getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        return parserDefinition.createLexer(project);
    }

    public ASTNode parseAndGetTree(@NotNull PsiBuilder builder) {
        PsiParser parser = this.getParser(builder);
        return parser.parse((IElementType)this, builder);
    }

    protected PsiParser getParser(@NotNull PsiBuilder builder) {
        return ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.getLanguage())).createParser(builder.getProject());
    }

    protected ASTNode doParseContents(@NotNull ASTNode chameleon, @NotNull PsiElement psi) {
        PsiFile file = psi.getContainingFile();
        assert (file != null) : chameleon;
        Project project = file.getProject();
        Language language = chameleon.getElementType().getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        Lexer lexer = this.createLexer(chameleon, project, psi.getLanguage());
        PsiBuilder builder = this.getBuilder(chameleon, project, parserDefinition, lexer, chameleon.getChars());
        return this.parseAndGetTree(builder).getFirstChildNode();
    }

    public PsiBuilder getBuilder(ASTNode chameleon, Project project, ParserDefinition parserDefinition, Lexer lexer, CharSequence chars) {
        Object builder = lexer instanceof MasqueradingLexer ? new MasqueradingPsiBuilderAdapter(project, parserDefinition, (MasqueradingLexer)lexer, chameleon, chars) : new PsiBuilderImpl(project, parserDefinition, lexer, chameleon, chars);
        return builder;
    }
}

