/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.daemon.XmlErrorBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddAttributeValueIntentionFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    public AddAttributeValueIntentionFix(@Nullable PsiElement element) {
        super(element);
    }

    @NotNull
    public String getText() {
        return XmlErrorBundle.message("add.attribute.value.quickfix.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        XmlAttributeValue valueElement;
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getNonStrictParentOfType((PsiElement)startElement, (Class[])new Class[]{XmlAttribute.class});
        if (attribute == null || attribute.getValue() != null) {
            return;
        }
        XmlAttribute attributeWithValue = XmlElementFactory.getInstance((Project)project).createAttribute(attribute.getName(), "", startElement);
        PsiElement newAttribute = attribute.replace((PsiElement)attributeWithValue);
        if (editor != null && newAttribute instanceof XmlAttribute && newAttribute.isValid() && (valueElement = ((XmlAttribute)newAttribute).getValueElement()) != null) {
            editor.getCaretModel().moveToOffset(valueElement.getTextOffset());
            AutoPopupController.getInstance((Project)newAttribute.getProject()).scheduleAutoPopup(editor);
        }
    }
}

