/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.nodes;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.nodes.GenerationNode;
import com.intellij.codeInsight.template.emmet.nodes.MulOperationNode;
import com.intellij.codeInsight.template.emmet.nodes.UnaryMulOperationNode;
import com.intellij.codeInsight.template.emmet.nodes.ZenCodingNode;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoreOperationNode
extends ZenCodingNode {
    private final ZenCodingNode myLeftOperand;
    private final ZenCodingNode myRightOperand;

    public MoreOperationNode(@NotNull ZenCodingNode leftOperand, @NotNull ZenCodingNode rightOperand) {
        this.myLeftOperand = leftOperand;
        this.myRightOperand = rightOperand;
    }

    public ZenCodingNode getLeftOperand() {
        return this.myLeftOperand;
    }

    public ZenCodingNode getRightOperand() {
        return this.myRightOperand;
    }

    @Override
    @NotNull
    public List<ZenCodingNode> getChildren() {
        return ContainerUtil.newLinkedList((Object[])new ZenCodingNode[]{this.myLeftOperand, this.myRightOperand});
    }

    @Override
    public int getApproximateOutputLength(@Nullable CustomTemplateCallback callback) {
        int mul = this.myLeftOperand instanceof MulOperationNode ? ((MulOperationNode)this.myLeftOperand).getRightOperand() : 1;
        return this.myLeftOperand.getApproximateOutputLength(callback) + this.myRightOperand.getApproximateOutputLength(callback) * mul;
    }

    @Override
    @NotNull
    public List<GenerationNode> expand(int numberInIteration, int totalIterations, String surroundedText, CustomTemplateCallback callback, boolean insertSurroundedTextAtTheEnd, GenerationNode parent) {
        if (this.myLeftOperand instanceof MulOperationNode || this.myLeftOperand instanceof UnaryMulOperationNode && surroundedText != null) {
            ArrayList<GenerationNode> result = new ArrayList<GenerationNode>();
            if (this.myLeftOperand instanceof MulOperationNode) {
                MulOperationNode mul = (MulOperationNode)this.myLeftOperand;
                for (int i = 0; i < mul.getRightOperand(); ++i) {
                    List<GenerationNode> parentNodes = mul.getLeftOperand().expand(i, totalIterations, surroundedText, callback, insertSurroundedTextAtTheEnd, parent);
                    for (GenerationNode parentNode : parentNodes) {
                        this.myRightOperand.expand(i, totalIterations, surroundedText, callback, insertSurroundedTextAtTheEnd, parentNode);
                    }
                    result.addAll(parentNodes);
                }
            } else {
                UnaryMulOperationNode unaryMul = (UnaryMulOperationNode)this.myLeftOperand;
                String[] lines = LineTokenizer.tokenize((CharSequence)StringUtil.trim((String)surroundedText), (boolean)false);
                for (int i = 0; i < lines.length; ++i) {
                    String line = lines[i].trim();
                    List<GenerationNode> parentNodes = unaryMul.getOperand().expand(i, totalIterations, line, callback, insertSurroundedTextAtTheEnd, parent);
                    for (GenerationNode parentNode : parentNodes) {
                        this.myRightOperand.expand(i, totalIterations, line, callback, insertSurroundedTextAtTheEnd, parentNode);
                    }
                    result.addAll(parentNodes);
                }
            }
            return result;
        }
        List<GenerationNode> leftGenNodes = this.myLeftOperand.expand(numberInIteration, totalIterations, surroundedText, callback, insertSurroundedTextAtTheEnd, parent);
        if (leftGenNodes.isEmpty()) {
            return this.myRightOperand.expand(numberInIteration, totalIterations, surroundedText, callback, insertSurroundedTextAtTheEnd, parent);
        }
        for (GenerationNode leftGenNode : leftGenNodes) {
            this.myRightOperand.expand(numberInIteration, totalIterations, surroundedText, callback, insertSurroundedTextAtTheEnd, leftGenNode);
        }
        return leftGenNodes;
    }

    public String toString() {
        return ">";
    }
}

