/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.filters;

import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.codeInsight.template.emmet.nodes.GenerationNode;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BemEmmetFilter
extends ZenCodingFilter {
    private static final String SUFFIX = "bem";
    private static final Key<BemState> BEM_STATE = Key.create((String)"BEM_STATE");
    private static final Pattern BLOCK_NAME_PATTERN = Pattern.compile("^[A-z]-");

    @Override
    @NotNull
    public String getDisplayName() {
        return XmlBundle.message((String)"emmet.filter.BEM", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getSuffix() {
        return SUFFIX;
    }

    @Override
    public boolean isMyContext(@NotNull PsiElement context) {
        return context.getLanguage() instanceof XMLLanguage;
    }

    @Override
    @NotNull
    public GenerationNode filterNode(@NotNull GenerationNode node) {
        Map<String, String> attributes = node.getTemplateToken().getAttributes();
        String classAttributeName = this.getClassAttributeName();
        String classValue = attributes.get(classAttributeName);
        EmmetOptions emmetOptions = EmmetOptions.getInstance();
        if (classValue != null && emmetOptions != null) {
            String elementSeparator = emmetOptions.getBemElementSeparator();
            String modifierSeparator = emmetOptions.getBemModifierSeparator();
            String shortElementPrefix = emmetOptions.getBemShortElementPrefix();
            List classNames = ContainerUtil.map(HtmlUtil.splitClassNames(classValue), s -> BemEmmetFilter.normalizeClassName(s, elementSeparator, shortElementPrefix));
            BEM_STATE.set((UserDataHolder)node, (Object)new BemState(BemEmmetFilter.suggestBlockName(classNames), null, null));
            LinkedHashSet newClassNames = new LinkedHashSet();
            for (String className : classNames) {
                ContainerUtil.addAll(newClassNames, BemEmmetFilter.processClassName(className, node, elementSeparator, modifierSeparator));
            }
            attributes.put(classAttributeName, StringUtil.join(newClassNames, (String)" "));
        }
        return node;
    }

    @NotNull
    public String getClassAttributeName() {
        return "class";
    }

    private static Iterable<String> processClassName(@NotNull String className, @NotNull GenerationNode node, @NotNull String elementSeparator, @NotNull String modifierSeparator) {
        className = BemEmmetFilter.fillWithBemElements(className, node, elementSeparator);
        className = BemEmmetFilter.fillWithBemModifiers(className, node, modifierSeparator);
        BemState nodeBemState = (BemState)BEM_STATE.get((UserDataHolder)node);
        BemState bemState = BemEmmetFilter.extractBemStateFromClassName(className, elementSeparator, modifierSeparator);
        ArrayList<String> result = new ArrayList<String>();
        if (!bemState.isEmpty()) {
            String nodeBlockValue = nodeBemState != null ? nodeBemState.getBlock() : null;
            String block = bemState.getBlock();
            if (StringUtil.isEmpty((String)block)) {
                block = StringUtil.notNullize((String)nodeBlockValue);
                bemState.setBlock(block);
            }
            String prefix = block;
            String element = bemState.getElement();
            if (StringUtil.isNotEmpty((String)element)) {
                prefix = prefix + elementSeparator + element;
            }
            result.add(prefix);
            String modifier = bemState.getModifier();
            if (StringUtil.isNotEmpty((String)modifier)) {
                result.add(prefix + modifierSeparator + modifier);
            }
            BemState newNodeBemState = bemState.copy();
            if (StringUtil.isNotEmpty((String)nodeBlockValue) && StringUtil.isEmpty((String)modifier)) {
                newNodeBemState.setBlock(nodeBlockValue);
            }
            BEM_STATE.set((UserDataHolder)node, (Object)newNodeBemState);
        } else {
            result.add(className);
        }
        return result;
    }

    @NotNull
    private static BemState extractBemStateFromClassName(@NotNull String className, String elementSeparator, String modifierSeparator) {
        BemState result = new BemState();
        int indexOfElementSeparator = className.indexOf(elementSeparator);
        if (indexOfElementSeparator >= 0) {
            result.setBlock(className.substring(0, indexOfElementSeparator));
            result.setElement(className.substring(indexOfElementSeparator + elementSeparator.length()));
            int lastIndexOfElementSeparator = className.lastIndexOf(elementSeparator);
            assert (lastIndexOfElementSeparator >= 0);
            int indexOfModifierSeparator = className.indexOf(modifierSeparator, lastIndexOfElementSeparator + elementSeparator.length());
            if (indexOfModifierSeparator >= 0) {
                result.setModifier(className.substring(indexOfModifierSeparator + modifierSeparator.length()));
                result.setElement(className.substring(indexOfElementSeparator + elementSeparator.length(), indexOfModifierSeparator));
            }
        } else {
            int indexOfModifierSeparator = className.indexOf(modifierSeparator);
            if (indexOfModifierSeparator >= 0) {
                result.setBlock(className.substring(0, indexOfModifierSeparator));
                result.setModifier(className.substring(indexOfModifierSeparator + modifierSeparator.length()));
            }
        }
        return result;
    }

    @NotNull
    private static String fillWithBemElements(@NotNull String className, @NotNull GenerationNode node, @NotNull String separator) {
        return BemEmmetFilter.transformClassNameToBemFormat(className, separator, node, false);
    }

    @NotNull
    private static String fillWithBemModifiers(@NotNull String className, @NotNull GenerationNode node, @NotNull String separator) {
        return BemEmmetFilter.transformClassNameToBemFormat(className, separator, node, true);
    }

    @NotNull
    private static String transformClassNameToBemFormat(@NotNull String className, @NotNull String separator, @NotNull GenerationNode node, boolean isModifierSeparator) {
        Pair<String, Integer> cleanStringAndDepth = BemEmmetFilter.getCleanStringAndDepth(className, separator);
        Integer depth = (Integer)cleanStringAndDepth.second;
        if (depth > 0) {
            String prefix;
            GenerationNode donor = node;
            while (donor.getParent() != null && depth > 0) {
                donor = donor.getParent();
                Integer n = depth;
                Integer n2 = depth = Integer.valueOf(depth - 1);
            }
            BemState bemState = (BemState)BEM_STATE.get((UserDataHolder)donor);
            if (bemState != null && !StringUtil.isEmpty((String)(prefix = bemState.getBlock()))) {
                String element = bemState.getElement();
                if (isModifierSeparator && !StringUtil.isEmpty((String)element)) {
                    prefix = prefix + separator + element;
                }
                return prefix + separator + (String)cleanStringAndDepth.first;
            }
        }
        return className;
    }

    @NotNull
    private static Pair<String, Integer> getCleanStringAndDepth(@NotNull String name, @NotNull String separator) {
        int result = 0;
        while (!separator.isEmpty() && name.startsWith(separator)) {
            ++result;
            name = name.substring(separator.length());
        }
        return Pair.create((Object)name, (Object)result);
    }

    @NotNull
    private static String suggestBlockName(Iterable<String> classNames) {
        String result = (String)ContainerUtil.find(classNames, className -> BLOCK_NAME_PATTERN.matcher((CharSequence)className).matches());
        if (result == null) {
            result = (String)ContainerUtil.find(classNames, s -> s != null && !s.isEmpty() && Character.isLetter(s.charAt(0)));
        }
        return StringUtil.notNullize((String)result);
    }

    @NotNull
    private static String normalizeClassName(@NotNull String className, @NotNull String elementSeparator, @NotNull String shortElementPrefix) {
        if (shortElementPrefix.isEmpty() || !className.startsWith(shortElementPrefix)) {
            return className;
        }
        StringBuilder result = new StringBuilder();
        while (className.startsWith(shortElementPrefix)) {
            className = className.substring(shortElementPrefix.length());
            result.append(elementSeparator);
        }
        return result.append(className).toString();
    }

    private static class BemState {
        @Nullable
        private String block;
        @Nullable
        private String element;
        @Nullable
        private String modifier;

        private BemState() {
        }

        private BemState(@Nullable String block, @Nullable String element, @Nullable String modifier) {
            this.block = block;
            this.element = element;
            this.modifier = modifier;
        }

        public void setModifier(@Nullable String modifier) {
            this.modifier = modifier;
        }

        public void setElement(@Nullable String element) {
            this.element = element;
        }

        public void setBlock(@Nullable String block) {
            this.block = block;
        }

        @Nullable
        public String getBlock() {
            return this.block;
        }

        @Nullable
        public String getElement() {
            return this.element;
        }

        @Nullable
        public String getModifier() {
            return this.modifier;
        }

        public boolean isEmpty() {
            return StringUtil.isEmpty((String)this.block) && StringUtil.isEmpty((String)this.element) && StringUtil.isEmpty((String)this.modifier);
        }

        @NotNull
        public BemState copy() {
            return new BemState(this.block, this.element, this.modifier);
        }
    }
}

