/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.codeInsight.template.emmet.CollectCustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.EmmetException;
import com.intellij.codeInsight.template.emmet.EmmetPreviewHint;
import com.intellij.codeInsight.template.emmet.ZenCodingTemplate;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.Collections;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmmetPreviewUtil {
    private EmmetPreviewUtil() {
    }

    @Nullable
    public static String calculateTemplateText(@NotNull Editor editor, @NotNull PsiFile file, boolean expandPrimitiveAbbreviations) {
        String templatePrefix;
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
        CollectCustomTemplateCallback callback = new CollectCustomTemplateCallback(editor, file);
        ZenCodingGenerator generator = ZenCodingTemplate.findApplicableDefaultGenerator(callback, false);
        if (generator instanceof XmlZenCodingGenerator && (templatePrefix = new ZenCodingTemplate().computeTemplateKeyWithoutContextChecking(callback)) != null) {
            try {
                String templateText;
                ZenCodingTemplate.expand(templatePrefix, callback, generator, Collections.emptyList(), expandPrimitiveAbbreviations, 0);
                TemplateImpl template = callback.getGeneratedTemplate();
                String string = templateText = template != null ? template.getTemplateText() : null;
                if (!StringUtil.isEmpty((String)templateText)) {
                    return template.isToReformat() ? EmmetPreviewUtil.reformatTemplateText(file, templateText) : templateText;
                }
            }
            catch (EmmetException e) {
                return e.getMessage();
            }
        }
        return null;
    }

    public static void addEmmetPreviewListeners(final @NotNull Editor editor, final @NotNull PsiFile file, final boolean expandPrimitiveAbbreviations) {
        editor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                EmmetPreviewHint existingHint = EmmetPreviewHint.getExistingHint(editor);
                if (existingHint != null) {
                    existingHint.updateText(new TemplateTextProducer(editor, file, expandPrimitiveAbbreviations));
                } else {
                    e.getDocument().removeDocumentListener((DocumentListener)this);
                }
            }
        });
        editor.getCaretModel().addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                EmmetPreviewHint existingHint = EmmetPreviewHint.getExistingHint(e.getEditor());
                if (existingHint != null) {
                    existingHint.updateText(new TemplateTextProducer(editor, file, expandPrimitiveAbbreviations));
                } else {
                    e.getEditor().getCaretModel().removeCaretListener((CaretListener)this);
                }
            }
        });
    }

    private static String reformatTemplateText(@NotNull PsiFile file, @NotNull String templateText) {
        PsiFile copy = PsiFileFactory.getInstance((Project)file.getProject()).createFileFromText(file.getName(), file.getFileType(), (CharSequence)templateText);
        VirtualFile vFile = copy.getVirtualFile();
        if (vFile != null) {
            vFile.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
        }
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().runUndoTransparentAction(() -> CodeStyleManager.getInstance((Project)file.getProject()).reformat((PsiElement)copy)));
        return copy.getText();
    }

    private static class TemplateTextProducer
    implements Supplier<String> {
        @NotNull
        private final Editor myEditor;
        @NotNull
        private final PsiFile myFile;
        private final boolean myExpandPrimitiveAbbreviations;

        TemplateTextProducer(@NotNull Editor editor, @NotNull PsiFile file, boolean expandPrimitiveAbbreviations) {
            this.myEditor = editor;
            this.myFile = file;
            this.myExpandPrimitiveAbbreviations = expandPrimitiveAbbreviations;
        }

        @Override
        @Nullable
        public String get() {
            return EmmetPreviewUtil.calculateTemplateText(this.myEditor, this.myFile, this.myExpandPrimitiveAbbreviations);
        }
    }
}

