/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.template.emmet.EmmetPreviewHint;
import com.intellij.codeInsight.template.emmet.EmmetPreviewUtil;
import com.intellij.codeInsight.template.impl.editorActions.TypedActionHandlerBase;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmmetPreviewTypedHandler
extends TypedActionHandlerBase {
    public EmmetPreviewTypedHandler(@Nullable TypedActionHandler originalHandler) {
        super(originalHandler);
    }

    public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
        if (this.myOriginalHandler != null) {
            this.myOriginalHandler.execute(editor, charTyped, dataContext);
        }
        if (EmmetOptions.getInstance().isEmmetEnabled() && EmmetOptions.getInstance().isPreviewEnabled()) {
            String templateText;
            PsiFile file;
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            PsiFile psiFile = file = project == null ? null : PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
            if (file == null) {
                return;
            }
            EmmetPreviewHint existingBalloon = EmmetPreviewHint.getExistingHint(editor);
            if (existingBalloon == null && StringUtil.isNotEmpty((String)(templateText = EmmetPreviewUtil.calculateTemplateText(editor, file, false)))) {
                EmmetPreviewHint.createHint((EditorEx)editor, templateText, file.getFileType()).showHint();
                EmmetPreviewUtil.addEmmetPreviewListeners(editor, file, false);
            }
        }
    }
}

