/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.template.HtmlContextType;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.XmlBundle;
import org.jetbrains.annotations.NotNull;

public class HtmlTextContextType
extends TemplateContextType {
    public HtmlTextContextType() {
        super("HTML_TEXT", XmlBundle.message((String)"dialog.edit.template.checkbox.html.text", (Object[])new Object[0]), HtmlContextType.class);
    }

    public boolean isInContext(@NotNull PsiFile file, int offset) {
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)file, (int)offset);
        if (!HtmlContextType.isMyLanguage(language)) {
            return false;
        }
        PsiElement element = file.getViewProvider().findElementAt(offset, language);
        return element == null || HtmlTextContextType.isInContext(element);
    }

    public static boolean isInContext(@NotNull PsiElement element) {
        if (PsiTreeUtil.getParentOfType((PsiElement)element, XmlComment.class) != null && element.getNode().getElementType() != XmlTokenType.XML_COMMENT_START) {
            return false;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, XmlText.class) != null) {
            return true;
        }
        if (element.getNode().getElementType() == XmlTokenType.XML_START_TAG_START) {
            return true;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiErrorElement) {
            parent = parent.getParent();
        }
        return parent instanceof XmlDocument;
    }
}

