/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint.api.impls;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.MutableLookupElement;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.Function;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlParameterInfoHandler
implements ParameterInfoHandler<XmlTag, XmlElementDescriptor> {
    private static final Comparator<XmlAttributeDescriptor> COMPARATOR = Comparator.comparing(PsiMetaData::getName);

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        if (!(item instanceof MutableLookupElement)) {
            return null;
        }
        Object lookupItem = item.getObject();
        if (lookupItem instanceof XmlElementDescriptor) {
            return new Object[]{lookupItem};
        }
        return null;
    }

    public static XmlAttributeDescriptor[] getSortedDescriptors(XmlElementDescriptor p) {
        XmlAttributeDescriptor[] xmlAttributeDescriptors = p.getAttributesDescriptors(null);
        Arrays.sort(xmlAttributeDescriptors, COMPARATOR);
        return xmlAttributeDescriptors;
    }

    public boolean couldShowInLookup() {
        return true;
    }

    public XmlTag findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        XmlElementDescriptor descriptor;
        XmlTag tag = XmlParameterInfoHandler.findXmlTag(context.getFile(), context.getOffset());
        XmlElementDescriptor xmlElementDescriptor = descriptor = tag != null ? tag.getDescriptor() : null;
        if (descriptor == null) {
            return null;
        }
        context.setItemsToShow(new Object[]{descriptor});
        return tag;
    }

    public void showParameterInfo(@NotNull XmlTag element, @NotNull CreateParameterInfoContext context) {
        context.showHint((PsiElement)element, element.getTextRange().getStartOffset() + 1, (ParameterInfoHandler)this);
    }

    public XmlTag findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        PsiElement currentXmlTag;
        XmlTag tag = XmlParameterInfoHandler.findXmlTag(context.getFile(), context.getOffset());
        if (tag != null && ((currentXmlTag = context.getParameterOwner()) == null || currentXmlTag == tag)) {
            return tag;
        }
        return null;
    }

    public void updateParameterInfo(@NotNull XmlTag parameterOwner, @NotNull UpdateParameterInfoContext context) {
        context.setParameterOwner((PsiElement)parameterOwner);
    }

    @Nullable
    private static XmlTag findXmlTag(PsiFile file, int offset) {
        if (!(file instanceof XmlFile)) {
            return null;
        }
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        for (element = element.getParent(); element != null; element = element.getParent()) {
            if (!(element instanceof XmlTag)) continue;
            XmlTag tag = (XmlTag)element;
            PsiElement[] children = tag.getChildren();
            if (offset <= children[0].getTextRange().getStartOffset()) {
                return null;
            }
            for (PsiElement child : children) {
                XmlToken token;
                TextRange range = child.getTextRange();
                if (range.getStartOffset() <= offset && range.getEndOffset() > offset) {
                    return tag;
                }
                if (!(child instanceof XmlToken) || (token = (XmlToken)child).getTokenType() != XmlTokenType.XML_TAG_END) continue;
                return null;
            }
            return null;
        }
        return null;
    }

    public void updateUI(XmlElementDescriptor o, final @NotNull ParameterInfoUIContext context) {
        XmlParameterInfoHandler.updateElementDescriptor(o, context, (Function<? super String, Boolean>)new Function<String, Boolean>(){
            final XmlTag parameterOwner;
            {
                this.parameterOwner = (XmlTag)context.getParameterOwner();
            }

            public Boolean fun(String s) {
                return this.parameterOwner != null && this.parameterOwner.getAttributeValue(s) != null;
            }
        });
    }

    public static void updateElementDescriptor(XmlElementDescriptor descriptor, ParameterInfoUIContext context, Function<? super String, Boolean> attributePresentFun) {
        XmlAttributeDescriptor[] attributes = descriptor != null ? XmlParameterInfoHandler.getSortedDescriptors(descriptor) : XmlAttributeDescriptor.EMPTY;
        StringBuilder buffer = new StringBuilder();
        int highlightStartOffset = -1;
        int highlightEndOffset = -1;
        if (attributes.length == 0) {
            buffer.append(XmlBundle.message((String)"xml.tag.info.no.attributes", (Object[])new Object[0]));
        } else {
            StringBuilder text1 = new StringBuilder(" ");
            StringBuilder text2 = new StringBuilder(" ");
            StringBuilder text3 = new StringBuilder(" ");
            for (XmlAttributeDescriptor attribute : attributes) {
                if (Boolean.TRUE.equals(attributePresentFun.fun((Object)attribute.getName()))) {
                    if (!text1.toString().equals(" ")) {
                        text1.append(", ");
                    }
                    text1.append(attribute.getName());
                    continue;
                }
                if (attribute.isRequired()) {
                    if (!text2.toString().equals(" ")) {
                        text2.append(", ");
                    }
                    text2.append(attribute.getName());
                    continue;
                }
                if (!text3.toString().equals(" ")) {
                    text3.append(", ");
                }
                text3.append(attribute.getName());
            }
            if (!text1.toString().equals(" ") && !text2.toString().equals(" ")) {
                text1.append(", ");
            }
            if (!text2.toString().equals(" ") && !text3.toString().equals(" ")) {
                text2.append(", ");
            }
            if (!text1.toString().equals(" ") && !text3.toString().equals(" ") && text2.toString().equals(" ")) {
                text1.append(", ");
            }
            buffer.append((CharSequence)text1);
            highlightStartOffset = buffer.length();
            buffer.append((CharSequence)text2);
            highlightEndOffset = buffer.length();
            buffer.append((CharSequence)text3);
        }
        context.setupUIComponentPresentation(buffer.toString(), highlightStartOffset, highlightEndOffset, false, false, true, context.getDefaultParameterColor());
    }
}

