/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.codeInsight.editorActions.HtmlSelectioner;
import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class XmlTokenSelectioner
extends ExtendWordSelectionHandlerBase {
    XmlTokenSelectioner() {
    }

    public boolean canSelect(@NotNull PsiElement e) {
        return e instanceof XmlToken && !HtmlSelectioner.canSelectElement(e);
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        XmlToken token = (XmlToken)e;
        if (XmlTokenSelectioner.shouldSelectToken(token)) {
            List ranges = super.select(e, editorText, cursorOffset, editor);
            SelectWordUtil.addWordSelection((boolean)editor.getSettings().isCamelWords(), (CharSequence)editorText, (int)cursorOffset, (List)ranges);
            return ranges;
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        SelectWordUtil.addWordSelection((boolean)editor.getSettings().isCamelWords(), (CharSequence)editorText, (int)cursorOffset, result);
        return result;
    }

    static boolean shouldSelectToken(XmlToken token) {
        return token.getTokenType() != XmlTokenType.XML_DATA_CHARACTERS && token.getTokenType() != XmlTokenType.XML_START_TAG_START && token.getTokenType() != XmlTokenType.XML_END_TAG_START && token.getTokenType() != XmlTokenType.XML_EMPTY_ELEMENT_END && token.getTokenType() != XmlTokenType.XML_TAG_END;
    }
}

