/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;

public class XmlPiTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        int offset;
        if (c == '?' && file.getLanguage() == XMLLanguage.INSTANCE && (offset = editor.getCaretModel().getOffset()) >= 2 && editor.getDocument().getCharsSequence().charAt(offset - 2) == '<') {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiElement at = file.findElementAt(offset - 2);
            if (at != null && at.getNode().getElementType() == XmlTokenType.XML_PI_START && editor.getDocument().getText().indexOf("?>", offset) == -1) {
                editor.getDocument().insertString(offset, (CharSequence)" ?>");
                AutoPopupController.getInstance((Project)project).scheduleAutoPopup(editor);
            }
        }
        return super.charTyped(c, project, editor, file);
    }
}

