/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.CodeStyle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.HtmlCodeStyleSettings;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;

public class XmlEditUtil {
    public static CodeStyleSettings.QuoteStyle quoteStyle(@NotNull PsiFile file) {
        PsiElement context = file.getContext();
        CodeStyleSettings.QuoteStyle style = XmlEditUtil.getQuoteStyleForFile(file);
        if (context != null && !style.quote.isEmpty() && context.getText().startsWith(style.quote)) {
            return style == CodeStyleSettings.QuoteStyle.Double ? CodeStyleSettings.QuoteStyle.Single : CodeStyleSettings.QuoteStyle.Double;
        }
        return style;
    }

    public static String getAttributeQuote(@NotNull PsiFile file) {
        if (HtmlUtil.hasHtml(file) || HtmlUtil.supportsXmlTypedHandlers(file)) {
            return XmlEditUtil.getQuoteStyleForFile((PsiFile)file).quote;
        }
        return "\"";
    }

    @NotNull
    private static CodeStyleSettings.QuoteStyle getQuoteStyleForFile(@NotNull PsiFile file) {
        return ((HtmlCodeStyleSettings)CodeStyle.getSettings((PsiFile)file).getCustomSettings(HtmlCodeStyleSettings.class)).HTML_QUOTE_STYLE;
    }
}

