/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertSchemaPrefixToDefaultIntention
extends PsiElementBaseIntentionAction {
    public static final String NAME = "Reset to default namespace";

    public ConvertSchemaPrefixToDefaultIntention() {
        this.setText(NAME);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        XmlAttribute xmlns = ConvertSchemaPrefixToDefaultIntention.getXmlnsDeclaration(element);
        if (xmlns == null) {
            return;
        }
        SchemaPrefixReference prefixRef = null;
        for (PsiReference ref : xmlns.getReferences()) {
            if (!(ref instanceof SchemaPrefixReference)) continue;
            prefixRef = (SchemaPrefixReference)ref;
            break;
        }
        if (prefixRef == null) {
            return;
        }
        final SchemaPrefix prefix = prefixRef.resolve();
        final String ns = prefixRef.getNamespacePrefix();
        final ArrayList tags = new ArrayList();
        final ArrayList attrs = new ArrayList();
        xmlns.getParent().accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                if (ns.equals(tag.getNamespacePrefix())) {
                    tags.add(tag);
                }
                super.visitXmlTag(tag);
            }

            public void visitXmlAttributeValue(XmlAttributeValue value) {
                if (value.getValue().startsWith(ns + ":")) {
                    for (PsiReference ref : value.getReferences()) {
                        if (!(ref instanceof SchemaPrefixReference) || !ref.isReferenceTo((PsiElement)prefix)) continue;
                        attrs.add((XmlAttribute)value.getParent());
                    }
                }
            }
        });
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{xmlns.getContainingFile()})) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> {
            ConvertSchemaPrefixToDefaultIntention.convertTagsAndAttributes(ns, tags, attrs, project);
            ApplicationManager.getApplication().runWriteAction(() -> xmlns.setName("xmlns"));
        }, NAME, null);
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{xmlns.getContainingFile()}).withName(NAME).run(() -> xmlns.setName("xmlns"));
    }

    private static void convertTagsAndAttributes(String ns, final List<? extends XmlTag> tags, final List<? extends XmlAttribute> attrs, Project project) {
        final int localNameIndex = ns.length() + 1;
        final int totalCount = tags.size() + attrs.size();
        final SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project, "Changing to default namespace", true);
        progressTask.setTask(new SequentialTask(){
            int tagIndex = 0;
            int attrIndex = 0;

            public boolean isDone() {
                return this.tagIndex + this.attrIndex >= totalCount;
            }

            public boolean iteration() {
                progressTask.getIndicator().setFraction((double)(this.tagIndex + this.attrIndex) / (double)totalCount);
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (this.tagIndex < tags.size()) {
                        XmlTag tag;
                        String s;
                        if (!(s = (tag = (XmlTag)tags.get(this.tagIndex++)).getName().substring(localNameIndex)).isEmpty()) {
                            tag.setName(s);
                        }
                    } else if (this.attrIndex < attrs.size()) {
                        XmlAttribute attr = (XmlAttribute)attrs.get(this.attrIndex++);
                        attr.setValue(attr.getValue().substring(localNameIndex));
                    }
                });
                return this.isDone();
            }
        });
        ProgressManager.getInstance().run((Task)progressTask);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        return ConvertSchemaPrefixToDefaultIntention.getXmlnsDeclaration(element) != null;
    }

    @NotNull
    public String getFamilyName() {
        return NAME;
    }

    @Nullable
    private static XmlAttribute getXmlnsDeclaration(PsiElement element) {
        PsiElement parent = element.getParent();
        if (!(parent instanceof XmlElement)) {
            return null;
        }
        for (PsiReference ref : parent.getReferences()) {
            PsiElement tag;
            PsiElement attr;
            PsiElement elem;
            if (!(ref instanceof SchemaPrefixReference) || (elem = ref.resolve()) == null || !((attr = elem.getParent()) instanceof XmlAttribute) || !((tag = attr.getParent()) instanceof XmlTag) || ((XmlTag)tag).getAttribute("xmlns") != null) continue;
            return (XmlAttribute)attr;
        }
        return null;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

