/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.TypeOrElementOrAttributeReference;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddSchemaPrefixIntention
extends PsiElementBaseIntentionAction {
    public static final String NAME = "Insert namespace prefix";

    public AddSchemaPrefixIntention() {
        this.setText(NAME);
    }

    @NotNull
    public String getFamilyName() {
        return NAME;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(final @NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        XmlAttribute xmlns = AddSchemaPrefixIntention.getXmlnsDeclaration(element);
        if (xmlns == null) {
            return;
        }
        final String namespace = xmlns.getValue();
        XmlTag tag = xmlns.getParent();
        if (tag != null) {
            final Set ns = tag.getLocalNamespaceDeclarations().keySet();
            String nsPrefix = Messages.showInputDialog((Project)project, (String)XmlBundle.message((String)"namespace.prefix", (Object[])new Object[0]), (String)StringUtil.capitalize((String)NAME), (Icon)Messages.getInformationIcon(), (String)"", (InputValidator)new InputValidator(){

                public boolean checkInput(String inputString) {
                    return !ns.contains(inputString) && AddSchemaPrefixIntention.isValidPrefix(inputString, project);
                }

                public boolean canClose(String inputString) {
                    return this.checkInput(inputString);
                }
            });
            if (nsPrefix == null) {
                return;
            }
            final ArrayList tags = new ArrayList();
            final ArrayList values = new ArrayList();
            WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{tag.getContainingFile()}).withName(NAME).run(() -> {
                tag.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    public void visitXmlTag(XmlTag tag) {
                        if (tag.getNamespace().equals(namespace) && tag.getNamespacePrefix().isEmpty()) {
                            tags.add(tag);
                        }
                        super.visitXmlTag(tag);
                    }

                    public void visitXmlAttributeValue(XmlAttributeValue value) {
                        XmlTag tag;
                        PsiElement xmlElement;
                        PsiReference ref = null;
                        boolean skip = false;
                        for (PsiReference reference : value.getReferences()) {
                            if (reference instanceof TypeOrElementOrAttributeReference) {
                                ref = reference;
                                continue;
                            }
                            if (!(reference instanceof SchemaPrefixReference)) continue;
                            skip = true;
                            break;
                        }
                        if (!skip && ref != null && (xmlElement = ref.resolve()) instanceof XmlElement && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)xmlElement, XmlTag.class, (boolean)false)) != null && tag.getNamespace().equals(namespace) && ref.getRangeInElement().getLength() == value.getValue().length()) {
                            values.add(value);
                        }
                    }
                });
                for (XmlAttributeValue value : values) {
                    ((XmlAttribute)value.getParent()).setValue(nsPrefix + ":" + value.getValue());
                }
                for (XmlTag xmlTag : tags) {
                    xmlTag.setName(nsPrefix + ":" + xmlTag.getLocalName());
                }
                xmlns.setName("xmlns:" + nsPrefix);
            });
        }
    }

    private static boolean isValidPrefix(String prefix, Project project) {
        try {
            XmlTag tag = XmlElementFactory.getInstance((Project)project).createTagFromText((CharSequence)("<" + prefix + ":foo/>"));
            return "foo".equals(tag.getLocalName());
        }
        catch (IncorrectOperationException e) {
            return false;
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        return AddSchemaPrefixIntention.getXmlnsDeclaration(element) != null;
    }

    @Nullable
    private static XmlAttribute getXmlnsDeclaration(PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof XmlTag) {
            XmlTag tag = (XmlTag)parent;
            if (tag.getNamespacePrefix().isEmpty()) {
                while (tag != null) {
                    XmlAttribute attr = tag.getAttribute("xmlns");
                    if (attr != null) {
                        return attr;
                    }
                    tag = tag.getParentTag();
                }
            }
        } else if (parent instanceof XmlAttribute && ((XmlAttribute)parent).getName().equals("xmlns")) {
            return (XmlAttribute)parent;
        }
        return null;
    }
}

