/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.HtmlCodeStyleMainPanel;
import com.intellij.application.options.HtmlCodeStylePanelExtension;
import com.intellij.application.options.HtmlIndentOptionsEditor;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.XmlLanguageCodeStyleSettingsProvider;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.formatter.xml.HtmlCodeStyleSettings;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public Language getLanguage() {
        return HTMLLanguage.INSTANCE;
    }

    public String getConfigurableDisplayName() {
        return HtmlLanguageCodeStyleSettingsProvider.getDisplayName();
    }

    public static String getDisplayName() {
        return "HTML";
    }

    @Nullable
    public CustomCodeStyleSettings createCustomSettings(CodeStyleSettings settings) {
        return new HtmlCodeStyleSettings(settings);
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        return CodeStyleAbstractPanel.readFromFile(((Object)((Object)this)).getClass(), (String)"preview.html.indent.template");
    }

    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings baseSettings, @NotNull CodeStyleSettings modelSettings) {
        return new HtmlLanguageCodeStyleConfigurable(baseSettings, modelSettings, HtmlLanguageCodeStyleSettingsProvider.getDisplayName());
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        XmlLanguageCodeStyleSettingsProvider.customizeXml(consumer, settingsType);
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new HtmlIndentOptionsEditor();
    }

    private static class HtmlLanguageCodeStyleConfigurable
    extends CodeStyleAbstractConfigurable
    implements Configurable.WithEpDependencies {
        private static final Collection<BaseExtensionPointName<?>> DEPENDENCIES = Collections.singletonList(HtmlCodeStylePanelExtension.EP_NAME);

        private HtmlLanguageCodeStyleConfigurable(@NotNull CodeStyleSettings baseSettings, @NotNull CodeStyleSettings modelSettings, @NotNull String displayName) {
            super(baseSettings, modelSettings, displayName);
        }

        protected CodeStyleAbstractPanel createPanel(CodeStyleSettings settings) {
            return new HtmlCodeStyleMainPanel(this.getCurrentSettings(), settings);
        }

        public String getHelpTopic() {
            return "reference.settingsdialog.IDE.globalcodestyle.html";
        }

        @NotNull
        public Collection<BaseExtensionPointName<?>> getDependencies() {
            return DEPENDENCIES;
        }
    }
}

