/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;

public class RenameXmlTagQuickFix
extends DefaultLintQuickFix {
    private final String myNewName;

    public RenameXmlTagQuickFix(@NotNull String newName) {
        super("Use " + newName);
        this.myNewName = newName;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        XmlTag currentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
        if (currentTag == null) {
            return;
        }
        XmlTag parentTag = currentTag.getParentTag();
        if (parentTag == null) {
            return;
        }
        XmlTag newTag = parentTag.createChildTag(this.myNewName, null, currentTag.isEmpty() ? null : currentTag.getValue().getText(), true);
        for (XmlAttribute attr : currentTag.getAttributes()) {
            newTag.setAttribute(attr.getLocalName(), attr.getNamespace(), attr.getValue());
        }
        currentTag.replace((PsiElement)newTag);
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return startElement.isValid() && endElement.isValid() && PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class) != null;
    }
}

