/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.codeInsight.highlighting.TooltipLinkHandler;
import com.intellij.openapi.editor.Editor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LintInspectionDescriptionLinkHandler
extends TooltipLinkHandler {
    public String getDescription(@NotNull String refSuffix, @NotNull Editor editor) {
        Issue issue = new BuiltinIssueRegistry().getIssue(refSuffix);
        if (issue == null) {
            issue = AndroidLintInspectionBase.findIssueByShortName(editor.getProject(), refSuffix);
        }
        if (issue != null) {
            String html = issue.getExplanation(TextFormat.HTML);
            html = html.replace("\n", "");
            StringBuilder sb = new StringBuilder(html);
            sb.append("<br><br>Issue id: ").append(issue.getId());
            List urls = issue.getMoreInfo();
            if (!urls.isEmpty()) {
                sb.append("<br><br>More info:<br>");
                for (String url : urls) {
                    sb.append("<a href=\"").append(url).append("\">").append(url).append("</a><br>");
                }
            }
            return sb.toString();
        }
        return null;
    }
}

