/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.LintBundle;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.idea.lint.common.ReplaceStringQuickFix;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintGradleDynamicVersionInspection
extends AndroidLintInspectionBase {
    public AndroidLintGradleDynamicVersionInspection() {
        super(LintBundle.message("android.lint.inspections.gradle.dynamic.version", new Object[0]), GradleDetector.PLUS);
    }

    @Override
    @NotNull
    public LintIdeQuickFix[] getQuickFixes(final @NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData) {
        final GradleCoordinate plus = (GradleCoordinate)LintFix.getData((LintFix)fixData, GradleCoordinate.class);
        if (plus != null && plus.getArtifactId() != null) {
            return new LintIdeQuickFix[]{new ReplaceStringQuickFix("Replace with specific version", null, plus.getRevision(), "specific version"){

                @Override
                @Nullable
                protected String getNewValue() {
                    return LintIdeSupport.get().resolveDynamic(startElement.getProject(), plus);
                }
            }};
        }
        return super.getQuickFixes(startElement, endElement, message, fixData);
    }
}

