/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.analytics;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Scanner;
import org.jetbrains.annotations.NotNull;

public class StudioCrashDetails {
    public static final StudioCrashDetails UNKNOWN = new StudioCrashDetails("<unknown>", false, -1L, "", "", "", "");
    private static final String JVM_CRASH_FILE_STRING_FORMAT = System.getProperty("user.home") + File.separator + "java_error_in_STUDIO_%d.log";
    private final String myDescription;
    private final boolean myJvmCrash;
    private final long myUptimeInMs;
    private final String myErrorSignal;
    private final String myErrorFrame;
    private final String myErrorThread;
    private final String myNativeStack;

    private StudioCrashDetails(String description, boolean isJvmCrash, long uptimeInMs, String errorSignal, String errorFrame, String errorThread, String nativeStack) {
        this.myDescription = description;
        this.myJvmCrash = isJvmCrash;
        this.myUptimeInMs = uptimeInMs;
        this.myErrorSignal = errorSignal;
        this.myErrorFrame = errorFrame;
        this.myErrorThread = errorThread;
        this.myNativeStack = nativeStack;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static StudioCrashDetails loadFromRecordFile(File record) throws IOException {
        BasicFileAttributes attrs;
        long crashDateInMs;
        Path jvmCrashReportFile;
        List lines = FileUtil.loadLines((File)record);
        String buildNumber = !lines.isEmpty() ? (String)lines.get(0) : "";
        String runtimeVersion = lines.size() > 1 ? (String)lines.get(1) : "";
        long startupDateInMs = -1L;
        if (lines.size() > 2) {
            try {
                startupDateInMs = Long.parseLong((String)lines.get(2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        long pid = -1L;
        if (lines.size() > 3) {
            try {
                pid = Long.parseLong((String)lines.get(3));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        boolean isJvmCrash = false;
        long uptimeInMs = -1L;
        String errorSignal = "";
        String errorFrame = "";
        String errorThread = "";
        String nativeStack = "";
        if (startupDateInMs != -1L && pid >= 0L && Files.exists(jvmCrashReportFile = Paths.get(String.format(JVM_CRASH_FILE_STRING_FORMAT, pid), new String[0]), new LinkOption[0]) && (crashDateInMs = (attrs = Files.readAttributes(jvmCrashReportFile, BasicFileAttributes.class, new LinkOption[0])).creationTime().toMillis()) > startupDateInMs) {
            isJvmCrash = true;
            uptimeInMs = crashDateInMs - startupDateInMs;
            try (Scanner scanner = new Scanner(jvmCrashReportFile);){
                block13: while (scanner.hasNext() && (errorSignal.isEmpty() || errorFrame.isEmpty() || errorThread.isEmpty() || nativeStack.isEmpty())) {
                    StringBuilder nativeStackBuilder;
                    if (scanner.findInLine("#  SIG") != null) {
                        errorSignal = "SIG" + scanner.nextLine();
                        continue;
                    }
                    if (scanner.findInLine("#  EXCEPTION") != null) {
                        errorSignal = "EXCEPTION" + scanner.nextLine();
                        continue;
                    }
                    if (scanner.findInLine("# Problematic frame:") != null) {
                        scanner.nextLine();
                        errorFrame = scanner.nextLine().substring(2);
                        continue;
                    }
                    if (scanner.findInLine("Current thread \\(.+\\):") != null) {
                        errorThread = scanner.nextLine().trim();
                        continue;
                    }
                    if (scanner.findInLine("Native frames:") != null) {
                        scanner.nextLine();
                        nativeStackBuilder = new StringBuilder();
                    } else {
                        scanner.nextLine();
                        continue;
                    }
                    while (scanner.hasNext()) {
                        String line = scanner.nextLine();
                        if (line.isEmpty()) {
                            nativeStack = nativeStackBuilder.toString();
                            continue block13;
                        }
                        nativeStackBuilder.append(line.trim()).append('\n');
                    }
                }
            }
        }
        String description = buildNumber + "\n" + runtimeVersion;
        return new StudioCrashDetails(description, isJvmCrash, uptimeInMs, errorSignal, errorFrame, errorThread, nativeStack);
    }

    public boolean isJvmCrash() {
        return this.myJvmCrash;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public long getUptimeInMs() {
        return this.myUptimeInMs;
    }

    public String getErrorSignal() {
        return this.myErrorSignal;
    }

    public String getErrorFrame() {
        return this.myErrorFrame;
    }

    public String getErrorThread() {
        return this.myErrorThread;
    }

    public String getNativeStack() {
        return this.myNativeStack;
    }
}

