/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.jsonRpc.socket;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.nio.channels.ClosedChannelException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.jsonRpc.Client;

public class SocketClient
extends Client {
    protected SocketClient(@NotNull Channel channel) {
        super(channel);
    }

    @Override
    @NotNull
    public ChannelFuture send(@NotNull ByteBuf message) {
        if (this.channel.isOpen()) {
            ByteBuf lengthBuffer = this.channel.alloc().ioBuffer(4);
            lengthBuffer.writeInt(message.readableBytes());
            this.channel.write((Object)lengthBuffer);
            return this.channel.writeAndFlush((Object)message);
        }
        return this.channel.newFailedFuture((Throwable)new ClosedChannelException());
    }

    @Override
    public void sendHeartbeat() {
    }
}

