/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.cdsAgent;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LogLoadedApplicationClassesAgent {
    public static final String TARGET_FILE = "JB_CDS_TARGET_FILE";
    public static final String USE_APP_CDS = "JB_CDS_USE_APP_CDS";

    public static void premain(String agentArgs, Instrumentation inst) {
        try {
            LogLoadedApplicationClassesAgent.premainImpl(agentArgs, inst);
        }
        catch (Throwable t) {
            LogLoadedApplicationClassesAgent.log("Failed to setup LogLoadedApplicationClassesAgent agent", t);
        }
    }

    public static void agentmain(String agentArgs, Instrumentation inst) {
        try {
            LogLoadedApplicationClassesAgent.log("Injecting LogLoadedApplicationClassesAgent: " + agentArgs);
            TransitiveClassesCollector myAllClasses = new TransitiveClassesCollector();
            myAllClasses.addClasses(inst);
            LogLoadedApplicationClassesAgent.logDetectedClasses(true, new File(agentArgs), myAllClasses.getAllClasses());
            LogLoadedApplicationClassesAgent.log("LogLoadedApplicationClassesAgent completed");
        }
        catch (Throwable t) {
            LogLoadedApplicationClassesAgent.log("Failed to setup LogLoadedApplicationClassesAgent agent", t);
        }
    }

    private static void premainImpl(String agentArgs, Instrumentation inst) {
        LogLoadedApplicationClassesAgent.log("");
        LogLoadedApplicationClassesAgent.log("Starting LogLoadedApplicationClassesAgent: " + agentArgs);
        LogLoadedApplicationClassesAgent.log("");
        String targetFileName = System.getenv().get(TARGET_FILE);
        boolean useAppCDS = Boolean.valueOf(System.getenv().getOrDefault(USE_APP_CDS, "true"));
        if (targetFileName == null) {
            LogLoadedApplicationClassesAgent.log("Failed to find JB_CDS_TARGET_FILE parameter to -javaagentpath");
            return;
        }
        File targetFile = new File(targetFileName);
        targetFile.getParentFile().mkdirs();
        TransitiveClassesCollector myAllClasses = new TransitiveClassesCollector();
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(@NotNull Runnable r) {
                Thread thread = new Thread(r, "LogLoadedApplicationClassesAgent-watcher");
                thread.setDaemon(true);
                return thread;
            }
        });
        executor.scheduleWithFixedDelay(() -> myAllClasses.addClasses(inst), 0L, 20L, TimeUnit.MILLISECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LogLoadedApplicationClassesAgent.log("Shutdown is started...");
            executor.shutdown();
            try {
                executor.awaitTermination(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LogLoadedApplicationClassesAgent.log("Failed to wait for classes dump thread termination", e);
            }
            LogLoadedApplicationClassesAgent.logDetectedClasses(useAppCDS, targetFile, myAllClasses.getAllClasses());
        }, "LogLoadedApplicationClassesAgent-shutdown"));
        LogLoadedApplicationClassesAgent.log("LogLoadedApplicationClassesAgent was configured");
    }

    private static void logDetectedClasses(boolean useAppCDS, File targetFile, Collection<Class<?>> allClasses) {
        Path basePath;
        try {
            basePath = new File(".").getCanonicalFile().toPath();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to resolve current working directory path", e);
        }
        ClassesLogger logger = new ClassesLogger(basePath, useAppCDS);
        HashSet withoutSource = new HashSet();
        HashSet libSource = new HashSet();
        HashSet pluginsSource = new HashSet();
        allClasses.stream().sorted(Comparator.comparing(clazz -> clazz.getName())).forEach(clazz -> {
            String source = LogLoadedApplicationClassesAgent.getSourceForClassesList(basePath, clazz);
            if (source == null) {
                withoutSource.add((Class<?>)clazz);
            } else if (!source.contains("plugins/")) {
                libSource.add((Class<?>)clazz);
            } else {
                pluginsSource.add((Class<?>)clazz);
            }
        });
        logger.addComment("System CDS block " + withoutSource.size() + " classes");
        logger.logClass(Object.class);
        logger.attachClasses(withoutSource);
        if (useAppCDS) {
            logger.addComment("\n\nApplication CDS block, " + (libSource.size() + pluginsSource.size()) + " classes");
            logger.attachClasses(libSource);
            logger.attachClasses(pluginsSource);
        } else {
            logger.addComment("\n\nApplication CDS is DISABLED, skipping " + libSource.size() + pluginsSource.size() + " classes ");
        }
        try {
            logger.writeClassesList(targetFile);
        }
        catch (Throwable e) {
            LogLoadedApplicationClassesAgent.log("Failed to write report file to " + targetFile, e);
        }
        LogLoadedApplicationClassesAgent.log("===================================================");
        LogLoadedApplicationClassesAgent.log("Created classes list file to " + targetFile);
        LogLoadedApplicationClassesAgent.log("System classes: " + withoutSource.size());
        LogLoadedApplicationClassesAgent.log("Application classes: " + (libSource.size() + pluginsSource.size()));
        LogLoadedApplicationClassesAgent.log("AppCDS is " + (useAppCDS ? "enabled" : "DISABLED"));
        LogLoadedApplicationClassesAgent.log("===================================================");
    }

    /*
     * Exception decompiling
     */
    private static ClassVersionAssertOutcome assertClassVersion(ClassInfo info) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    private static String getSourceForClassesList(@Nullable Path basePath, @NotNull Class<?> clazz) {
        ClassLoader loader = clazz.getClassLoader();
        if (loader == null) {
            return null;
        }
        if (loader == ClassLoader.getSystemClassLoader()) {
            return null;
        }
        String resourceName = LogLoadedApplicationClassesAgent.getClassResourcePath(clazz);
        URL url = loader.getResource(resourceName);
        if (url == null) {
            return null;
        }
        String path = url.toString();
        if (path.startsWith("jar:")) {
            int sep = path.lastIndexOf("!/");
            path = path.substring(4, sep);
        }
        if (path.startsWith("jrt:")) {
            return null;
        }
        if (!path.startsWith("file:")) {
            LogLoadedApplicationClassesAgent.log("Class " + clazz.getName() + " has unexpected source: " + url);
            return path;
        }
        if (basePath != null) {
            try {
                Path resolvedPath = Paths.get(URI.create(path));
                try {
                    path = basePath.relativize(resolvedPath).toString();
                }
                catch (Throwable t) {
                    path = resolvedPath.toString();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return path;
    }

    @NotNull
    private static String getVMClassName(@NotNull Class<?> clazz) {
        return clazz.getName().replace('.', '/');
    }

    @NotNull
    private static String getClassResourcePath(@NotNull Class<?> clazz) {
        return LogLoadedApplicationClassesAgent.getVMClassName(clazz) + ".class";
    }

    private static void log(String message) {
        System.out.println("[CDS-AGENT] " + message);
    }

    private static void log(String message, @Nullable Throwable t) {
        LogLoadedApplicationClassesAgent.log(message + ". " + t);
        if (t != null) {
            t.printStackTrace();
        }
    }

    private static enum ClassVersionAssertOutcome {
        OK,
        TOO_OLD,
        NOT_FOUND,
        ERROR;

    }

    private static class ClassesLogger {
        private int myIdCounter = 0;
        private final Map<Class<?>, ClassInfo> myClasses = new LinkedHashMap();
        private final List<String> myLog = new ArrayList<String>();
        private final Path basePath;
        private final boolean useAppCDS;

        private ClassesLogger(Path basePath, boolean useAppCDS) {
            this.basePath = basePath;
            this.useAppCDS = useAppCDS;
        }

        public void addComment(@NotNull String comment) {
            for (String line : comment.split("\n")) {
                this.myLog.add("### " + line);
            }
        }

        @NotNull
        private ClassInfo logClass(@NotNull Class<?> clazz) {
            try {
                String source = LogLoadedApplicationClassesAgent.getSourceForClassesList(this.basePath, clazz);
                ClassInfo info = this.myClasses.get(clazz);
                if (info != null) {
                    return info;
                }
                info = new ClassInfo(++this.myIdCounter, clazz, source);
                this.myClasses.put(clazz, info);
                Class<Object> superclass = clazz.getSuperclass();
                if (superclass == null) {
                    superclass = Object.class;
                }
                info.superClass = this.logClass(superclass);
                ArrayList<ClassInfo> interfaces = new ArrayList<ClassInfo>();
                for (Class<?> aClass : clazz.getInterfaces()) {
                    interfaces.add(this.logClass(aClass));
                }
                info.interfaces = interfaces;
                return info;
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to process class " + clazz.getName(), t);
            }
        }

        public void attachClasses(Collection<Class<?>> classes) {
            classes.forEach(this::logClass);
            Map<String, List<ClassInfo>> classesByNames = this.myClasses.values().stream().collect(Collectors.groupingBy(info -> ((ClassInfo)info).name));
            for (Map.Entry<String, List<ClassInfo>> entry : classesByNames.entrySet()) {
                if (entry.getValue().size() <= 1) {
                    entry.getValue().forEach(info -> ((ClassInfo)info).hasSameNamedClasses = false);
                    continue;
                }
                ClassInfo classWithSource = null;
                ClassInfo classWithoutSource = null;
                for (ClassInfo info2 : entry.getValue()) {
                    if (info2.hasSameNamedClasses == null || Boolean.TRUE.equals(info2.hasSameNamedClasses)) continue;
                    if (info2.source == null) {
                        classWithoutSource = info2;
                        continue;
                    }
                    classWithSource = info2;
                }
                for (ClassInfo info2 : entry.getValue()) {
                    if (info2.hasSameNamedClasses != null) continue;
                    if (classWithoutSource == null && info2.source == null) {
                        classWithoutSource = info2;
                        info2.hasSameNamedClasses = false;
                        continue;
                    }
                    if (classWithSource == null && info2.source != null) {
                        classWithSource = info2;
                        info2.hasSameNamedClasses = false;
                        continue;
                    }
                    info2.hasSameNamedClasses = true;
                }
            }
            this.myClasses.values().forEach(this::isValid);
            this.myClasses.values().stream().sorted(Comparator.comparing(info -> ((ClassInfo)info).name)).forEach(this::logLine);
        }

        private boolean isValid(@NotNull ClassInfo info) {
            if (info.isValid != null) {
                return info.isValid;
            }
            if (info.clazz.getClassLoader() == null || info.clazz.getClassLoader() == ClassLoader.getSystemClassLoader()) {
                info.isValid = true;
                return true;
            }
            ArrayList<String> isNotValidReasons = new ArrayList<String>();
            if (!this.useAppCDS && info.source != null) {
                isNotValidReasons.add("the class has non-system source with disabled AppCDS");
            }
            if (info.source != null) {
                if (info.source.contains(" ")) {
                    isNotValidReasons.add("the class has whitespace in path, which is not supported by the JVM");
                }
                if (!info.source.endsWith(".jar")) {
                    isNotValidReasons.add("only .jar files are supported by CDS");
                }
            }
            info.assertClassVersion = LogLoadedApplicationClassesAgent.assertClassVersion(info);
            switch (info.assertClassVersion) {
                case ERROR: {
                    isNotValidReasons.add("class version assert failed");
                    break;
                }
                case NOT_FOUND: {
                    isNotValidReasons.add(".class is not found in the resources");
                    break;
                }
                case TOO_OLD: {
                    isNotValidReasons.add("class version is too old: " + info.myTooOldClassVersion);
                    break;
                }
                case OK: {
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown case " + info.myTooOldClassVersion + " for " + info.name);
                }
            }
            if (Boolean.TRUE.equals(info.hasSameNamedClasses)) {
                isNotValidReasons.add("same named class already exists");
            }
            if (!this.isValid(info.superClass)) {
                isNotValidReasons.add("invalid superclass " + info.superClass.name);
            }
            for (ClassInfo anInterface : info.interfaces) {
                if (this.isValid(anInterface)) continue;
                isNotValidReasons.add("invalid interface " + anInterface.name);
            }
            if (!isNotValidReasons.isEmpty()) {
                info.myIsNotValidReasons = isNotValidReasons;
            }
            info.isValid = isNotValidReasons.isEmpty();
            return info.isValid;
        }

        private void logLine(@NotNull ClassInfo info) {
            if (info.isLogged) {
                return;
            }
            info.isLogged = true;
            if (!this.isValid(info)) {
                return;
            }
            this.logLine(info.superClass);
            for (ClassInfo anInterface : info.interfaces) {
                this.logLine(anInterface);
            }
            this.myLog.add(info.toLine());
        }

        @NotNull
        public List<String> generateReportHeader() {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("       use AppCDS: " + this.useAppCDS);
            lines.add("    Total classes: " + this.myClasses.size());
            lines.add("   system classes: " + this.myClasses.values().stream().filter(info -> ((ClassInfo)info).source == null).count());
            lines.add("  pre 1.6 classes: " + this.myClasses.values().stream().filter(info -> ((ClassInfo)info).myTooOldClassVersion != null).count());
            lines.add("  ignored classes: " + this.myClasses.values().stream().filter(info -> !this.isValid((ClassInfo)info)).count());
            lines.add("");
            return lines;
        }

        @NotNull
        public List<String> generateReportWarnings() {
            List allInfos = this.myClasses.values().stream().sorted(Comparator.comparing(info -> ((ClassInfo)info).name)).collect(Collectors.toList());
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("Pre 1.6 classes:");
            for (ClassInfo item : allInfos) {
                if (item.myTooOldClassVersion == null) continue;
                lines.add("  " + item.name + " has version " + item.myTooOldClassVersion);
            }
            lines.add("Same classes from different JARs:");
            Map groupByName = allInfos.stream().collect(Collectors.groupingBy(info -> ((ClassInfo)info).name, TreeMap::new, Collectors.toList()));
            for (Map.Entry entry : groupByName.entrySet()) {
                if (((List)entry.getValue()).size() <= 1) continue;
                lines.add("  " + (String)entry.getKey());
                for (ClassInfo source : (List)entry.getValue()) {
                    lines.add("    " + source.source);
                }
            }
            lines.add("Transitively invalid classes:");
            for (ClassInfo classInfo : allInfos) {
                if (classInfo.myIsNotValidReasons == null) continue;
                lines.add("  " + classInfo.name);
                for (String warning : classInfo.myIsNotValidReasons) {
                    lines.add("    " + warning);
                }
            }
            return lines;
        }

        public void writeClassesList(@NotNull File file) throws IOException {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("### Classes List for IntelliJ based IDE");
            for (String line : this.generateReportHeader()) {
                lines.add("### " + line);
            }
            lines.add("###");
            lines.add("### see detailed report at the end of the file");
            lines.add("###");
            lines.addAll(this.myLog);
            lines.add("#################################################### ");
            lines.add("### ");
            lines.add("### Warnings report:");
            for (String rant : this.generateReportWarnings()) {
                lines.add("### " + rant);
            }
            Files.write(file.toPath(), lines, StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }

    private static final class ClassInfo {
        private final int id;
        private final Class<?> clazz;
        private final String source;
        private final String name;
        private ClassInfo superClass = null;
        private List<ClassInfo> interfaces = null;
        private ClassVersionAssertOutcome assertClassVersion;
        private Boolean hasSameNamedClasses = null;
        private Boolean isValid = null;
        private boolean isLogged = false;
        private List<String> myIsNotValidReasons = null;
        private Integer myTooOldClassVersion = null;

        private ClassInfo(int id, @NotNull Class<?> clazz, @Nullable String source) {
            this.id = id;
            this.clazz = clazz;
            this.source = source;
            this.name = LogLoadedApplicationClassesAgent.getVMClassName(clazz);
        }

        @NotNull
        String toLine() {
            StringBuilder lineBuilder = new StringBuilder();
            lineBuilder.append(this.name).append(" id: ").append(this.id);
            if (this.source != null) {
                lineBuilder.append(" super: ").append(this.superClass.id);
                if (!this.interfaces.isEmpty()) {
                    lineBuilder.append(" interfaces:");
                    for (ClassInfo anInterface : this.interfaces) {
                        lineBuilder.append(" ").append(anInterface.id);
                    }
                }
                lineBuilder.append(" source: ").append(this.source);
            }
            return lineBuilder.toString();
        }

        static /* synthetic */ Integer access$1502(ClassInfo x0, Integer x1) {
            x0.myTooOldClassVersion = x1;
            return x0.myTooOldClassVersion;
        }
    }

    private static class TransitiveClassesCollector {
        final Set<Class<?>> allMyClasses = new HashSet();

        private TransitiveClassesCollector() {
        }

        public void addClasses(@NotNull Instrumentation inst) {
            try {
                this.addClasses(inst.getAllLoadedClasses());
            }
            catch (Throwable t) {
                LogLoadedApplicationClassesAgent.log("Failed to collect all classes from Instrumentation", t);
            }
        }

        private void addClasses(@NotNull Class<?>[] classes) {
            Class next;
            ArrayDeque queue = new ArrayDeque();
            Collections.addAll(queue, classes);
            while ((next = (Class)queue.poll()) != null) {
                String className = next.getName();
                try {
                    if (next.isArray() || className.contains("$$Lambda$") || className.startsWith("java.lang.invoke.LambdaForm$") || className.startsWith("jdk.internal.reflect.Generated") || className.startsWith("com.sun.proxy.$Proxy") || className.contains(".$Proxy") || className.startsWith("java.lang.invoke.BoundMethodHandle$") || !this.allMyClasses.add(next)) continue;
                    Class superclass = next.getSuperclass();
                    if (superclass != null) {
                        queue.add(superclass);
                    }
                    Collections.addAll(queue, next.getInterfaces());
                }
                catch (Throwable t) {
                    LogLoadedApplicationClassesAgent.log("Failed to process " + className, t);
                }
            }
        }

        @NotNull
        public Collection<Class<?>> getAllClasses() {
            return this.allMyClasses;
        }
    }
}

