/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.targets;

import com.intellij.util.Consumer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;
import org.jetbrains.kotlin.build.CommonBuildMetaInfo;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2MetadataCompilerArguments;
import org.jetbrains.kotlin.compilerRunner.JpsCompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.JpsKotlinCompilerRunner;
import org.jetbrains.kotlin.jps.build.JpsUtilKt;
import org.jetbrains.kotlin.jps.build.KotlinCompileContext;
import org.jetbrains.kotlin.jps.build.KotlinDirtySourceFilesHolder;
import org.jetbrains.kotlin.jps.model.ModuleSettingsKt;
import org.jetbrains.kotlin.jps.targets.KotlinModuleBuildTarget;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J&\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0$2\u0006\u0010%\u001a\u00020\u0019H\u0002J \u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u00192\u0006\u00102\u001a\u00020(H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0014\u0010\u0016\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001bR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0013\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/jps/targets/KotlinCommonModuleBuildTarget;", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "Lorg/jetbrains/kotlin/build/CommonBuildMetaInfo;", "kotlinContext", "Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "jpsModuleBuildTarget", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "(Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;Lorg/jetbrains/jps/incremental/ModuleBuildTarget;)V", "buildMetaInfoFactory", "Lorg/jetbrains/kotlin/build/CommonBuildMetaInfo$Companion;", "getBuildMetaInfoFactory", "()Lorg/jetbrains/kotlin/build/CommonBuildMetaInfo$Companion;", "buildMetaInfoFileName", "", "getBuildMetaInfoFileName", "()Ljava/lang/String;", "dependenciesOutputDirs", "", "getDependenciesOutputDirs", "()Ljava/util/List;", "destination", "getDestination", "globalLookupCacheId", "getGlobalLookupCacheId", "hasCaches", "", "getHasCaches", "()Z", "isIncrementalCompilationEnabled", "libraryFiles", "getLibraryFiles", "addDependencyMetaFile", "", "module", "Lorg/jetbrains/jps/model/module/JpsModule;", "result", "", "isTests", "compileModuleChunk", "commonArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "dirtyFilesHolder", "Lorg/jetbrains/kotlin/jps/build/KotlinDirtySourceFilesHolder;", "environment", "Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;", "createCacheStorage", "", "paths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "isEnabled", "chunkCompilerArguments", "kotlin.jps-plugin"})
public final class KotlinCommonModuleBuildTarget
extends KotlinModuleBuildTarget<CommonBuildMetaInfo> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEnabled(@NotNull CommonCompilerArguments chunkCompilerArguments) {
        Intrinsics.checkNotNullParameter((Object)chunkCompilerArguments, (String)"chunkCompilerArguments");
        K2MetadataCompilerArguments k2MetadataArguments = ModuleSettingsKt.getK2MetadataCompilerArguments(this.getModule());
        if (k2MetadataArguments.getEnabledInJps()) return true;
        CommonCompilerArguments commonCompilerArguments = chunkCompilerArguments;
        if (!(commonCompilerArguments instanceof K2MetadataCompilerArguments)) {
            commonCompilerArguments = null;
        }
        K2MetadataCompilerArguments k2MetadataCompilerArguments = (K2MetadataCompilerArguments)commonCompilerArguments;
        if (k2MetadataCompilerArguments == null) return false;
        if (!k2MetadataCompilerArguments.getEnabledInJps()) return false;
        return true;
    }

    @Override
    public boolean isIncrementalCompilationEnabled() {
        return false;
    }

    @NotNull
    public CommonBuildMetaInfo.Companion getBuildMetaInfoFactory() {
        return CommonBuildMetaInfo.Companion;
    }

    @Override
    @NotNull
    public String getBuildMetaInfoFileName() {
        return "common-build-meta-info.txt";
    }

    @Override
    @NotNull
    public String getGlobalLookupCacheId() {
        return "metadata-compiler";
    }

    @Override
    public boolean compileModuleChunk(@NotNull CommonCompilerArguments commonArguments, @NotNull KotlinDirtySourceFilesHolder dirtyFilesHolder2, @NotNull JpsCompilerEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)commonArguments, (String)"commonArguments");
        Intrinsics.checkNotNullParameter((Object)dirtyFilesHolder2, (String)"dirtyFilesHolder");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        boolean bl = Intrinsics.areEqual(this.getChunk().getRepresentativeTarget(), (Object)this);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        this.reportAndSkipCircular(environment);
        new JpsKotlinCompilerRunner().runK2MetadataCompiler(commonArguments, ModuleSettingsKt.getK2MetadataCompilerArguments(this.getModule()), ModuleSettingsKt.getKotlinCompilerSettings(this.getModule()), environment, this.getDestination(), CollectionsKt.plus((Collection)this.getDependenciesOutputDirs(), (Iterable)this.getLibraryFiles()), this.getSourceFiles());
        return true;
    }

    private final List<String> getLibraryFiles() {
        boolean bl = false;
        List list = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List result = list;
        boolean bl4 = false;
        JpsJavaDependenciesEnumerator jpsJavaDependenciesEnumerator = this.getAllDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)jpsJavaDependenciesEnumerator, (String)"allDependencies");
        for (JpsLibrary library : jpsJavaDependenciesEnumerator.getLibraries()) {
            Iterator iterator2 = library.getRoots(JpsOrderRootType.COMPILED).iterator();
            while (iterator2.hasNext()) {
                JpsLibraryRoot root;
                JpsLibraryRoot jpsLibraryRoot = root = (JpsLibraryRoot)iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)jpsLibraryRoot, (String)"root");
                String string2 = JpsPathUtil.urlToPath((String)jpsLibraryRoot.getUrl());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"JpsPathUtil.urlToPath(root.url)");
                result.add(string2);
            }
        }
        return list;
    }

    private final List<String> getDependenciesOutputDirs() {
        boolean bl = false;
        List list = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List result = list;
        boolean bl4 = false;
        this.getAllDependencies().processModules((Consumer)new Consumer<JpsModule>(result, this){
            final /* synthetic */ List $result;
            final /* synthetic */ KotlinCommonModuleBuildTarget this$0;
            {
                this.$result = list;
                this.this$0 = kotlinCommonModuleBuildTarget;
            }

            public final void consume(JpsModule module) {
                if (this.this$0.isTests()) {
                    JpsModule jpsModule = module;
                    Intrinsics.checkNotNullExpressionValue((Object)jpsModule, (String)"module");
                    KotlinCommonModuleBuildTarget.access$addDependencyMetaFile(this.this$0, jpsModule, this.$result, true);
                }
                JpsModule jpsModule = module;
                Intrinsics.checkNotNullExpressionValue((Object)jpsModule, (String)"module");
                KotlinCommonModuleBuildTarget.access$addDependencyMetaFile(this.this$0, jpsModule, this.$result, false);
            }
        });
        return list;
    }

    @NotNull
    public final String getDestination() {
        String string2 = ModuleSettingsKt.getK2MetadataCompilerArguments(this.getModule()).getDestination();
        if (string2 == null) {
            String string3 = this.getOutputDir().getAbsolutePath();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"outputDir.absolutePath");
        }
        return string2;
    }

    private final void addDependencyMetaFile(JpsModule module, List<String> result, boolean isTests) {
        KotlinModuleBuildTarget<?> dependencyBuildTarget = this.getKotlinContext().getTargetsBinding().get(JpsUtilKt.ModuleBuildTarget(module, isTests));
        if (Intrinsics.areEqual(dependencyBuildTarget, (Object)this) ^ true && dependencyBuildTarget instanceof KotlinCommonModuleBuildTarget) {
            Map<File, KotlinModuleBuildTarget.Source> map = dependencyBuildTarget.getSources();
            boolean bl = false;
            if (!map.isEmpty()) {
                result.add(((KotlinCommonModuleBuildTarget)dependencyBuildTarget).getDestination());
            }
        }
    }

    @Override
    public boolean getHasCaches() {
        return false;
    }

    @NotNull
    public Void createCacheStorage(@NotNull BuildDataPaths paths) {
        Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
        String string2 = "incremental K2MetadataCompiler not supported yet, createCacheStorage() should not be called";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string2.toString());
    }

    public KotlinCommonModuleBuildTarget(@NotNull KotlinCompileContext kotlinContext2, @NotNull ModuleBuildTarget jpsModuleBuildTarget) {
        Intrinsics.checkNotNullParameter((Object)kotlinContext2, (String)"kotlinContext");
        Intrinsics.checkNotNullParameter((Object)jpsModuleBuildTarget, (String)"jpsModuleBuildTarget");
        super(kotlinContext2, jpsModuleBuildTarget);
    }

    public static final /* synthetic */ void access$addDependencyMetaFile(KotlinCommonModuleBuildTarget $this, JpsModule module, List result, boolean isTests) {
        $this.addDependencyMetaFile(module, result, isTests);
    }
}

