/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.util.GithubSettings;

@Service
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bJ\u001e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bJ\u0016\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/util/GithubGitHelper;", "", "()V", "findRemote", "Lgit4idea/repo/GitRemote;", "repository", "Lgit4idea/repo/GitRepository;", "httpUrl", "", "sshUrl", "getRemoteUrl", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "user", "repo", "repoPath", "Lorg/jetbrains/plugins/github/api/GHRepositoryPath;", "Companion", "intellij.vcs.github"})
public final class GithubGitHelper {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getRemoteUrl(@NotNull GithubServerPath server, @NotNull GHRepositoryPath repoPath) {
        return this.getRemoteUrl(server, repoPath.getOwner(), repoPath.getRepository());
    }

    @NotNull
    public final String getRemoteUrl(@NotNull GithubServerPath server, @NotNull String user, @NotNull String repo) {
        String string;
        if (GithubSettings.getInstance().isCloneGitUsingSsh()) {
            String string2;
            int n;
            String string3;
            StringBuilder stringBuilder = new StringBuilder().append("git@").append(server.getHost()).append(':');
            String string4 = server.getSuffix();
            if (string4 != null) {
                string3 = string4;
                n = 1;
                boolean bl = false;
                String string5 = string3;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n);
                string2 = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string2 = null;
            }
            string3 = string2;
            n = 0;
            String string7 = string3;
            if (string7 == null) {
                string7 = "";
            }
            string = stringBuilder.append(string7).append('/').append(user).append('/').append(repo).append(".git").toString();
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("https://").append(server.getHost());
            String string8 = server.getSuffix();
            boolean bl = false;
            String string9 = string8;
            if (string9 == null) {
                string9 = "";
            }
            string = stringBuilder.append(string9).append('/').append(user).append('/').append(repo).append(".git").toString();
        }
        return string;
    }

    @Nullable
    public final GitRemote findRemote(@NotNull GitRepository repository, @Nullable String httpUrl, @Nullable String sshUrl) {
        Object v0;
        block1: {
            Iterable iterable = repository.getRemotes();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                GitRemote it = (GitRemote)t;
                boolean bl3 = false;
                if (!(it.getFirstUrl() != null && (Intrinsics.areEqual((Object)it.getFirstUrl(), (Object)httpUrl) || Intrinsics.areEqual((Object)it.getFirstUrl(), (Object)Intrinsics.stringPlus((String)httpUrl, (Object)".git")) || Intrinsics.areEqual((Object)it.getFirstUrl(), (Object)sshUrl) || Intrinsics.areEqual((Object)it.getFirstUrl(), (Object)Intrinsics.stringPlus((String)sshUrl, (Object)".git"))))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @JvmStatic
    @Nullable
    public static final GitRepository findGitRepository(@NotNull Project project, @Nullable VirtualFile file) {
        return Companion.findGitRepository(project, file);
    }

    @JvmStatic
    @NotNull
    public static final GithubGitHelper getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\b\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/util/GithubGitHelper$Companion;", "", "()V", "findGitRepository", "Lgit4idea/repo/GitRepository;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getInstance", "Lorg/jetbrains/plugins/github/util/GithubGitHelper;", "intellij.vcs.github"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final GitRepository findGitRepository(@NotNull Project project, @Nullable VirtualFile file) {
            GitRepository repository;
            GitRepositoryManager manager = GitUtil.getRepositoryManager((Project)project);
            List repositories = manager.getRepositories();
            if (repositories.size() == 0) {
                return null;
            }
            if (repositories.size() == 1) {
                return (GitRepository)repositories.get(0);
            }
            if (file != null && (repository = (GitRepository)manager.getRepositoryForFileQuick(file)) != null) {
                return repository;
            }
            return (GitRepository)manager.getRepositoryForFileQuick(project.getBaseDir());
        }

        public static /* synthetic */ GitRepository findGitRepository$default(Companion companion, Project project, VirtualFile virtualFile, int n, Object object) {
            if ((n & 2) != 0) {
                virtualFile = null;
            }
            return companion.findGitRepository(project, virtualFile);
        }

        @JvmStatic
        @NotNull
        public final GithubGitHelper getInstance() {
            boolean $i$f$service = false;
            return (GithubGitHelper)ApplicationManager.getApplication().getService(GithubGitHelper.class);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

