/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.util;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubApiResponse;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b\u0013J3\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000eH\u0001\u00a2\u0006\u0002\b\u001bJ\u0014\u0010\u001c\u001a\u00020\u001d*\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/github/authentication/util/GHSecurityUtil;", "", "()V", "DEFAULT_CLIENT_NAME", "", "GIST_SCOPE", "MASTER_SCOPES", "", "getMASTER_SCOPES", "()Ljava/util/List;", "READ_ORG_SCOPE", "REPO_SCOPE", "buildNewTokenUrl", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "buildNewTokenUrl$intellij_vcs_github", "isEnoughScopes", "", "grantedScopes", "isEnoughScopes$intellij_vcs_github", "loadCurrentUserWithScopes", "Lkotlin/Pair;", "Lorg/jetbrains/plugins/github/api/data/GithubAuthenticatedUser;", "executor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "loadCurrentUserWithScopes$intellij_vcs_github", "append", "Lcom/intellij/util/Url;", "path", "intellij.vcs.github"})
public final class GHSecurityUtil {
    private static final String REPO_SCOPE = "repo";
    private static final String GIST_SCOPE = "gist";
    private static final String READ_ORG_SCOPE = "read:org";
    @NotNull
    private static final List<String> MASTER_SCOPES;
    @NotNull
    public static final String DEFAULT_CLIENT_NAME = "Github Integration Plugin";
    public static final GHSecurityUtil INSTANCE;

    @NotNull
    public final List<String> getMASTER_SCOPES() {
        return MASTER_SCOPES;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Pair<GithubAuthenticatedUser, String> loadCurrentUserWithScopes$intellij_vcs_github(@NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator progressIndicator, @NotNull GithubServerPath server) {
        void scopes;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        GithubAuthenticatedUser details2 = (GithubAuthenticatedUser)executor.execute(progressIndicator, new GithubApiRequest.Get.Json<GithubAuthenticatedUser>((Ref.ObjectRef)scopes, server, GithubApiRequests.INSTANCE.getUrl(server, new String[]{GithubApiRequests.CurrentUser.INSTANCE.getUrlSuffix()}), GithubAuthenticatedUser.class){
            final /* synthetic */ Ref.ObjectRef $scopes;
            final /* synthetic */ GithubServerPath $server;

            @NotNull
            public GithubAuthenticatedUser extractResult(@NotNull GithubApiResponse response) {
                this.$scopes.element = response.findHeader("X-OAuth-Scopes");
                return (GithubAuthenticatedUser)super.extractResult(response);
            }
            {
                this.$scopes = $captured_local_variable$0;
                this.$server = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, null, 4, null);
            }
        }.withOperationName("get profile information"));
        return TuplesKt.to((Object)details2, (Object)((String)scopes.element));
    }

    @JvmStatic
    public static final boolean isEnoughScopes$intellij_vcs_github(@NotNull String grantedScopes) {
        boolean bl;
        block6: {
            List scopesArray = StringsKt.split$default((CharSequence)grantedScopes, (String[])new String[]{", "}, (boolean)false, (int)0, (int)6, null);
            if (scopesArray.isEmpty()) {
                return false;
            }
            if (!scopesArray.contains(REPO_SCOPE)) {
                return false;
            }
            if (!scopesArray.contains(GIST_SCOPE)) {
                return false;
            }
            Iterable $this$none$iv = scopesArray;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.endsWith$default((String)it, (String)":org", (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return !bl;
    }

    @NotNull
    public final String buildNewTokenUrl$intellij_vcs_github(@NotNull GithubServerPath server) {
        String productName = ApplicationNamesInfo.getInstance().getFullProductName();
        return this.append(server, "settings/tokens/new").addParameters(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"description", (Object)(productName + " GitHub integration plugin")), TuplesKt.to((Object)"scopes", (Object)CollectionsKt.joinToString$default((Iterable)MASTER_SCOPES, (CharSequence)",", null, null, (int)0, null, null, (int)62, null))})).toExternalForm();
    }

    /*
     * WARNING - void declaration
     */
    private final Url append(GithubServerPath $this$append, String path) {
        String string;
        boolean bl;
        Object object;
        String string2 = $this$append.getSchema();
        StringBuilder stringBuilder = new StringBuilder().append($this$append.getHost());
        Integer n = $this$append.getPort();
        if (n != null) {
            void it;
            object = n;
            bl = false;
            boolean bl2 = false;
            Integer n2 = object;
            StringBuilder stringBuilder2 = stringBuilder;
            String string3 = string2;
            boolean bl3 = false;
            String string4 = "" + ':' + it;
            string2 = string3;
            stringBuilder = stringBuilder2;
            string = string4;
        } else {
            string = null;
        }
        object = string;
        bl = false;
        Object object2 = object;
        if (object2 == null) {
            object2 = "";
        }
        String string5 = stringBuilder.append((String)object2).toString();
        StringBuilder stringBuilder3 = new StringBuilder();
        object = $this$append.getSuffix();
        bl = false;
        Object object3 = object;
        if (object3 == null) {
            object3 = "";
        }
        return Urls.newUrl((String)string2, (String)string5, (String)stringBuilder3.append((String)object3).append("/").append(path).toString());
    }

    private GHSecurityUtil() {
    }

    static {
        GHSecurityUtil gHSecurityUtil;
        INSTANCE = gHSecurityUtil = new GHSecurityUtil();
        MASTER_SCOPES = CollectionsKt.listOf((Object[])new String[]{REPO_SCOPE, GIST_SCOPE, READ_ORG_SCOPE});
    }
}

