/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.plugins.github.authentication.GHOAuthService;
import org.jetbrains.plugins.github.authentication.GHTokenRequest;

@Service
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bR\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/authentication/GHOAuthService;", "", "()V", "currentRequest", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/jetbrains/plugins/github/authentication/GHTokenRequest;", "acceptCode", "", "code", "", "requestToken", "Lorg/jetbrains/concurrency/CancellablePromise;", "Companion", "intellij.vcs.github"})
public final class GHOAuthService {
    private final AtomicReference<GHTokenRequest> currentRequest = new AtomicReference();
    @NotNull
    private static final GHOAuthService instance;
    private static final Url SERVICE_URL;
    public static final Companion Companion;

    @NotNull
    public final CancellablePromise<String> requestToken() {
        if (!this.currentRequest.compareAndSet(null, new GHTokenRequest())) {
            return Promises.rejectedCancellablePromise((String)"Already running");
        }
        GHTokenRequest gHTokenRequest = this.currentRequest.get();
        if (gHTokenRequest == null) {
            Intrinsics.throwNpe();
        }
        GHTokenRequest request = gHTokenRequest;
        request.onError(requestToken.1.INSTANCE);
        request.onProcessed(new Consumer<String>(this){
            final /* synthetic */ GHOAuthService this$0;

            public final void accept(@Nullable String it) {
                GHOAuthService.access$getCurrentRequest$p(this.this$0).set(null);
            }
            {
                this.this$0 = gHOAuthService;
            }
        });
        request.startAuthorization();
        return (CancellablePromise)request;
    }

    public final boolean acceptCode(@NotNull String code) {
        GHTokenRequest gHTokenRequest = this.currentRequest.get();
        if (gHTokenRequest == null) {
            return false;
        }
        GHTokenRequest request = gHTokenRequest;
        request.processCode(code);
        return request.isSucceeded();
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$service = false;
        instance = (GHOAuthService)ApplicationManager.getApplication().getService(GHOAuthService.class);
        SERVICE_URL = Urls.newFromEncoded((String)"https://account.jetbrains.com/github/oauth/intellij");
    }

    public static final /* synthetic */ AtomicReference access$getCurrentRequest$p(GHOAuthService $this) {
        return $this.currentRequest;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/authentication/GHOAuthService$Companion;", "", "()V", "ACCESS_TOKEN_URL", "Lcom/intellij/util/Url;", "getACCESS_TOKEN_URL", "()Lcom/intellij/util/Url;", "AUTHORIZE_URL", "getAUTHORIZE_URL", "ERROR_URL", "getERROR_URL", "SERVICE_URL", "SUCCESS_URL", "getSUCCESS_URL", "instance", "Lorg/jetbrains/plugins/github/authentication/GHOAuthService;", "getInstance", "()Lorg/jetbrains/plugins/github/authentication/GHOAuthService;", "intellij.vcs.github"})
    public static final class Companion {
        @NotNull
        public final GHOAuthService getInstance() {
            return instance;
        }

        @NotNull
        public final Url getAUTHORIZE_URL() {
            return SERVICE_URL.resolve("authorize");
        }

        @NotNull
        public final Url getACCESS_TOKEN_URL() {
            return SERVICE_URL.resolve("access_token");
        }

        @NotNull
        public final Url getSUCCESS_URL() {
            return SERVICE_URL.resolve("complete");
        }

        @NotNull
        public final Url getERROR_URL() {
            return SERVICE_URL.resolve("error");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

