/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.Function;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromiseKt;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.CompletablePromise;
import org.jetbrains.concurrency.InternalPromiseUtilKt;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B%\b\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010\f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u000f\u0010\u0015\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J \u0010\u0015\u001a\u0004\u0018\u00018\u00002\u0006\u0010\r\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010H\u0096\u0002\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\nH\u0016J\b\u0010\u001d\u001a\u00020\nH\u0016J \u0010\u001e\u001a\u0004\u0018\u00018\u00002\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000 H\u0082\b\u00a2\u0006\u0002\u0010!J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010#\u001a\n\u0012\u0006\b\u0000\u0012\u00020%0$H\u0016J \u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0010\u0010'\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00018\u00000$H\u0016J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010)\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000$H\u0016J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000*2\u000e\u0010+\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000*H\u0016J\u000e\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020.J\u0010\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020%H\u0016J\u0017\u0010/\u001a\u00020\u00132\b\u00100\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u00101J\b\u00102\u001a\u00020\nH\u0014J,\u00103\u001a\b\u0012\u0004\u0012\u0002H40*\"\u0004\b\u0001\u001042\u0016\u00105\u001a\u0012\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u0002H406H\u0016J2\u00107\u001a\b\u0012\u0004\u0012\u0002H40*\"\u0004\b\u0001\u001042\u001c\u00108\u001a\u0018\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H40*06H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/jetbrains/concurrency/AsyncPromise;", "T", "Lorg/jetbrains/concurrency/CancellablePromise;", "Lorg/jetbrains/concurrency/CompletablePromise;", "()V", "f", "Ljava/util/concurrent/CompletableFuture;", "hasErrorHandler", "Ljava/util/concurrent/atomic/AtomicBoolean;", "addExceptionHandler", "", "(Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/atomic/AtomicBoolean;Z)V", "blockingGet", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "(ILjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "cancel", "", "mayInterruptIfRunning", "get", "()Ljava/lang/Object;", "", "unit", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "getState", "Lorg/jetbrains/concurrency/Promise$State;", "isCancelled", "isDone", "nullizeCancelled", "value", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "onError", "rejected", "Ljava/util/function/Consumer;", "", "onProcessed", "processed", "onSuccess", "handler", "Lorg/jetbrains/concurrency/Promise;", "child", "setError", "error", "", "setResult", "t", "(Ljava/lang/Object;)V", "shouldLogErrors", "then", "SUB_RESULT", "done", "Lcom/intellij/util/Function;", "thenAsync", "doneF", "intellij.platform.concurrency"})
public class AsyncPromise<T>
implements CancellablePromise<T>,
CompletablePromise<T> {
    private final CompletableFuture<T> f;
    private final AtomicBoolean hasErrorHandler;

    public boolean isDone() {
        return this.f.isDone();
    }

    @Nullable
    public T get() {
        Object v0;
        AsyncPromise this_$iv = this;
        boolean $i$f$nullizeCancelled = false;
        if (this_$iv.isCancelled()) {
            v0 = null;
        } else {
            Object var4_5;
            try {
                boolean bl = false;
                var4_5 = this.f.get();
            }
            catch (CancellationException e$iv) {
                var4_5 = null;
            }
            v0 = var4_5;
        }
        return v0;
    }

    @Nullable
    public T get(long timeout, @NotNull TimeUnit unit) {
        Object v0;
        AsyncPromise this_$iv = this;
        boolean $i$f$nullizeCancelled = false;
        if (this_$iv.isCancelled()) {
            v0 = null;
        } else {
            Object var7_6;
            try {
                boolean bl = false;
                var7_6 = this.f.get(timeout, unit);
            }
            catch (CancellationException e$iv) {
                var7_6 = null;
            }
            v0 = var7_6;
        }
        return v0;
    }

    private final T nullizeCancelled(Function0<? extends T> value) {
        Object object;
        int $i$f$nullizeCancelled = 0;
        if (this.isCancelled()) {
            return null;
        }
        try {
            object = value.invoke();
        }
        catch (CancellationException e) {
            object = null;
        }
        return (T)object;
    }

    public boolean isCancelled() {
        return this.f.isCancelled();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return !this.isCancelled() && this.f.completeExceptionally(AsyncPromiseKt.access$getCANCELED$p());
    }

    public void cancel() {
        this.cancel(true);
    }

    @NotNull
    public Promise.State getState() {
        return !this.f.isDone() ? Promise.State.PENDING : (this.f.isCompletedExceptionally() ? Promise.State.REJECTED : Promise.State.SUCCEEDED);
    }

    @NotNull
    public AsyncPromise<T> onSuccess(@NotNull Consumer<? super T> handler) {
        return new AsyncPromise<T>(this.f.whenComplete(new BiConsumer<T, Throwable>(handler){
            final /* synthetic */ Consumer $handler;

            public final void accept(T value, Throwable error) {
                if (error != null) {
                    throw error;
                }
                if (!InternalPromiseUtilKt.isHandlerObsolete(this.$handler)) {
                    this.$handler.accept(value);
                }
            }
            {
                this.$handler = consumer;
            }
        }), this.hasErrorHandler, true);
    }

    @NotNull
    public AsyncPromise<T> onError(@NotNull Consumer<? super Throwable> rejected2) {
        this.hasErrorHandler.set(true);
        return new AsyncPromise<T>(this.f.whenComplete(new BiConsumer<T, Throwable>(rejected2){
            final /* synthetic */ Consumer $rejected;

            public final void accept(T $noName_0, Throwable exception) {
                if (exception != null && !InternalPromiseUtilKt.isHandlerObsolete(this.$rejected)) {
                    Throwable throwable;
                    Throwable throwable2 = exception;
                    if (!(throwable2 instanceof CompletionException)) {
                        throwable2 = null;
                    }
                    if ((throwable = (CompletionException)throwable2) == null || (throwable = throwable.getCause()) == null) {
                        throwable = exception;
                    }
                    this.$rejected.accept(throwable);
                }
            }
            {
                this.$rejected = consumer;
            }
        }), this.hasErrorHandler, false);
    }

    @NotNull
    public AsyncPromise<T> onProcessed(@NotNull Consumer<? super T> processed2) {
        return new AsyncPromise<T>(this.f.whenComplete(new BiConsumer<T, Throwable>(processed2){
            final /* synthetic */ Consumer $processed;

            public final void accept(T value, Throwable $noName_1) {
                if (!InternalPromiseUtilKt.isHandlerObsolete(this.$processed)) {
                    this.$processed.accept(value);
                }
            }
            {
                this.$processed = consumer;
            }
        }), this.hasErrorHandler, true);
    }

    @Nullable
    public T blockingGet(int timeout, @NotNull TimeUnit timeUnit) throws TimeoutException {
        try {
            return this.get(timeout, timeUnit);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throw (Throwable)e;
            }
            Throwable cause = throwable;
            if (cause == InternalPromiseUtilKt.getOBSOLETE_ERROR()) {
                return null;
            }
            ExceptionUtilRt.rethrowUnchecked((Throwable)cause);
            throw (Throwable)e;
        }
    }

    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> then(@NotNull Function<? super T, ? extends SUB_RESULT> done2) {
        return new AsyncPromise<T>(this.f.thenApply(new java.util.function.Function<T, SUB_RESULT>(done2){
            final /* synthetic */ Function $done;

            public final SUB_RESULT apply(T it) {
                return (SUB_RESULT)this.$done.fun(it);
            }
            {
                this.$done = function;
            }
        }), this.hasErrorHandler, true);
    }

    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> thenAsync(@NotNull Function<? super T, ? extends Promise<SUB_RESULT>> doneF) {
        return new AsyncPromise<T>(this.f.thenCompose(new java.util.function.Function<T, CompletionStage<SUB_RESULT>>(doneF){
            final /* synthetic */ Function $doneF;

            public final CompletionStage<SUB_RESULT> apply(T it) {
                Promise promise = (Promise)this.$doneF.fun(it);
                CompletableFuture<T> future = new CompletableFuture<T>();
                promise.onSuccess((Consumer)new Consumer<SUB_RESULT>(future){
                    final /* synthetic */ CompletableFuture $future;

                    public final void accept(SUB_RESULT value) {
                        this.$future.complete(value);
                    }
                    {
                        this.$future = completableFuture;
                    }
                }).onError((Consumer)new Consumer<Throwable>(future){
                    final /* synthetic */ CompletableFuture $future;

                    public final void accept(Throwable error) {
                        this.$future.completeExceptionally(error);
                    }
                    {
                        this.$future = completableFuture;
                    }
                });
                return future;
            }
            {
                this.$doneF = function;
            }
        }), this.hasErrorHandler, true);
    }

    @NotNull
    public Promise<T> processed(@NotNull Promise<? super T> child) {
        if (!(child instanceof AsyncPromise)) {
            return this;
        }
        return this.onSuccess(new Consumer<T>(child){
            final /* synthetic */ Promise $child;

            public final void accept(T it) {
                ((AsyncPromise)this.$child).setResult(it);
            }
            {
                this.$child = promise;
            }
        }).onError(new Consumer<Throwable>(child){
            final /* synthetic */ Promise $child;

            public final void accept(@NotNull Throwable it) {
                ((AsyncPromise)this.$child).setError(it);
            }
            {
                this.$child = promise;
            }
        });
    }

    @Override
    public void setResult(@Nullable T t) {
        this.f.complete(t);
    }

    @Override
    public boolean setError(@NotNull Throwable error) {
        if (!this.f.completeExceptionally(error)) {
            return false;
        }
        if (this.shouldLogErrors()) {
            Promises.errorIfNotMessage(Logger.getInstance(AsyncPromise.class), error);
        }
        return true;
    }

    protected boolean shouldLogErrors() {
        return !this.hasErrorHandler.get();
    }

    public final boolean setError(@NotNull String error) {
        return this.setError(Promises.createError$default(error, false, 2, null));
    }

    private AsyncPromise(CompletableFuture<T> f, AtomicBoolean hasErrorHandler, boolean addExceptionHandler) {
        this.hasErrorHandler = hasErrorHandler;
        this.f = addExceptionHandler ? f.exceptionally(new java.util.function.Function<Throwable, T>(){

            @Override
            public final T apply(Throwable originalError) {
                Throwable error;
                Throwable throwable;
                Throwable throwable2 = originalError;
                if (!(throwable2 instanceof CompletionException)) {
                    throwable2 = null;
                }
                if ((throwable = (CompletionException)throwable2) == null || (throwable = throwable.getCause()) == null) {
                    throwable = error = originalError;
                }
                if (this.shouldLogErrors()) {
                    Throwable throwable3;
                    Logger logger = Logger.getInstance(AsyncPromise.class);
                    Throwable throwable4 = error;
                    if (!(throwable4 instanceof CompletionException)) {
                        throwable4 = throwable3 = null;
                    }
                    if (throwable4 == null || (throwable3 = throwable3.getCause()) == null) {
                        throwable3 = error;
                    }
                    Promises.errorIfNotMessage(logger, throwable3);
                }
                throw error;
            }
        }) : f;
    }

    public AsyncPromise() {
        this(new CompletableFuture(), new AtomicBoolean(), false);
    }
}

