/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.application.AccessToken;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LockToken
extends AccessToken {
    private final Lock myLock;

    private LockToken(Lock lock) {
        this.myLock = lock;
    }

    public void finish() {
        this.myLock.unlock();
    }

    @NotNull
    public static LockToken acquireLock(@NotNull Lock lock) {
        lock.lock();
        return new LockToken(lock);
    }

    @Nullable
    public static LockToken attemptLock(@NotNull Lock lock, long time) throws InterruptedException {
        if (lock.tryLock(time, TimeUnit.MILLISECONDS)) {
            return new LockToken(lock);
        }
        return null;
    }
}

