/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.EventQueue;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

final class EdtExecutorServiceImpl
extends EdtExecutorService {
    static final EdtExecutorService INSTANCE = new EdtExecutorServiceImpl();

    private EdtExecutorServiceImpl() {
    }

    @Override
    public void execute(@NotNull Runnable command) {
        Application application = ApplicationManager.getApplication();
        this.execute(command, application == null ? ModalityState.NON_MODAL : application.getAnyModalityState());
    }

    @Override
    public void execute(@NotNull Runnable command, @NotNull ModalityState modalityState) {
        Application application = ApplicationManager.getApplication();
        if (EdtExecutorServiceImpl.shouldManifestExceptionsImmediately() && !(command instanceof FlippantFuture)) {
            command = new FlippantFuture(Executors.callable(command, null));
        }
        if (application == null) {
            EventQueue.invokeLater(command);
        } else {
            application.invokeLater((Runnable)command, modalityState);
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return this.newTaskFor(Executors.callable(runnable, value));
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        if (EdtExecutorServiceImpl.shouldManifestExceptionsImmediately()) {
            return new FlippantFuture(callable);
        }
        return new FutureTask<T>(callable);
    }

    @Override
    @NotNull
    public Future<?> submit(@NotNull Runnable command, @NotNull ModalityState modalityState) {
        RunnableFuture<Object> future = this.newTaskFor(command, null);
        this.execute(future, modalityState);
        return future;
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> task, @NotNull ModalityState modalityState) {
        RunnableFuture<T> future = this.newTaskFor(task);
        this.execute(future, modalityState);
        return future;
    }

    @Override
    public void shutdown() {
        AppScheduledExecutorService.error();
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        return AppScheduledExecutorService.error();
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) {
        AppScheduledExecutorService.error();
        return false;
    }

    static boolean shouldManifestExceptionsImmediately() {
        return ApplicationManager.getApplication() != null && ApplicationManager.getApplication().isUnitTestMode();
    }

    static void manifestExceptionsIn(@NotNull Future<?> task) {
        try {
            task.get();
        }
        catch (InterruptedException | CancellationException exception) {
        }
        catch (ExecutionException e) {
            ExceptionUtil.rethrow((Throwable)e.getCause());
        }
    }

    private static class FlippantFuture<T>
    extends FutureTask<T> {
        private FlippantFuture(Callable<T> callable) {
            super(callable);
        }

        @Override
        public void run() {
            super.run();
            EdtExecutorServiceImpl.manifestExceptionsIn(this);
        }
    }
}

