/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncFutureFactory;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.concurrency.DefaultResultConsumer;
import com.intellij.concurrency.ResultConsumer;
import com.intellij.util.AbstractQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.concurrency.SameThreadExecutor;
import org.jetbrains.annotations.NotNull;

public class MergeQuery<T>
extends AbstractQuery<T> {
    private final Query<? extends T> myQuery1;
    private final Query<? extends T> myQuery2;

    public MergeQuery(@NotNull Query<? extends T> query1, @NotNull Query<? extends T> query2) {
        this.myQuery1 = query1;
        this.myQuery2 = query2;
    }

    protected boolean processResults(@NotNull Processor<? super T> consumer) {
        return MergeQuery.delegateProcessResults(this.myQuery1, consumer) && MergeQuery.delegateProcessResults(this.myQuery2, consumer);
    }

    @NotNull
    public AsyncFuture<Boolean> forEachAsync(final @NotNull Processor<? super T> consumer) {
        final AsyncFutureResult result = AsyncFutureFactory.getInstance().createAsyncFutureResult();
        AsyncFuture fq = this.myQuery1.forEachAsync(consumer);
        fq.addConsumer(SameThreadExecutor.INSTANCE, (ResultConsumer)new DefaultResultConsumer<Boolean>(result){

            public void onSuccess(Boolean value) {
                if (value.booleanValue()) {
                    AsyncFuture fq2 = MergeQuery.this.myQuery2.forEachAsync(consumer);
                    fq2.addConsumer(SameThreadExecutor.INSTANCE, (ResultConsumer)new DefaultResultConsumer(result));
                } else {
                    result.set((Object)false);
                }
            }
        });
        return result;
    }
}

