/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.androidTVActivity.src.app_package;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"mainFragmentKt", "", "detailsActivity", "mainFragment", "minApiLevel", "", "packageName", "useAndroidX", "", "intellij.android.wizardTemplate.impl"})
public final class MainFragmentKtKt {
    @NotNull
    public static final String mainFragmentKt(@NotNull String detailsActivity2, @NotNull String mainFragment2, int minApiLevel, @NotNull String packageName, boolean useAndroidX) {
        String contextArgBlock = minApiLevel >= 23 ? "context!!" : "activity!!";
        return "\npackage " + TemplateHelpersKt.escapeKotlinIdentifier(packageName) + "\n\nimport java.util.Collections\nimport java.util.Timer\nimport java.util.TimerTask\n\nimport android.content.Intent\nimport android.graphics.Color\nimport android.graphics.drawable.Drawable\nimport android.os.Bundle\nimport android.os.Handler\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.app.BackgroundManager", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.app.BrowseSupportFragment", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.ArrayObjectAdapter", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.HeaderItem", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.ImageCardView", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.ListRow", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.ListRowPresenter", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.OnItemViewClickedListener", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.OnItemViewSelectedListener", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.Presenter", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.Row", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.RowPresenter", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v4.app.ActivityOptionsCompat", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v4.content.ContextCompat", useAndroidX) + "\nimport android.util.DisplayMetrics\nimport android.util.Log\nimport android.view.Gravity\nimport android.view.ViewGroup\nimport android.widget.TextView\nimport android.widget.Toast\n\nimport com.bumptech.glide.Glide\nimport com.bumptech.glide.request.target.SimpleTarget\nimport com.bumptech.glide.request.transition.Transition\n\n/**\n * Loads a grid of cards with movies to browse.\n */\nclass " + mainFragment2 + " : BrowseSupportFragment() {\n\n    private val mHandler = Handler()\n    private lateinit var mBackgroundManager: BackgroundManager\n    private var mDefaultBackground: Drawable? = null\n    private lateinit var mMetrics: DisplayMetrics\n    private var mBackgroundTimer: Timer? = null\n    private var mBackgroundUri: String? = null\n\n    override fun onActivityCreated(savedInstanceState: Bundle?) {\n        Log.i(TAG, \"onCreate\")\n        super.onActivityCreated(savedInstanceState)\n\n        prepareBackgroundManager()\n\n        setupUIElements()\n\n        loadRows()\n\n        setupEventListeners()\n    }\n\n    override fun onDestroy() {\n        super.onDestroy()\n        Log.d(TAG, \"onDestroy: \" + mBackgroundTimer?.toString())\n        mBackgroundTimer?.cancel()\n    }\n\n    private fun prepareBackgroundManager() {\n\n        mBackgroundManager = BackgroundManager.getInstance(activity)\n        mBackgroundManager.attach(activity!!.window)\n        mDefaultBackground = ContextCompat.getDrawable(" + contextArgBlock + ", R.drawable.default_background)\n        mMetrics = DisplayMetrics()\n        activity!!.windowManager.defaultDisplay.getMetrics(mMetrics)\n    }\n\n    private fun setupUIElements() {\n        title = getString(R.string.browse_title)\n        // over title\n        headersState = BrowseSupportFragment.HEADERS_ENABLED\n        isHeadersTransitionOnBackEnabled = true\n\n        // set fastLane (or headers) background color\n        brandColor = ContextCompat.getColor(" + contextArgBlock + ", R.color.fastlane_background)\n        // set search icon color\n        searchAffordanceColor = ContextCompat.getColor(" + contextArgBlock + ", R.color.search_opaque)\n    }\n\n    private fun loadRows() {\n        val list = MovieList.list\n\n        val rowsAdapter = ArrayObjectAdapter(ListRowPresenter())\n        val cardPresenter = CardPresenter()\n\n        for (i in 0 until NUM_ROWS) {\n            if (i != 0) {\n                Collections.shuffle(list)\n            }\n            val listRowAdapter = ArrayObjectAdapter(cardPresenter)\n            for (j in 0 until NUM_COLS ) {\n                listRowAdapter.add(list[j % 5])\n            }\n            val header = HeaderItem(i.toLong(), MovieList.MOVIE_CATEGORY[i])\n            rowsAdapter.add(ListRow(header, listRowAdapter))\n        }\n\n        val gridHeader = HeaderItem(NUM_ROWS.toLong(), \"PREFERENCES\")\n\n        val mGridPresenter = GridItemPresenter()\n        val gridRowAdapter = ArrayObjectAdapter(mGridPresenter)\n        gridRowAdapter.add(resources.getString(R.string.grid_view))\n        gridRowAdapter.add(getString(R.string.error_fragment))\n        gridRowAdapter.add(resources.getString(R.string.personal_settings))\n        rowsAdapter.add(ListRow(gridHeader, gridRowAdapter))\n\n        adapter = rowsAdapter\n    }\n\n    private fun setupEventListeners() {\n        setOnSearchClickedListener {\n            Toast.makeText(" + contextArgBlock + ", \"Implement your own in-app search\", Toast.LENGTH_LONG)\n                .show()\n        }\n\n        onItemViewClickedListener = ItemViewClickedListener()\n        onItemViewSelectedListener = ItemViewSelectedListener()\n    }\n\n    private inner class ItemViewClickedListener : OnItemViewClickedListener {\n        override fun onItemClicked(\n                itemViewHolder: Presenter.ViewHolder,\n                item: Any,\n                rowViewHolder: RowPresenter.ViewHolder,\n                row: Row) {\n\n            if (item is Movie) {\n                Log.d(TAG, \"Item: \" + item.toString())\n                val intent = Intent(" + contextArgBlock + ", " + detailsActivity2 + "::class.java)\n                intent.putExtra(" + detailsActivity2 + ".MOVIE, item)\n\n                val bundle = ActivityOptionsCompat.makeSceneTransitionAnimation(\n                                                activity!!,\n                                                (itemViewHolder.view as ImageCardView).mainImageView,\n                                                " + detailsActivity2 + ".SHARED_ELEMENT_NAME)\n                                        .toBundle()\n                startActivity(intent, bundle)\n            } else if (item is String) {\n                if (item.contains(getString(R.string.error_fragment))) {\n                    val intent = Intent(" + contextArgBlock + ", BrowseErrorActivity::class.java)\n                    startActivity(intent)\n                } else {\n                    Toast.makeText(" + contextArgBlock + ", item, Toast.LENGTH_SHORT).show()\n                }\n            }\n        }\n    }\n\n    private inner class ItemViewSelectedListener : OnItemViewSelectedListener {\n        override fun onItemSelected(itemViewHolder: Presenter.ViewHolder?, item: Any?,\n                                    rowViewHolder: RowPresenter.ViewHolder, row: Row) {\n            if (item is Movie) {\n                mBackgroundUri = item.backgroundImageUrl\n                startBackgroundTimer()\n            }\n        }\n    }\n\n    private fun updateBackground(uri: String?) {\n        val width = mMetrics.widthPixels\n        val height = mMetrics.heightPixels\n        Glide.with(" + contextArgBlock + ")\n                .load(uri)\n                .centerCrop()\n                .error(mDefaultBackground)\n                .into<SimpleTarget<Drawable>>(\n                        object : SimpleTarget<Drawable>(width, height) {\n                            override fun onResourceReady(drawable: Drawable,\n                                                         transition: Transition<in Drawable>?) {\n                                mBackgroundManager.drawable = drawable\n                            }\n                        })\n        mBackgroundTimer?.cancel()\n    }\n\n    private fun startBackgroundTimer() {\n        mBackgroundTimer?.cancel()\n        mBackgroundTimer = Timer()\n        mBackgroundTimer?.schedule(UpdateBackgroundTask(), BACKGROUND_UPDATE_DELAY.toLong())\n    }\n\n    private inner class UpdateBackgroundTask : TimerTask() {\n\n        override fun run() {\n            mHandler.post { updateBackground(mBackgroundUri) }\n        }\n    }\n\n    private inner class GridItemPresenter : Presenter() {\n        override fun onCreateViewHolder(parent: ViewGroup): Presenter.ViewHolder {\n            val view = TextView(parent.context)\n            view.layoutParams = ViewGroup.LayoutParams(GRID_ITEM_WIDTH, GRID_ITEM_HEIGHT)\n            view.isFocusable = true\n            view.isFocusableInTouchMode = true\n            view.setBackgroundColor(ContextCompat.getColor(" + contextArgBlock + ", R.color.default_background))\n            view.setTextColor(Color.WHITE)\n            view.gravity = Gravity.CENTER\n            return Presenter.ViewHolder(view)\n        }\n\n        override fun onBindViewHolder(viewHolder: Presenter.ViewHolder, item: Any) {\n            (viewHolder.view as TextView).text = item as String\n        }\n\n        override fun onUnbindViewHolder(viewHolder: Presenter.ViewHolder) {}\n    }\n\n    companion object {\n        private val TAG = \"" + StringsKt.take((String)mainFragment2, (int)23) + "\"\n\n        private val BACKGROUND_UPDATE_DELAY = 300\n        private val GRID_ITEM_WIDTH = 200\n        private val GRID_ITEM_HEIGHT = 200\n        private val NUM_ROWS = 6\n        private val NUM_COLS = 15\n    }\n}\n";
    }
}

