/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableConsumer;
import it.unimi.dsi.fastutil.Hash;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public final class VcsFileUtil {
    public static final int FILE_PATH_LIMIT = 7600;
    public static final Hash.Strategy<FilePath> CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY = new FilePathCaseSensitiveStrategy();

    @NotNull
    public static <T> List<T> foreachChunk(@NotNull List<String> arguments, int groupSize, @NotNull ThrowableNotNullFunction<? super List<String>, ? extends List<? extends T>, ? extends VcsException> processor) throws VcsException {
        ArrayList result2 = new ArrayList();
        VcsFileUtil.foreachChunk(arguments, groupSize, (ThrowableConsumer<? super List<String>, ? extends VcsException>)((ThrowableConsumer)chunk -> result2.addAll((Collection)processor.fun(chunk))));
        return result2;
    }

    public static void foreachChunk(@NotNull List<String> arguments, int groupSize, @NotNull ThrowableConsumer<? super List<String>, ? extends VcsException> consumer) throws VcsException {
        List<List<String>> chunks = VcsFileUtil.chunkArguments(arguments, groupSize);
        for (List<String> chunk : chunks) {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.checkCanceled();
            }
            consumer.consume(chunk);
        }
    }

    @NotNull
    public static List<List<String>> chunkArguments(@NotNull List<String> arguments) {
        return VcsFileUtil.chunkArguments(arguments, 1);
    }

    @NotNull
    public static List<List<String>> chunkArguments(@NotNull List<String> arguments, int groupSize) {
        int i;
        assert (arguments.size() % groupSize == 0) : "Arguments size should be divisible by group size";
        ArrayList<List<String>> rc = new ArrayList<List<String>>();
        int start2 = 0;
        int size = 0;
        for (i = 0; i < arguments.size(); i += groupSize) {
            int length = 0;
            for (int j = 0; j < groupSize; ++j) {
                length += arguments.get(i + j).length();
            }
            if (size + length > 7600) {
                if (start2 == i) {
                    rc.add(arguments.subList(i, i + groupSize));
                    start2 = i + groupSize;
                    size = 0;
                    continue;
                }
                rc.add(arguments.subList(start2, i));
                start2 = i;
                size = length;
                continue;
            }
            size += length;
        }
        if (start2 != arguments.size()) {
            rc.add(arguments.subList(start2, i));
        }
        return rc;
    }

    public static List<List<String>> chunkPaths(VirtualFile root, Collection<? extends FilePath> files) {
        return VcsFileUtil.chunkArguments(VcsFileUtil.toRelativePaths(root, files));
    }

    public static List<List<String>> chunkFiles(@NotNull VirtualFile root, @NotNull Collection<? extends VirtualFile> files) {
        return VcsFileUtil.chunkArguments(VcsFileUtil.toRelativeFiles(root, files));
    }

    public static String getRelativeFilePath(VirtualFile file, @NotNull VirtualFile baseDir) {
        return VcsFileUtil.getRelativeFilePath(file.getPath(), baseDir);
    }

    public static String getRelativeFilePath(String file, @NotNull VirtualFile baseDir) {
        String basePath;
        if (SystemInfo.isWindows) {
            file = file.replace('\\', '/');
        }
        if (!file.startsWith(basePath = baseDir.getPath())) {
            return file;
        }
        if (file.equals(basePath)) {
            return ".";
        }
        return file.substring(baseDir.getPath().length() + 1);
    }

    public static boolean isOctal(char ch) {
        return '0' <= ch && ch <= '7';
    }

    public static String relativePath(VirtualFile root, FilePath path2) {
        return VcsFileUtil.relativePath(VfsUtilCore.virtualToIoFile((VirtualFile)root), path2.getIOFile());
    }

    public static String relativePath(File root, FilePath path2) {
        return VcsFileUtil.relativePath(root, path2.getIOFile());
    }

    public static String relativePath(File root, VirtualFile file) {
        return VcsFileUtil.relativePath(root, VfsUtilCore.virtualToIoFile((VirtualFile)file));
    }

    public static String relativePath(VirtualFile root, VirtualFile file) {
        return VcsFileUtil.relativePath(VfsUtilCore.virtualToIoFile((VirtualFile)root), VfsUtilCore.virtualToIoFile((VirtualFile)file));
    }

    public static String relativeOrFullPath(VirtualFile root, VirtualFile file) {
        if (root == null) {
            file.getPath();
        }
        return VcsFileUtil.relativePath(VfsUtilCore.virtualToIoFile((VirtualFile)root), VfsUtilCore.virtualToIoFile((VirtualFile)file));
    }

    @NotNull
    public static String relativePath(@NotNull FilePath root, @NotNull FilePath file) {
        return VcsFileUtil.relativePath(root.getIOFile(), file.getIOFile());
    }

    public static String relativePath(File root, File path2) {
        String rc = FileUtil.getRelativePath((File)root, (File)path2);
        if (rc == null) {
            throw new IllegalArgumentException("The file " + path2 + " cannot be made relative to " + root);
        }
        return rc.replace(File.separatorChar, '/');
    }

    public static List<String> toRelativePaths(@NotNull VirtualFile root, @NotNull Collection<? extends FilePath> filePaths) {
        ArrayList<String> rc = new ArrayList<String>(filePaths.size());
        for (FilePath filePath : filePaths) {
            rc.add(VcsFileUtil.relativePath(root, filePath));
        }
        return rc;
    }

    public static List<String> toRelativeFiles(@NotNull VirtualFile root, @NotNull Collection<? extends VirtualFile> files) {
        ArrayList<String> rc = new ArrayList<String>(files.size());
        for (VirtualFile virtualFile : files) {
            rc.add(VcsFileUtil.relativePath(root, virtualFile));
        }
        return rc;
    }

    public static void markFilesDirty(@NotNull Project project, @NotNull Collection<? extends VirtualFile> affectedFiles) {
        VcsDirtyScopeManager dirty = VcsDirtyScopeManager.getInstance((Project)project);
        for (VirtualFile virtualFile : affectedFiles) {
            if (virtualFile.isDirectory()) {
                dirty.dirDirtyRecursively(virtualFile);
                continue;
            }
            dirty.fileDirty(virtualFile);
        }
    }

    public static void markFilesDirty(@NotNull Project project, @NotNull List<? extends FilePath> affectedFiles) {
        VcsDirtyScopeManager dirty = VcsDirtyScopeManager.getInstance((Project)project);
        for (FilePath filePath : affectedFiles) {
            if (filePath.isDirectory()) {
                dirty.dirDirtyRecursively(filePath);
                continue;
            }
            dirty.fileDirty(filePath);
        }
    }

    public static void addFilesToVcsWithConfirmation(@NotNull Project project, VirtualFile ... virtualFiles) {
        VcsFileUtil.addFilesToVcsWithConfirmation(project, Arrays.asList(virtualFiles));
    }

    public static void addFilesToVcsWithConfirmation(@NotNull Project project, @NotNull Collection<? extends VirtualFile> virtualFiles) {
        if (virtualFiles.isEmpty()) {
            return;
        }
        ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)project);
        ArrayListMultimap vcsMap = ArrayListMultimap.create();
        for (VirtualFile virtualFile : virtualFiles) {
            AbstractVcs vcs = vcsManager2.getVcsFor(virtualFile);
            if (vcs == null) continue;
            VfsUtil.processFileRecursivelyWithoutIgnored((VirtualFile)virtualFile, arg_0 -> VcsFileUtil.lambda$addFilesToVcsWithConfirmation$1((Multimap)vcsMap, vcs, arg_0));
        }
        for (AbstractVcs abstractVcs : vcsMap.keySet()) {
            VcsShowConfirmationOption addOption = vcsManager2.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, abstractVcs);
            if (addOption.getValue() == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
                return;
            }
            ArrayList<VirtualFile> filesList = new ArrayList<VirtualFile>(vcsMap.get((Object)abstractVcs));
            if (addOption.getValue() == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
                VcsFileUtil.performAdditions(abstractVcs, filesList);
                continue;
            }
            AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)project);
            Ref filesToAdd = Ref.create();
            ApplicationManager.getApplication().invokeAndWait(() -> filesToAdd.set((Object)helper.selectFilesToProcess(new ArrayList(filesList), VcsBundle.message((String)"confirmation.title.add.files.to", (Object[])new Object[]{vcs.getDisplayName()}), null, VcsBundle.message((String)"confirmation.title.add.file.to", (Object[])new Object[]{vcs.getDisplayName()}), null, addOption)));
            if (filesToAdd.isNull()) continue;
            VcsFileUtil.performAdditions(abstractVcs, new ArrayList<VirtualFile>((Collection)filesToAdd.get()));
        }
    }

    private static void performAdditions(@NotNull AbstractVcs vcs, @NotNull List<VirtualFile> value) {
        CheckinEnvironment checkinEnvironment = vcs.getCheckinEnvironment();
        if (checkinEnvironment != null) {
            checkinEnvironment.scheduleUnversionedFilesForAddition(value);
        }
    }

    public static boolean isAncestor(@NotNull @SystemIndependent String ancestor, @NotNull @SystemIndependent String path2, boolean strict) {
        return FileUtil.startsWith((String)path2, (String)ancestor, (boolean)SystemInfo.isFileSystemCaseSensitive, (boolean)strict);
    }

    public static boolean isAncestor(@NotNull FilePath ancestor, @NotNull FilePath path2, boolean strict) {
        return VcsFileUtil.isAncestor(ancestor.getPath(), path2.getPath(), strict);
    }

    public static boolean isAncestor(@NotNull VirtualFile root, @NotNull FilePath path2) {
        return VcsFileUtil.isAncestor(root.getPath(), path2.getPath(), false);
    }

    @NotNull
    public static String unescapeGitPath(@NotNull String path2, @Nullable String encoding) throws IllegalArgumentException {
        String QUOTE = "\"";
        if (path2.startsWith("\"") && path2.endsWith("\"")) {
            path2 = path2.substring(1, path2.length() - 1);
        }
        encoding = encoding != null ? encoding : Charset.defaultCharset().name();
        int l = path2.length();
        StringBuilder rc = new StringBuilder(l);
        for (int i = 0; i < path2.length(); ++i) {
            char c = path2.charAt(i);
            if (c == '\\') {
                if (++i >= l) {
                    throw new IllegalArgumentException("Unterminated escape sequence in the path: " + path2);
                }
                char e = path2.charAt(i);
                switch (e) {
                    case '\\': {
                        rc.append('\\');
                        break;
                    }
                    case 't': {
                        rc.append('\t');
                        break;
                    }
                    case 'n': {
                        rc.append('\n');
                        break;
                    }
                    case 'r': {
                        rc.append('\r');
                        break;
                    }
                    case 'a': {
                        rc.append('\u0007');
                        break;
                    }
                    case 'b': {
                        rc.append('\b');
                        break;
                    }
                    case 'f': {
                        rc.append('\f');
                        break;
                    }
                    case '\"': {
                        rc.append('\"');
                        break;
                    }
                    default: {
                        if (VcsFileUtil.isOctal(e)) {
                            int n = 0;
                            for (int j = i; j < l; ++j) {
                                if (VcsFileUtil.isOctal(path2.charAt(j))) {
                                    ++n;
                                    for (int k = 0; k < 3 && j < l && VcsFileUtil.isOctal(path2.charAt(j)); ++j, ++k) {
                                    }
                                }
                                if (j + 1 >= l || path2.charAt(j) != '\\' || !VcsFileUtil.isOctal(path2.charAt(j + 1))) break;
                            }
                            byte[] b = new byte[n];
                            n = 0;
                            while (i < l) {
                                if (VcsFileUtil.isOctal(path2.charAt(i))) {
                                    int code = 0;
                                    for (int k = 0; k < 3 && i < l && VcsFileUtil.isOctal(path2.charAt(i)); ++i, ++k) {
                                        code = code * 8 + (path2.charAt(i) - 48);
                                    }
                                    b[n++] = (byte)code;
                                }
                                if (i + 1 >= l || path2.charAt(i) != '\\' || !VcsFileUtil.isOctal(path2.charAt(i + 1))) break;
                                ++i;
                            }
                            --i;
                            assert (n == b.length);
                            try {
                                rc.append(new String(b, encoding));
                                break;
                            }
                            catch (UnsupportedEncodingException e1) {
                                throw new IllegalArgumentException("The file name encoding is unsupported: " + encoding);
                            }
                        }
                        throw new IllegalArgumentException("Unknown escape sequence '\\" + path2.charAt(i) + "' in the path: " + path2);
                    }
                }
                continue;
            }
            rc.append(c);
        }
        return rc.toString();
    }

    @NotNull
    public static String unescapeGitPath(@NotNull String path2) {
        return VcsFileUtil.unescapeGitPath(path2, null);
    }

    private static /* synthetic */ boolean lambda$addFilesToVcsWithConfirmation$1(Multimap vcsMap, AbstractVcs vcs, VirtualFile virtualFile) {
        return vcsMap.put((Object)vcs, (Object)virtualFile);
    }

    private static class FilePathCaseSensitiveStrategy
    implements Hash.Strategy<FilePath> {
        private FilePathCaseSensitiveStrategy() {
        }

        public boolean equals(FilePath path1, FilePath path2) {
            if (path1 == path2) {
                return true;
            }
            if (path1 == null || path2 == null) {
                return false;
            }
            if (path1.isDirectory() != path2.isDirectory()) {
                return false;
            }
            String canonical1 = FileUtil.toCanonicalPath((String)path1.getPath());
            String canonical2 = FileUtil.toCanonicalPath((String)path2.getPath());
            return canonical1.equals(canonical2);
        }

        public int hashCode(FilePath path2) {
            if (path2 == null) {
                return 0;
            }
            int result2 = path2.getPath().isEmpty() ? 0 : FileUtil.toCanonicalPath((String)path2.getPath()).hashCode();
            result2 = 31 * result2 + (path2.isDirectory() ? 1 : 0);
            return result2;
        }
    }
}

