/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible.filters;

import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import java.util.Date;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VcsLogDateFilterImpl
implements VcsLogDateFilter,
VcsLogDetailsFilter {
    @Nullable
    private final Date myAfter;
    @Nullable
    private final Date myBefore;

    VcsLogDateFilterImpl(@Nullable Date after, @Nullable Date before) {
        this.myAfter = after;
        this.myBefore = before;
    }

    public boolean matches(@NotNull VcsCommitMetadata details) {
        Date date = new Date(details.getCommitTime());
        boolean matches = true;
        if (this.myAfter != null) {
            matches &= date.after(this.myAfter);
        }
        if (this.myBefore != null) {
            matches &= date.before(this.myBefore);
        }
        return matches;
    }

    @Nullable
    public Date getAfter() {
        return this.myAfter;
    }

    @Nullable
    public Date getBefore() {
        return this.myBefore;
    }

    public String toString() {
        return (this.myAfter != null ? "after " + this.myAfter + (this.myBefore != null ? " " : "") : "") + (this.myBefore != null ? "before " + this.myBefore : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsLogDateFilterImpl filter = (VcsLogDateFilterImpl)o;
        return Objects.equals(this.getAfter(), filter.getAfter()) && Objects.equals(this.getBefore(), filter.getBefore());
    }

    public int hashCode() {
        return Objects.hash(this.getAfter(), this.getBefore());
    }
}

