/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.CommittedChangeListForRevision;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsChangesLazilyParsedDetails;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsLogUtil {
    public static final int MAX_SELECTED_COMMITS = 1000;
    public static final int FULL_HASH_LENGTH = 40;
    public static final int SHORT_HASH_LENGTH = 8;
    public static final Pattern HASH_REGEX = Pattern.compile("[a-fA-F0-9]{7,40}");
    @NonNls
    public static final String HEAD = "HEAD";

    @NotNull
    public static Map<VirtualFile, Set<VcsRef>> groupRefsByRoot(@NotNull Collection<? extends VcsRef> refs) {
        return VcsLogUtil.groupByRoot(refs, VcsRef::getRoot);
    }

    @NotNull
    private static <T> Map<VirtualFile, Set<T>> groupByRoot(@NotNull Collection<? extends T> items, @NotNull Function<? super T, ? extends VirtualFile> rootGetter) {
        TreeMap<VirtualFile, Set<T>> map2 = new TreeMap<VirtualFile, Set<T>>(Comparator.comparing(VirtualFile::getPresentableUrl));
        for (T item : items) {
            VirtualFile root = (VirtualFile)rootGetter.fun(item);
            map2.computeIfAbsent(root, k -> new HashSet()).add(item);
        }
        return map2;
    }

    public static int compareRoots(@NotNull VirtualFile root1, @NotNull VirtualFile root2) {
        return root1.getPresentableUrl().compareTo(root2.getPresentableUrl());
    }

    @NotNull
    private static Set<VirtualFile> collectRoots(@NotNull Collection<? extends FilePath> files, @NotNull Set<? extends VirtualFile> roots) {
        HashSet<VirtualFile> selectedRoots = new HashSet<VirtualFile>();
        List sortedRoots = ContainerUtil.sorted(roots, Comparator.comparing(VirtualFile::getPath));
        for (FilePath filePath : files) {
            VirtualFile virtualFile = filePath.getVirtualFile();
            if (virtualFile != null && roots.contains(virtualFile)) {
                selectedRoots.add(virtualFile);
            } else {
                VirtualFile candidateAncestorRoot = null;
                for (VirtualFile root : sortedRoots) {
                    if (!FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)root), (File)filePath.getIOFile(), (boolean)false)) continue;
                    candidateAncestorRoot = root;
                }
                if (candidateAncestorRoot != null) {
                    selectedRoots.add(candidateAncestorRoot);
                }
            }
            if (virtualFile == null) continue;
            for (VirtualFile virtualFile2 : roots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)virtualFile2, (boolean)false)) continue;
                selectedRoots.add(virtualFile2);
            }
        }
        return selectedRoots;
    }

    @NotNull
    public static Set<VirtualFile> getVisibleRoots(@NotNull VcsLogUi logUi) {
        VcsLogFilterCollection filters = logUi.getFilterUi().getFilters();
        Set<VirtualFile> roots = logUi.getDataPack().getLogProviders().keySet();
        return VcsLogUtil.getAllVisibleRoots(roots, filters);
    }

    @NotNull
    public static Set<VirtualFile> getAllVisibleRoots(@NotNull Collection<VirtualFile> roots, @NotNull VcsLogFilterCollection filters) {
        return VcsLogUtil.getAllVisibleRoots(roots, (VcsLogRootFilter)filters.get(VcsLogFilterCollection.ROOT_FILTER), (VcsLogStructureFilter)filters.get(VcsLogFilterCollection.STRUCTURE_FILTER));
    }

    @NotNull
    public static Set<VirtualFile> getAllVisibleRoots(@NotNull Collection<VirtualFile> roots, @Nullable VcsLogRootFilter rootFilter, @Nullable VcsLogStructureFilter structureFilter) {
        if (rootFilter == null && structureFilter == null) {
            return new HashSet<VirtualFile>(roots);
        }
        Set<VirtualFile> fromRootFilter = rootFilter != null ? rootFilter.getRoots() : roots;
        Set<VirtualFile> fromStructureFilter = structureFilter != null ? VcsLogUtil.collectRoots(structureFilter.getFiles(), new HashSet(roots)) : roots;
        return new HashSet<VirtualFile>(ContainerUtil.intersection((Collection)fromRootFilter, (Collection)fromStructureFilter));
    }

    @NotNull
    public static Set<FilePath> getFilteredFilesForRoot(@NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection) {
        VcsLogStructureFilter structureFilter = (VcsLogStructureFilter)filterCollection.get(VcsLogFilterCollection.STRUCTURE_FILTER);
        if (structureFilter == null) {
            return Collections.emptySet();
        }
        Collection files = structureFilter.getFiles();
        return new HashSet<FilePath>(ContainerUtil.filter((Collection)files, filePath -> {
            VirtualFile virtualFile = filePath.getVirtualFile();
            return root.equals(virtualFile) || FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)root), (File)filePath.getIOFile(), (boolean)false);
        }));
    }

    @Nullable
    public static String getSingleFilteredBranch(@NotNull VcsLogFilterCollection filters, @NotNull VcsLogRefs refs) {
        VcsLogBranchFilter filter = (VcsLogBranchFilter)filters.get(VcsLogFilterCollection.BRANCH_FILTER);
        if (filter == null) {
            return null;
        }
        String branchName = null;
        HashSet<VirtualFile> checkedRoots = new HashSet<VirtualFile>();
        for (VcsRef branch : refs.getBranches()) {
            if (!filter.matches(branch.getName())) continue;
            if (branchName == null) {
                branchName = branch.getName();
            } else if (!branch.getName().equals(branchName)) {
                return null;
            }
            if (checkedRoots.contains(branch.getRoot())) {
                return null;
            }
            checkedRoots.add(branch.getRoot());
        }
        return branchName;
    }

    public static boolean isRegexp(@NotNull String text2) {
        return StringUtil.containsAnyChar((String)text2, (String)"()[]{}.*?+^$\\|");
    }

    @NotNull
    public static TextRevisionNumber convertToRevisionNumber(@NotNull Hash hash) {
        return new TextRevisionNumber(hash.asString(), hash.toShortString());
    }

    @NotNull
    public static VcsFullCommitDetails getDetails(@NotNull VcsLogData data, @NotNull VirtualFile root, @NotNull Hash hash) throws VcsException {
        return (VcsFullCommitDetails)Objects.requireNonNull(ContainerUtil.getFirstItem(VcsLogUtil.getDetails(data.getLogProvider(root), root, Collections.singletonList(hash.asString()))));
    }

    @NotNull
    public static List<? extends VcsFullCommitDetails> getDetails(@NotNull VcsLogProvider logProvider, @NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        ArrayList result2 = new ArrayList();
        logProvider.readFullDetails(root, hashes, result2::add);
        return result2;
    }

    @NotNull
    public static CommittedChangeListForRevision createCommittedChangeList(@NotNull VcsFullCommitDetails detail, boolean withChanges) {
        return new CommittedChangeListForRevision(detail.getSubject(), detail.getFullMessage(), VcsUserUtil.getShortPresentation(detail.getCommitter()), new Date(detail.getCommitTime()), withChanges ? detail.getChanges() : ContainerUtil.emptyList(), (VcsRevisionNumber)VcsLogUtil.convertToRevisionNumber((Hash)detail.getId()));
    }

    @NotNull
    public static CommittedChangeListForRevision createCommittedChangeList(@NotNull VcsFullCommitDetails detail) {
        return VcsLogUtil.createCommittedChangeList(detail, true);
    }

    @NotNull
    public static String getShortHash(@NotNull String hashString) {
        return VcsLogUtil.getShortHash(hashString, 8);
    }

    @NotNull
    public static String getShortHash(@NotNull String hashString, int shortHashLength) {
        return hashString.substring(0, Math.min(shortHashLength, hashString.length()));
    }

    @Nullable
    public static VcsRef findBranch(@NotNull RefsModel refs, @NotNull VirtualFile root, @NotNull String branchName) {
        CompressedRefs compressedRefs = refs.getAllRefsByRoot().get(root);
        if (compressedRefs == null) {
            return null;
        }
        Stream<VcsRef> branches = compressedRefs.streamBranches();
        return branches.filter(vcsRef -> vcsRef.getName().equals(branchName)).findFirst().orElse(null);
    }

    @NotNull
    public static List<Change> collectChanges(@NotNull List<? extends VcsFullCommitDetails> detailsList, @NotNull Function<? super VcsFullCommitDetails, ? extends Collection<Change>> getChanges) {
        ArrayList changes = new ArrayList();
        List detailsListReversed = ContainerUtil.reverse(detailsList);
        for (VcsFullCommitDetails details : detailsListReversed) {
            changes.addAll((Collection)getChanges.fun((Object)details));
        }
        return CommittedChangesTreeBrowser.zipChanges(changes);
    }

    @Nullable
    public static VirtualFile getActualRoot(@NotNull Project project, @NotNull FilePath path2) {
        VcsRoot rootObject = ProjectLevelVcsManager.getInstance((Project)project).getVcsRootObjectFor(path2);
        if (rootObject == null) {
            return null;
        }
        Map<VirtualFile, VcsLogProvider> providers = VcsLogManager.findLogProviders(Collections.singletonList(rootObject), project);
        if (providers.isEmpty()) {
            return null;
        }
        VcsLogProvider provider = (VcsLogProvider)Objects.requireNonNull(ContainerUtil.getFirstItem(providers.values()));
        return provider.getVcsRoot(project, rootObject.getPath(), path2);
    }

    @Nullable
    public static Collection<FilePath> getAffectedPaths(@NotNull VcsLogUi logUi) {
        return VcsLogUtil.getAffectedPaths(logUi.getDataPack());
    }

    @Nullable
    public static Collection<FilePath> getAffectedPaths(@NotNull VcsLogDataPack dataPack) {
        VcsLogStructureFilter structureFilter = (VcsLogStructureFilter)dataPack.getFilters().get(VcsLogFilterCollection.STRUCTURE_FILTER);
        if (structureFilter != null) {
            return structureFilter.getFiles();
        }
        return null;
    }

    @Nullable
    public static Collection<FilePath> getAffectedPaths(@NotNull VirtualFile root, @NotNull AnActionEvent e) {
        VcsLogUiProperties properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
        if (properties != null && properties.exists(MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES) && properties.get(MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES).booleanValue()) {
            Collection<FilePath> affectedFilePaths;
            VcsLogUi logUi = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
            Project project = e.getProject();
            if (logUi != null && project != null && (affectedFilePaths = VcsLogUtil.getAffectedPaths(logUi)) != null) {
                return ContainerUtil.filter(affectedFilePaths, path2 -> Objects.equals(VcsUtil.getVcsRootFor((Project)project, (FilePath)path2), root));
            }
        }
        return null;
    }

    public static int getMaxSize(@NotNull List<? extends VcsFullCommitDetails> detailsList) {
        int maxSize = 0;
        for (VcsFullCommitDetails vcsFullCommitDetails : detailsList) {
            maxSize = Math.max(VcsLogUtil.getSize(vcsFullCommitDetails), maxSize);
        }
        return maxSize;
    }

    public static int getSize(@NotNull VcsFullCommitDetails details) {
        if (details instanceof VcsChangesLazilyParsedDetails) {
            return ((VcsChangesLazilyParsedDetails)details).size();
        }
        int size = 0;
        for (int i = 0; i < details.getParents().size(); ++i) {
            size += details.getChanges(i).size();
        }
        return size;
    }

    public static int getShownChangesLimit() {
        return Registry.intValue((String)"vcs.log.max.changes.shown");
    }

    @NotNull
    @NonNls
    public static String getSizeText(int maxSize) {
        if (maxSize < 1000) {
            return String.valueOf(maxSize);
        }
        DecimalFormat format = new DecimalFormat("#.#");
        format.setRoundingMode(RoundingMode.FLOOR);
        if (maxSize < 10000) {
            return format.format((double)maxSize / 1000.0) + "K";
        }
        if (maxSize < 1000000) {
            return maxSize / 1000 + "K";
        }
        if (maxSize < 10000000) {
            return format.format((double)maxSize / 1000000.0) + "M";
        }
        return maxSize / 1000000 + "M";
    }

    @NotNull
    public static String getProvidersMapText(@NotNull Map<VirtualFile, VcsLogProvider> providers) {
        return "[" + StringUtil.join(providers.keySet(), file -> file.getPresentableUrl(), (String)", ") + "]";
    }

    @NotNull
    public static String getVcsDisplayName(@NotNull Project project, @NotNull Collection<VcsLogProvider> logProviders) {
        Set vcs = ContainerUtil.map2SetNotNull(logProviders, provider -> VcsUtil.findVcsByKey((Project)project, (VcsKey)provider.getSupportedVcs()));
        if (vcs.size() != 1) {
            return VcsLogBundle.message((String)"vcs", (Object[])new Object[0]);
        }
        return ((AbstractVcs)Objects.requireNonNull(ContainerUtil.getFirstItem((Collection)vcs))).getDisplayName();
    }

    @NotNull
    public static String getVcsDisplayName(@NotNull Project project, @NotNull VcsLogManager logManager) {
        return VcsLogUtil.getVcsDisplayName(project, logManager.getDataManager().getLogProviders().values());
    }
}

