/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.HintHint;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.filter.VcsLogFilterUiEx;
import com.intellij.vcs.log.ui.frame.ProgressStripe;
import com.intellij.vcs.log.ui.frame.VcsLogCommitDetailsListPanel;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.visible.VisiblePackRefresherImpl;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsLogUiUtil {
    @NotNull
    public static JComponent installProgress(@NotNull JComponent component, final @NotNull VcsLogData logData, final @NotNull String logId, @NotNull Disposable disposableParent) {
        final ProgressStripe progressStripe = new ProgressStripe(component, disposableParent, 300){

            @Override
            public void updateUI() {
                super.updateUI();
                if (this.myDecorator != null && logData.getProgress().isRunning()) {
                    this.startLoadingImmediately();
                }
            }
        };
        logData.getProgress().addProgressIndicatorListener(new VcsLogProgress.ProgressListener(){

            @Override
            public void progressStarted(@NotNull Collection<? extends VcsLogProgress.ProgressKey> keys) {
                if (VcsLogUiUtil.isProgressVisible(keys, logId)) {
                    progressStripe.startLoading();
                }
            }

            @Override
            public void progressChanged(@NotNull Collection<? extends VcsLogProgress.ProgressKey> keys) {
                if (VcsLogUiUtil.isProgressVisible(keys, logId)) {
                    progressStripe.startLoading();
                } else {
                    progressStripe.stopLoading();
                }
            }

            @Override
            public void progressStopped() {
                progressStripe.stopLoading();
            }
        }, disposableParent);
        return progressStripe;
    }

    public static boolean isProgressVisible(@NotNull Collection<? extends VcsLogProgress.ProgressKey> keys, @NotNull String logId) {
        if (keys.contains(VcsLogData.DATA_PACK_REFRESH)) {
            return true;
        }
        return ContainerUtil.find(keys, key -> VisiblePackRefresherImpl.isVisibleKeyFor(key, logId)) != null;
    }

    @NotNull
    public static JScrollPane setupScrolledGraph(@NotNull VcsLogGraphTable graphTable, int border) {
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)graphTable), (int)border);
        ComponentUtil.putClientProperty((JComponent)scrollPane, (Key)UIUtil.KEEP_BORDER_SIDES, (Object)2);
        graphTable.viewportSet(scrollPane.getViewport());
        return scrollPane;
    }

    public static void installDetailsListeners(@NotNull VcsLogGraphTable graphTable, @NotNull VcsLogCommitDetailsListPanel detailsPanel, @NotNull VcsLogData logData, @NotNull Disposable disposableParent) {
        Runnable miniDetailsLoadedListener = () -> {
            graphTable.reLayout();
            graphTable.repaint();
        };
        Runnable containingBranchesListener = () -> {
            detailsPanel.branchesChanged();
            graphTable.repaint();
        };
        logData.getMiniDetailsGetter().addDetailsLoadedListener(miniDetailsLoadedListener);
        logData.getContainingBranchesGetter().addTaskCompletedListener(containingBranchesListener);
        Disposer.register((Disposable)disposableParent, () -> {
            logData.getContainingBranchesGetter().removeTaskCompletedListener(containingBranchesListener);
            logData.getMiniDetailsGetter().removeDetailsLoadedListener(miniDetailsLoadedListener);
        });
    }

    @NotNull
    public static SimpleTextAttributes getLinkAttributes() {
        return new SimpleTextAttributes(0, JBUI.CurrentTheme.Link.linkColor());
    }

    public static void showTooltip(@NotNull JComponent component, @NotNull Point point, @NotNull Balloon.Position position, @NotNull String text2) {
        JEditorPane tipComponent = IdeTooltipManager.initPane((String)text2, (HintHint)new HintHint((Component)component, point).setAwtTooltip(true), null);
        IdeTooltip tooltip = new IdeTooltip((Component)component, point, (JComponent)new Wrapper((JComponent)tipComponent), new Object[0]).setPreferredPosition(position).setToCenter(false).setToCenterIfSmall(false);
        IdeTooltipManager.getInstance().show(tooltip, false);
    }

    @NotNull
    public static History installNavigationHistory(@NotNull VcsLogUiEx ui2) {
        History history = new History((Place.Navigator)new VcsLogPlaceNavigator(ui2));
        ui2.getTable().getSelectionModel().addListSelectionListener(e -> {
            if (!history.isNavigatingNow() && !e.getValueIsAdjusting()) {
                history.pushQueryPlace();
            }
        });
        return history;
    }

    @NotNull
    public static String shortenTextToFit(@NotNull String text2, @NotNull FontMetrics fontMetrics, int availableWidth, int maxLength, @NotNull String symbol) {
        if (fontMetrics.stringWidth(text2) <= availableWidth) {
            return text2;
        }
        for (int i = text2.length(); i > maxLength; --i) {
            String result2 = StringUtil.shortenTextWithEllipsis((String)text2, (int)i, (int)0, (String)symbol);
            if (fontMetrics.stringWidth(result2) > availableWidth) continue;
            return result2;
        }
        return StringUtil.shortenTextWithEllipsis((String)text2, (int)maxLength, (int)0, (String)symbol);
    }

    public static int getHorizontalTextPadding(@NotNull SimpleColoredComponent component) {
        Insets borderInsets = component.getMyBorder().getBorderInsets((Component)component);
        Insets ipad = component.getIpad();
        return borderInsets.left + borderInsets.right + ipad.left + ipad.right;
    }

    public static void appendActionToEmptyText(@Nls @NotNull StatusText emptyText, @Nls @NotNull String text2, @NotNull Runnable action) {
        emptyText.appendSecondaryText(text2, VcsLogUiUtil.getLinkAttributes(), e -> action.run());
    }

    public static void appendResetFiltersActionToEmptyText(@NotNull VcsLogFilterUiEx filterUi, @Nls @NotNull StatusText emptyText) {
        VcsLogUiUtil.appendActionToEmptyText(emptyText, VcsLogBundle.message((String)"vcs.log.reset.filters.status.action", (Object[])new Object[0]), filterUi::clearFilters);
    }

    public static boolean isDiffPreviewInEditor() {
        return Registry.is((String)"vcs.log.show.diff.preview.as.editor.tab");
    }

    public static void installHighlighters(@NotNull AbstractVcsLogUi logUi, @NotNull Predicate<? super VcsLogHighlighterFactory> enabled) {
        AbstractVcsLogUi.LOG_HIGHLIGHTER_FACTORY_EP.addChangeListener(() -> VcsLogUiUtil.updateHighlighters(logUi, enabled), (Disposable)logUi);
        VcsLogUiUtil.updateHighlighters(logUi, enabled);
    }

    private static void updateHighlighters(@NotNull AbstractVcsLogUi logUi, @NotNull Predicate<? super VcsLogHighlighterFactory> enabled) {
        logUi.getTable().removeAllHighlighters();
        for (VcsLogHighlighterFactory factory : AbstractVcsLogUi.LOG_HIGHLIGHTER_FACTORY_EP.getExtensionList()) {
            if (!enabled.test(factory)) continue;
            logUi.getTable().addHighlighter(factory.createHighlighter(logUi.getLogData(), logUi));
        }
    }

    private static class VcsLogPlaceNavigator
    implements Place.Navigator {
        @NonNls
        private static final String PLACE_KEY = "Vcs.Log.Ui.History.PlaceKey";
        @NotNull
        private final VcsLogUiEx myUi;

        private VcsLogPlaceNavigator(@NotNull VcsLogUiEx ui2) {
            this.myUi = ui2;
        }

        public final void queryPlace(@NotNull Place place) {
            List commits = this.myUi.getVcsLog().getSelectedCommits();
            if (commits.size() > 0) {
                place.putPath(PLACE_KEY, commits.get(0));
            }
        }

        public final ActionCallback navigateTo(@Nullable Place place, final boolean requestFocus) {
            if (place == null) {
                return ActionCallback.DONE;
            }
            Object value = place.getPath(PLACE_KEY);
            if (!(value instanceof CommitId)) {
                return ActionCallback.REJECTED;
            }
            CommitId commitId = (CommitId)value;
            final ActionCallback callback2 = new ActionCallback();
            ListenableFuture<Boolean> future2 = this.myUi.jumpToCommit(commitId.getHash(), commitId.getRoot());
            Futures.addCallback(future2, (FutureCallback)new FutureCallback<Boolean>(){

                public void onSuccess(Boolean success2) {
                    if (success2.booleanValue()) {
                        if (requestFocus) {
                            myUi.getTable().requestFocusInWindow();
                        }
                        callback2.setDone();
                    } else {
                        callback2.setRejected();
                    }
                }

                public void onFailure(Throwable t) {
                    callback2.setRejected();
                }
            }, (Executor)EdtExecutorService.getInstance());
            return callback2;
        }
    }
}

