/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableCellState;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.paint.GraphCellPainter;
import com.intellij.vcs.log.paint.PaintParameters;
import com.intellij.vcs.log.ui.render.GraphCommitCell;
import com.intellij.vcs.log.ui.render.LabelIconCache;
import com.intellij.vcs.log.ui.render.LabelPainter;
import com.intellij.vcs.log.ui.render.TooltipReferencesPanel;
import com.intellij.vcs.log.ui.render.TypeSafeTableCellRenderer;
import com.intellij.vcs.log.ui.table.GraphCommitCellController;
import com.intellij.vcs.log.ui.table.VcsLogCellRenderer;
import com.intellij.vcs.log.ui.table.VcsLogColumn;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphCommitCellRenderer
extends TypeSafeTableCellRenderer<GraphCommitCell>
implements VcsLogCellRenderer {
    private static final int MAX_GRAPH_WIDTH = 6;
    private static final int VERTICAL_PADDING = JBUIScale.scale((int)7);
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final MyComponent myComponent;
    @NotNull
    private final MyComponent myTemplateComponent;

    public GraphCommitCellRenderer(@NotNull VcsLogData logData, @NotNull GraphCellPainter painter, @NotNull VcsLogGraphTable table) {
        this.myLogData = logData;
        this.myGraphTable = table;
        LabelIconCache iconCache = new LabelIconCache();
        this.myComponent = new MyComponent(logData, painter, table, iconCache);
        this.myTemplateComponent = new MyComponent(logData, painter, table, iconCache);
    }

    protected SimpleColoredComponent getTableCellRendererComponentImpl(@NotNull JTable table, @NotNull GraphCommitCell value, boolean isSelected, boolean hasFocus, int row2, int column) {
        this.myComponent.customize(value, isSelected, hasFocus, row2, column);
        return this.myComponent;
    }

    @Nullable
    private JComponent getTooltip(@NotNull Object value, @NotNull Point point, int row2) {
        double distance;
        GraphCommitCell cell = (GraphCommitCell)this.getValue(value);
        Collection<VcsRef> refs = cell.getRefsToThisCommit();
        if (!refs.isEmpty() && (this.myComponent.getReferencePainter().isLeftAligned() ? (distance = point.getX() - (double)this.myTemplateComponent.getGraphWidth(cell.getPrintElements())) > 0.0 && distance <= (double)this.getReferencesWidth(row2, cell) : (double)this.getColumnWidth() - point.getX() <= (double)this.getReferencesWidth(row2, cell))) {
            return new TooltipReferencesPanel(this.myLogData, refs);
        }
        return null;
    }

    public int getPreferredHeight() {
        return this.myComponent.getPreferredHeight();
    }

    private int getReferencesWidth(int row2) {
        return this.getReferencesWidth(row2, (GraphCommitCell)this.getValue(this.myGraphTable.getModel().getValueAt(row2, VcsLogColumn.COMMIT)));
    }

    private int getReferencesWidth(int row2, @NotNull GraphCommitCell cell) {
        Collection<VcsRef> refs = cell.getRefsToThisCommit();
        if (!refs.isEmpty()) {
            this.myTemplateComponent.customize(cell, this.myGraphTable.isRowSelected(row2), this.myGraphTable.hasFocus(), row2, VcsLogColumn.COMMIT.ordinal());
            return this.myTemplateComponent.getReferencePainter().getSize().width;
        }
        return 0;
    }

    private int getGraphWidth(int row2) {
        GraphCommitCell cell = (GraphCommitCell)this.getValue(this.myGraphTable.getModel().getValueAt(row2, VcsLogColumn.COMMIT));
        return this.myTemplateComponent.getGraphWidth(cell.getPrintElements());
    }

    private int getTooltipXCoordinate(int row2) {
        int referencesWidth = this.getReferencesWidth(row2);
        if (referencesWidth != 0) {
            if (this.myComponent.getReferencePainter().isLeftAligned()) {
                return this.getGraphWidth(row2) + referencesWidth / 2;
            }
            return this.getColumnWidth() - referencesWidth / 2;
        }
        return this.getColumnWidth() / 2;
    }

    private int getColumnWidth() {
        return this.myGraphTable.getCommitColumn().getWidth();
    }

    public void setCompactReferencesView(boolean compact) {
        this.myComponent.getReferencePainter().setCompact(compact);
        this.myTemplateComponent.getReferencePainter().setCompact(compact);
    }

    public void setShowTagsNames(boolean showTagNames) {
        this.myComponent.getReferencePainter().setShowTagNames(showTagNames);
        this.myTemplateComponent.getReferencePainter().setShowTagNames(showTagNames);
    }

    public void setLeftAligned(boolean leftAligned) {
        this.myComponent.getReferencePainter().setLeftAligned(leftAligned);
        this.myTemplateComponent.getReferencePainter().setLeftAligned(leftAligned);
    }

    @Override
    @NotNull
    public GraphCommitCellController getCellController() {
        return new GraphCommitCellController(this.myLogData, this.myGraphTable, this.myComponent.myPainter){

            @Override
            protected int getTooltipXCoordinate(int row2) {
                return GraphCommitCellRenderer.this.getTooltipXCoordinate(row2);
            }

            @Override
            @Nullable
            protected JComponent getTooltip(@NotNull Object value, @NotNull Point point, int row2) {
                return GraphCommitCellRenderer.this.getTooltip(value, point, row2);
            }
        };
    }

    public static Font getLabelFont() {
        return UIUtil.getLabelFont();
    }

    public static class BorderlessTableCellState
    extends TableCellState {
        @Nullable
        protected Border getBorder(boolean isSelected, boolean hasFocus) {
            return null;
        }
    }

    private static class GraphImage {
        private final int myWidth;
        @NotNull
        private final Image myImage;

        GraphImage(@NotNull Image image, int width) {
            this.myImage = image;
            this.myWidth = width;
        }

        @NotNull
        Image getImage() {
            return this.myImage;
        }

        int getWidth() {
            return this.myWidth;
        }
    }

    private static class MyComponent
    extends SimpleColoredRenderer {
        private static final int DISPLAYED_MESSAGE_PART = 80;
        @NotNull
        private final VcsLogGraphTable myGraphTable;
        @NotNull
        private final GraphCellPainter myPainter;
        @NotNull
        private final IssueLinkRenderer myIssueLinkRenderer;
        @NotNull
        private final LabelPainter myReferencePainter;
        @NotNull
        protected GraphImage myGraphImage = new GraphImage(ImageUtil.createImage((int)1, (int)1, (int)2), 0);
        @NotNull
        private Font myFont;
        private int myHeight;
        private AffineTransform myAffineTransform;

        MyComponent(@NotNull VcsLogData data, @NotNull GraphCellPainter painter, @NotNull VcsLogGraphTable table, @NotNull LabelIconCache iconCache) {
            this.myPainter = painter;
            this.myGraphTable = table;
            this.myReferencePainter = new LabelPainter(data, (JComponent)((Object)table), iconCache);
            this.myIssueLinkRenderer = new IssueLinkRenderer(data.getProject(), (SimpleColoredComponent)this);
            this.setCellState(new BorderlessTableCellState());
            this.myFont = GraphCommitCellRenderer.getLabelFont();
            GraphicsConfiguration configuration = this.myGraphTable.getGraphicsConfiguration();
            this.myAffineTransform = configuration != null ? configuration.getDefaultTransform() : null;
            this.myHeight = this.calculateHeight();
        }

        @NotNull
        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            int referencesSize = this.myReferencePainter.isLeftAligned() ? 0 : this.myReferencePainter.getSize().width;
            return new Dimension(preferredSize.width + referencesSize, this.getPreferredHeight());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            int graphImageWidth = this.myGraphImage.getWidth();
            Graphics2D g2d = (Graphics2D)g;
            if (!this.myReferencePainter.isLeftAligned()) {
                int start2 = Math.max(graphImageWidth, this.getWidth() - this.myReferencePainter.getSize().width);
                this.myReferencePainter.paint(g2d, start2, 0, this.getHeight());
            } else {
                this.myReferencePainter.paint(g2d, graphImageWidth, 0, this.getHeight());
            }
            AffineTransform origTx = PaintUtil.alignTxToInt((Graphics2D)g2d, null, (boolean)false, (boolean)true, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.ROUND_FLOOR_BIAS);
            try {
                UIUtil.drawImage((Graphics)g, (Image)this.myGraphImage.getImage(), (int)0, (int)0, null);
            }
            finally {
                if (origTx != null) {
                    g2d.setTransform(origTx);
                }
            }
        }

        public void customize(@NotNull GraphCommitCell cell, boolean isSelected, boolean hasFocus, int row2, int column) {
            this.clear();
            this.setPaintFocusBorder(false);
            this.acquireState((JTable)((Object)this.myGraphTable), isSelected, hasFocus, row2, column);
            this.getCellState().updateRenderer((JComponent)((Object)this));
            this.myGraphImage = this.getGraphImage(cell.getPrintElements());
            SimpleTextAttributes style = this.myGraphTable.applyHighlighters((Component)((Object)this), row2, column, hasFocus, isSelected);
            Collection<VcsRef> refs = cell.getRefsToThisCommit();
            Color baseForeground = Objects.requireNonNull(this.myGraphTable.getBaseStyle(row2, column, hasFocus, isSelected).getForeground());
            this.append("");
            if (this.myReferencePainter.isLeftAligned()) {
                this.myReferencePainter.customizePainter(refs, this.getBackground(), baseForeground, isSelected, this.getAvailableWidth(column, this.myGraphImage.getWidth()));
                int referencesWidth = this.myReferencePainter.getSize().width;
                if (referencesWidth > 0) {
                    referencesWidth += LabelPainter.RIGHT_PADDING.get();
                }
                this.appendTextPadding(this.myGraphImage.getWidth() + referencesWidth);
                this.appendText(cell, style, isSelected);
            } else {
                this.appendTextPadding(this.myGraphImage.getWidth());
                this.appendText(cell, style, isSelected);
                this.myReferencePainter.customizePainter(refs, this.getBackground(), baseForeground, isSelected, this.getAvailableWidth(column, this.myGraphImage.getWidth()));
            }
        }

        private void appendText(@NotNull GraphCommitCell cell, @NotNull SimpleTextAttributes style, boolean isSelected) {
            this.myIssueLinkRenderer.appendTextWithLinks(StringUtil.replace((String)cell.getText(), (String)"\t", (String)" ").trim(), style);
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)((Object)this.myGraphTable), (SimpleColoredComponent)this, (boolean)false, (boolean)isSelected);
        }

        private int getAvailableWidth(int column, int graphWidth) {
            int textAndLabelsWidth = this.myGraphTable.getColumnModel().getColumn(column).getWidth() - graphWidth;
            int freeSpace = textAndLabelsWidth - super.getPreferredSize().width;
            int allowedSpace = this.myReferencePainter.isCompact() ? Math.min(freeSpace, textAndLabelsWidth / 3) : Math.max(freeSpace, Math.max(textAndLabelsWidth / 2, textAndLabelsWidth - JBUIScale.scale((int)80)));
            return Math.max(0, allowedSpace);
        }

        private int calculateHeight() {
            return Math.max(this.myReferencePainter.getSize().height, this.getFontMetrics(this.myFont).getHeight() + VERTICAL_PADDING);
        }

        public int getPreferredHeight() {
            Font font = GraphCommitCellRenderer.getLabelFont();
            GraphicsConfiguration configuration = this.myGraphTable.getGraphicsConfiguration();
            if (this.myFont != font || configuration != null && !Objects.equals(this.myAffineTransform, configuration.getDefaultTransform())) {
                this.myFont = font;
                this.myAffineTransform = configuration != null ? configuration.getDefaultTransform() : null;
                this.myHeight = this.calculateHeight();
            }
            return this.myHeight;
        }

        @NotNull
        private GraphImage getGraphImage(@NotNull Collection<? extends PrintElement> printElements) {
            double maxIndex = this.getMaxGraphElementIndex(printElements);
            BufferedImage image = UIUtil.createImage((GraphicsConfiguration)this.myGraphTable.getGraphicsConfiguration(), (double)((int)((double)PaintParameters.getNodeWidth(this.myGraphTable.getRowHeight()) * (maxIndex + 2.0))), (double)this.myGraphTable.getRowHeight(), (int)2, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.CEIL);
            Graphics2D g2 = image.createGraphics();
            this.myPainter.draw(g2, printElements);
            int width = (int)(maxIndex * (double)PaintParameters.getNodeWidth(this.myGraphTable.getRowHeight()));
            return new GraphImage(image, width);
        }

        private int getGraphWidth(@NotNull Collection<? extends PrintElement> printElements) {
            double maxIndex = this.getMaxGraphElementIndex(printElements);
            return (int)(maxIndex * (double)PaintParameters.getNodeWidth(this.myGraphTable.getRowHeight()));
        }

        private double getMaxGraphElementIndex(@NotNull Collection<? extends PrintElement> printElements) {
            double maxIndex = 0.0;
            for (PrintElement printElement : printElements) {
                maxIndex = Math.max(maxIndex, (double)printElement.getPositionInCurrentRow());
                if (!(printElement instanceof EdgePrintElement)) continue;
                maxIndex = Math.max(maxIndex, (double)(printElement.getPositionInCurrentRow() + ((EdgePrintElement)printElement).getPositionInOtherRow()) / 2.0);
            }
            maxIndex += 1.0;
            maxIndex = Math.max(maxIndex, (double)Math.min(6, this.myGraphTable.getVisibleGraph().getRecommendedWidth()));
            return maxIndex;
        }

        @NotNull
        public LabelPainter getReferencePainter() {
            return this.myReferencePainter;
        }

        public FontMetrics getFontMetrics(Font font) {
            return this.myGraphTable.getFontMetrics(font);
        }
    }
}

