/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.highlighters;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.JBColor;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class IndexHighlighter
implements VcsLogHighlighter {
    public static final JBColor NOT_INDEXED_COMMIT_FOREGROUND = JBColor.BLUE;
    @NotNull
    private final VcsLogData myLogData;

    public IndexHighlighter(@NotNull VcsLogData logData) {
        this.myLogData = logData;
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getStyle(int commitId, @NotNull VcsShortCommitDetails details, boolean isSelected) {
        if (isSelected || !Registry.is((String)"vcs.log.highlight.not.indexed")) {
            return VcsLogHighlighter.VcsCommitStyle.DEFAULT;
        }
        VcsLogIndex index = this.myLogData.getIndex();
        if (!index.isIndexed(commitId)) {
            return VcsCommitStyleFactory.foreground((Color)NOT_INDEXED_COMMIT_FOREGROUND);
        }
        return VcsLogHighlighter.VcsCommitStyle.DEFAULT;
    }

    public void update(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
    }

    public static class Factory
    implements VcsLogHighlighterFactory {
        @NotNull
        private static final String ID = "INDEXED_COMMITS";

        @Override
        @NotNull
        public VcsLogHighlighter createHighlighter(@NotNull VcsLogData logData, @NotNull VcsLogUi logUi) {
            return new IndexHighlighter(logData);
        }

        @Override
        @NotNull
        public String getId() {
            return ID;
        }

        @Override
        @NotNull
        public String getTitle() {
            return VcsLogBundle.message((String)"vcs.log.action.highlight.indexed.commits", (Object[])new Object[0]);
        }

        @Override
        public boolean showMenuItem() {
            return false;
        }
    }
}

