/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.google.common.primitives.Ints;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.commit.message.CommitMessageInspectionProfile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.details.CommitDetailsListPanel;
import com.intellij.vcs.log.ui.frame.CommitPanel;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import com.intellij.vcs.log.ui.table.CommitSelectionListener;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Unit;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogCommitDetailsListPanel
extends CommitDetailsListPanel<CommitPanel>
implements Disposable {
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private List<Integer> mySelection = ContainerUtil.emptyList();
    @Nullable
    private ProgressIndicator myResolveIndicator = null;

    public VcsLogCommitDetailsListPanel(@NotNull VcsLogData logData, @NotNull VcsLogColorManager colorManager, @NotNull Disposable parent) {
        super(parent);
        this.myLogData = logData;
        this.myColorManager = colorManager;
        logData.getProject().getMessageBus().connect((Disposable)this).subscribe(CommitMessageInspectionProfile.TOPIC, () -> this.update());
        this.setStatusText(VcsLogBundle.message((String)"vcs.log.commit.details.status", (Object[])new Object[0]));
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public void installCommitSelectionListener(@NotNull VcsLogGraphTable graphTable) {
        graphTable.getSelectionModel().addListSelectionListener(new CommitSelectionListenerForDetails(graphTable));
    }

    public void branchesChanged() {
        this.forEachPanelIndexed((i, panel2) -> {
            panel2.updateBranches();
            return Unit.INSTANCE;
        });
    }

    private void resolveHashes(@NotNull List<? extends CommitId> ids, @NotNull List<? extends CommitPresentationUtil.CommitPresentation> presentations, @NotNull Set<String> unResolvedHashes, @NotNull Condition<Object> expired) {
        if (!unResolvedHashes.isEmpty()) {
            this.myResolveIndicator = BackgroundTaskUtil.executeOnPooledThread((Disposable)this, () -> {
                MultiMap resolvedHashes = new MultiMap();
                HashSet fullHashes = new HashSet(ContainerUtil.filter((Collection)unResolvedHashes, h -> h.length() == 40));
                for (String fullHash : fullHashes) {
                    Hash hash = HashImpl.build(fullHash);
                    for (VirtualFile root : this.myLogData.getRoots()) {
                        CommitId id = new CommitId(hash, root);
                        if (!this.myLogData.getStorage().containsCommit(id)) continue;
                        resolvedHashes.putValue((Object)fullHash, (Object)id);
                    }
                }
                unResolvedHashes.removeAll(fullHashes);
                if (!unResolvedHashes.isEmpty()) {
                    this.myLogData.getStorage().iterateCommits((Function<? super CommitId, Boolean>)((Function)commitId -> {
                        for (String hashString : unResolvedHashes) {
                            if (!StringUtil.startsWithIgnoreCase((String)commitId.getHash().asString(), (String)hashString)) continue;
                            resolvedHashes.putValue((Object)hashString, commitId);
                        }
                        return false;
                    }));
                }
                List resolvedPresentations = ContainerUtil.map2List((Collection)presentations, presentation -> presentation.resolve((MultiMap<String, CommitId>)resolvedHashes));
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myResolveIndicator = null;
                    this.setPresentations(ids, resolvedPresentations);
                }, Conditions.or(o -> this.myResolveIndicator != indicator, (Condition)expired));
            });
        }
    }

    private void cancelResolve() {
        if (this.myResolveIndicator != null) {
            this.myResolveIndicator.cancel();
            this.myResolveIndicator = null;
        }
    }

    private void setPresentations(@NotNull List<? extends CommitId> ids, @NotNull List<? extends CommitPresentationUtil.CommitPresentation> presentations) {
        this.forEachPanelIndexed((i, panel2) -> {
            panel2.setCommit((CommitId)ids.get((int)i), (CommitPresentationUtil.CommitPresentation)presentations.get((int)i));
            return Unit.INSTANCE;
        });
    }

    public void dispose() {
        this.cancelResolve();
    }

    @Override
    @NotNull
    protected CommitPanel getCommitDetailsPanel() {
        return new CommitPanel(this.myLogData, this.myColorManager, (Consumer<? super CommitId>)((Consumer)this::navigate));
    }

    private class CommitSelectionListenerForDetails
    extends CommitSelectionListener<VcsCommitMetadata> {
        CommitSelectionListenerForDetails(VcsLogGraphTable graphTable) {
            super(graphTable, VcsLogCommitDetailsListPanel.this.myLogData.getMiniDetailsGetter());
        }

        @Override
        protected void onDetailsLoaded(@NotNull List<? extends VcsCommitMetadata> detailsList) {
            List ids = ContainerUtil.map(detailsList, detail -> new CommitId((Hash)detail.getId(), detail.getRoot()));
            HashSet unResolvedHashes = new HashSet();
            List presentations = ContainerUtil.map(detailsList, detail -> CommitPresentationUtil.buildPresentation(VcsLogCommitDetailsListPanel.this.myLogData.getProject(), detail, unResolvedHashes));
            VcsLogCommitDetailsListPanel.this.setPresentations(ids, presentations);
            List currentSelection = VcsLogCommitDetailsListPanel.this.mySelection;
            VcsLogCommitDetailsListPanel.this.resolveHashes(ids, presentations, unResolvedHashes, (Condition<Object>)o -> currentSelection != VcsLogCommitDetailsListPanel.this.mySelection);
        }

        @Override
        protected void onSelection(int @NotNull [] selection) {
            VcsLogCommitDetailsListPanel.this.cancelResolve();
            int shownPanelsCount = VcsLogCommitDetailsListPanel.this.rebuildPanel(selection.length);
            VcsLogCommitDetailsListPanel.this.mySelection = Ints.asList((int[])Arrays.copyOf(selection, shownPanelsCount));
            List currentSelection = VcsLogCommitDetailsListPanel.this.mySelection;
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                ArrayList<List<VcsRef>> result2 = new ArrayList<List<VcsRef>>();
                for (Integer row2 : currentSelection) {
                    result2.add(this.myGraphTable.getModel().getRefsAtRow(row2));
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (currentSelection == VcsLogCommitDetailsListPanel.this.mySelection) {
                        VcsLogCommitDetailsListPanel.this.forEachPanelIndexed((i, panel2) -> {
                            panel2.setRefs((Collection)result2.get((int)i));
                            return Unit.INSTANCE;
                        });
                    }
                });
            });
        }

        @Override
        protected void onEmptySelection() {
            VcsLogCommitDetailsListPanel.this.cancelResolve();
            this.setEmpty(VcsLogBundle.message((String)"vcs.log.changes.details.no.commits.selected.status", (Object[])new Object[0]));
        }

        @Override
        @NotNull
        protected List<Integer> getSelectionToLoad() {
            return VcsLogCommitDetailsListPanel.this.mySelection;
        }

        @Override
        protected void startLoading() {
            VcsLogCommitDetailsListPanel.this.startLoadingDetails();
        }

        @Override
        protected void stopLoading() {
            VcsLogCommitDetailsListPanel.this.stopLoadingDetails();
        }

        @Override
        protected void onError(@NotNull Throwable error) {
            this.setEmpty(VcsLogBundle.message((String)"vcs.log.error.loading.status", (Object[])new Object[0]));
        }

        private void setEmpty(@Nls @NotNull String text2) {
            VcsLogCommitDetailsListPanel.this.setStatusText(text2);
            VcsLogCommitDetailsListPanel.this.mySelection = ContainerUtil.emptyList();
            VcsLogCommitDetailsListPanel.this.setCommits(ContainerUtil.emptyList());
        }
    }
}

