/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcs.log.ui.frame.VcsLogChangesBrowser;
import java.util.stream.Stream;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogChangeProcessor
extends ChangeViewDiffRequestProcessor {
    @NotNull
    private final VcsLogChangesBrowser myBrowser;

    VcsLogChangeProcessor(@NotNull Project project, @NotNull VcsLogChangesBrowser browser2, boolean isInEditor, @NotNull Disposable disposable) {
        super(project, isInEditor ? "Default" : "VcsLogView");
        this.myBrowser = browser2;
        this.myContentPanel.setBorder(IdeBorderFactory.createBorder((int)2));
        Disposer.register((Disposable)disposable, (Disposable)this);
        this.myBrowser.addListener(() -> this.updatePreviewLater(), (Disposable)this);
        this.myBrowser.getViewer().addSelectionListener(this::updatePreviewLater, (Disposable)this);
    }

    protected boolean shouldAddToolbarBottomBorder(@NotNull FrameDiffTool.ToolbarComponents toolbarComponents) {
        return false;
    }

    @NotNull
    public Wrapper getToolbarWrapper() {
        return this.myToolbarWrapper;
    }

    @Override
    @NotNull
    protected Stream<ChangeViewDiffRequestProcessor.Wrapper> getSelectedChanges() {
        boolean hasSelection = this.myBrowser.getViewer().getSelectionModel().getSelectionCount() != 0;
        return this.wrap(hasSelection ? VcsTreeModelData.selected((JTree)((Object)this.myBrowser.getViewer())) : VcsTreeModelData.all((JTree)((Object)this.myBrowser.getViewer())));
    }

    @Override
    @NotNull
    protected Stream<ChangeViewDiffRequestProcessor.Wrapper> getAllChanges() {
        return this.wrap(VcsTreeModelData.all((JTree)((Object)this.myBrowser.getViewer())));
    }

    @NotNull
    private Stream<ChangeViewDiffRequestProcessor.Wrapper> wrap(@NotNull VcsTreeModelData modelData) {
        return modelData.userObjectsStream(Change.class).map(x$0 -> new MyChangeWrapper((Change)x$0));
    }

    @Override
    protected void selectChange(@NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
        TreePath path2;
        ChangesTree tree = this.myBrowser.getViewer();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        DefaultMutableTreeNode objectNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)root, (Object)change.getUserObject());
        TreePath treePath = path2 = objectNode != null ? TreeUtil.getPathFromRoot((TreeNode)objectNode) : null;
        if (path2 != null) {
            TreeUtil.selectPath((JTree)((Object)tree), (TreePath)path2, (boolean)false);
        }
    }

    private void updatePreviewLater() {
        ApplicationManager.getApplication().invokeLater(() -> this.updatePreview(this.getComponent().isShowing()));
    }

    public void updatePreview(boolean state) {
        this.updatePreview(state, false);
    }

    private class MyChangeWrapper
    extends ChangeViewDiffRequestProcessor.ChangeWrapper {
        MyChangeWrapper(Change change) {
            super(change);
        }

        @Override
        @Nullable
        public DiffRequestProducer createProducer(@Nullable Project project) {
            return VcsLogChangeProcessor.this.myBrowser.getDiffRequestProducer(this.change, true);
        }
    }
}

