/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class ProgressStripeIcon
implements Icon {
    private static final int TRANSLATE = 1;
    @NotNull
    private final JComponent myReferenceComponent;
    private final int myShift;

    private ProgressStripeIcon(@NotNull JComponent component, int shift) {
        this.myReferenceComponent = component;
        this.myShift = shift;
    }

    public abstract int getChunkWidth();

    protected abstract void paint(@NotNull Graphics2D var1, int var2, int var3, int var4);

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        Graphics2D g2 = (Graphics2D)g;
        for (int shift = this.myShift - this.getChunkWidth(); shift < this.getIconWidth(); shift += this.getChunkWidth()) {
            this.paint(g2, x, y, shift);
        }
        config.restore();
    }

    @Override
    public int getIconWidth() {
        return this.myReferenceComponent.getWidth();
    }

    @NotNull
    public static AsyncProcessIcon generateIcon(final @NotNull JComponent component) {
        ArrayList<GradientIcon> result2 = new ArrayList<GradientIcon>();
        for (int i = 0; i < 2 * JBUIScale.scale((int)128); i += JBUIScale.scale((int)1)) {
            result2.add(new GradientIcon(component, i));
        }
        final Icon passive = (Icon)result2.get(0);
        final AsyncProcessIcon icon2 = new AsyncProcessIcon("ProgressStripeIcon", result2.toArray(new Icon[0]), passive){

            public Dimension getPreferredSize() {
                return new Dimension(component.getWidth(), passive.getIconHeight());
            }
        };
        component.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                icon2.revalidate();
            }
        });
        return icon2;
    }

    private static class GradientIcon
    extends ProgressStripeIcon {
        private static final Color DARK = new ProgressStripeColor(JBColor.namedColor((String)"ProgressBar.indeterminateStartColor", (Color)new JBColor(new Color(5087224), new Color(0x6A6A6A))), (Color)Gray.xD4);
        private static final Color LIGHT = new ProgressStripeColor(JBColor.namedColor((String)"ProgressBar.indeterminateEndColor", (Color)new JBColor(new Color(9487096), new Color(0x838383))), new Color(10001054));
        private static final int GRADIENT = 128;
        private static final int GRADIENT_HEIGHT = 2;

        private GradientIcon(@NotNull JComponent component, int shift) {
            super(component, shift);
        }

        @Override
        public int getChunkWidth() {
            return 2 * JBUIScale.scale((int)128);
        }

        @Override
        public void paint(@NotNull Graphics2D g2, int x, int y, int shift) {
            Color dark = DARK;
            Color light = LIGHT;
            g2.setPaint(new GradientPaint(x + shift, y, dark, x + shift + JBUIScale.scale((int)128), y, light));
            g2.fill(new Rectangle(x + shift, y, JBUIScale.scale((int)128), this.getIconHeight()));
            g2.setPaint(new GradientPaint(x + shift + JBUIScale.scale((int)128), y, light, x + shift + 2 * JBUIScale.scale((int)128), y, dark));
            g2.fill(new Rectangle(x + shift + JBUIScale.scale((int)128), y, JBUIScale.scale((int)128), this.getIconHeight()));
        }

        @Override
        public int getIconHeight() {
            return JBUIScale.scale((int)2);
        }

        private static class ProgressStripeColor
        extends JBColor {
            private ProgressStripeColor(@NotNull JBColor defaultColor, @NotNull Color graphiteColor) {
                super(() -> {
                    if (UIUtil.isUnderAquaBasedLookAndFeel() && !StartupUiUtil.isUnderDarcula() && UIUtil.isGraphite()) {
                        return graphiteColor;
                    }
                    return defaultColor;
                });
            }
        }
    }
}

