/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.ContainingBranchesGetter;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.details.commit.CommitDetailsPanel;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.awt.Color;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitPanel
extends CommitDetailsPanel {
    @NotNull
    final VcsLogData myLogData;
    @NotNull
    final VcsLogColorManager myColorManager;
    @Nullable
    CommitId myCommit;

    public CommitPanel(@NotNull VcsLogData logData, @NotNull VcsLogColorManager colorManager, @NotNull Consumer<? super CommitId> navigate) {
        super(logData.getProject(), (Function1<? super CommitId, Unit>)((Function1)commitId -> {
            navigate.consume(commitId);
            return Unit.INSTANCE;
        }));
        this.myLogData = logData;
        this.myColorManager = colorManager;
    }

    @Override
    public void setCommit(@NotNull CommitId commit, @NotNull CommitPresentationUtil.CommitPresentation presentation) {
        this.myCommit = commit;
        super.setCommit(commit, presentation);
        this.setBranches(this.myLogData.getContainingBranchesGetter().requestContainingBranches(commit.getRoot(), commit.getHash()));
        VirtualFile root = commit.getRoot();
        if (this.myColorManager.hasMultiplePaths()) {
            this.setRoot(new CommitDetailsPanel.RootColor(root, (Color)VcsLogGraphTable.getRootBackgroundColor(root, this.myColorManager)));
        } else {
            this.setRoot(null);
        }
    }

    public void setRefs(@NotNull Collection<VcsRef> refs) {
        this.setRefs(this.sortRefs(refs));
    }

    @NotNull
    protected List<? extends VcsRef> sortRefs(@NotNull Collection<? extends VcsRef> refs) {
        VcsRef ref = (VcsRef)ContainerUtil.getFirstItem(refs);
        if (ref == null) {
            return ContainerUtil.emptyList();
        }
        return ContainerUtil.sorted(refs, (Comparator)this.myLogData.getLogProvider(ref.getRoot()).getReferenceManager().getLabelsOrderComparator());
    }

    public void updateBranches() {
        if (this.myCommit != null) {
            ContainingBranchesGetter getter = this.myLogData.getContainingBranchesGetter();
            this.setBranches(getter.getContainingBranchesFromCache(this.myCommit.getRoot(), this.myCommit.getHash()));
        } else {
            this.setBranches(null);
        }
    }
}

