/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SearchTextField;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogRangeFilter;
import com.intellij.vcs.log.VcsLogRevisionFilter;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.filter.BranchFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.BranchFilters;
import com.intellij.vcs.log.ui.filter.DateFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.FilterPair;
import com.intellij.vcs.log.ui.filter.StructureFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.UserFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogFilterUiEx;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogClassicFilterUi
implements VcsLogFilterUiEx {
    private static final String VCS_LOG_TEXT_FILTER_HISTORY = "Vcs.Log.Text.Filter.History";
    private static final Logger LOG = Logger.getInstance(VcsLogClassicFilterUi.class);
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private VcsLogDataPack myDataPack;
    @NotNull
    protected final BranchFilterModel myBranchFilterModel;
    @NotNull
    protected final FilterModel.SingleFilterModel<VcsLogUserFilter> myUserFilterModel;
    @NotNull
    protected final FilterModel<VcsLogDateFilter> myDateFilterModel;
    @NotNull
    protected final FileFilterModel myStructureFilterModel;
    @NotNull
    protected final TextFilterModel myTextFilterModel;
    @NotNull
    private final TextFilterField myFilterField;

    public VcsLogClassicFilterUi(@NotNull VcsLogData logData, @NotNull Consumer<VcsLogFilterCollection> filterConsumer, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VcsLogColorManager colorManager, @Nullable VcsLogFilterCollection filters, @NotNull Disposable parentDisposable) {
        FilterModel[] models;
        this.myLogData = logData;
        this.myUiProperties = uiProperties;
        this.myDataPack = VisiblePack.EMPTY;
        this.myColorManager = colorManager;
        NotNullComputable dataPackGetter = () -> this.myDataPack;
        this.myBranchFilterModel = new BranchFilterModel((Computable<? extends VcsLogDataPack>)dataPackGetter, this.myLogData.getStorage(), this.myLogData.getRoots(), this.myUiProperties, filters);
        this.myUserFilterModel = new UserFilterModel(this.myUiProperties, filters);
        this.myDateFilterModel = new DateFilterModel(this.myUiProperties, filters);
        this.myStructureFilterModel = new FileFilterModel(this.myLogData.getLogProviders().keySet(), this.myUiProperties, filters);
        this.myTextFilterModel = new TextFilterModel(this.myUiProperties, filters, parentDisposable);
        this.myFilterField = new TextFilterField(this.myTextFilterModel);
        for (FilterModel model : models = new FilterModel[]{this.myBranchFilterModel, this.myUserFilterModel, this.myDateFilterModel, this.myStructureFilterModel, this.myTextFilterModel}) {
            model.addSetFilterListener(() -> {
                filterConsumer.consume((Object)this.getFilters());
                this.myBranchFilterModel.onStructureFilterChanged(this.myStructureFilterModel.getRootFilter(), this.myStructureFilterModel.getStructureFilter());
            });
        }
    }

    @Override
    public void updateDataPack(@NotNull VcsLogDataPack newDataPack) {
        this.myDataPack = newDataPack;
    }

    @Override
    @NotNull
    public SearchTextField getTextFilterComponent() {
        return this.myFilterField;
    }

    @Override
    @NotNull
    public ActionGroup createActionGroup() {
        FilterActionComponent structureFilterComponent;
        FilterActionComponent dateComponent;
        FilterActionComponent userComponent;
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        FilterActionComponent branchComponent = this.createBranchComponent();
        if (branchComponent != null) {
            actionGroup.add((AnAction)branchComponent);
        }
        if ((userComponent = this.createUserComponent()) != null) {
            actionGroup.add((AnAction)userComponent);
        }
        if ((dateComponent = this.createDateComponent()) != null) {
            actionGroup.add((AnAction)dateComponent);
        }
        if ((structureFilterComponent = this.createStructureFilterComponent()) != null) {
            actionGroup.add((AnAction)structureFilterComponent);
        }
        return actionGroup;
    }

    @NotNull
    public VcsLogFilterCollection getFilters() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return VcsLogFilterObject.collection(new VcsLogFilter[]{this.myBranchFilterModel.getBranchFilter(), this.myBranchFilterModel.getRevisionFilter(), this.myBranchFilterModel.getRangeFilter(), this.myTextFilterModel.getFilter1(), this.myTextFilterModel.getFilter2(), this.myStructureFilterModel.getFilter1(), this.myStructureFilterModel.getFilter2(), (VcsLogFilter)this.myDateFilterModel.getFilter(), (VcsLogFilter)this.myUserFilterModel.getFilter()});
    }

    @Override
    public void setFilters(@NotNull VcsLogFilterCollection collection) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myBranchFilterModel.setFilter(new BranchFilters((VcsLogBranchFilter)collection.get(VcsLogFilterCollection.BRANCH_FILTER), (VcsLogRevisionFilter)collection.get(VcsLogFilterCollection.REVISION_FILTER), (VcsLogRangeFilter)collection.get(VcsLogFilterCollection.RANGE_FILTER)));
        this.myStructureFilterModel.setFilter(new FilterPair<VcsLogFilter, VcsLogFilter>(collection.get(VcsLogFilterCollection.STRUCTURE_FILTER), collection.get(VcsLogFilterCollection.ROOT_FILTER)));
        this.myDateFilterModel.setFilter((VcsLogDateFilter)collection.get(VcsLogFilterCollection.DATE_FILTER));
        this.myTextFilterModel.setFilter((FilterPair<VcsLogTextFilter, VcsLogHashFilter>)new FilterPair<VcsLogFilter, VcsLogFilter>(collection.get(VcsLogFilterCollection.TEXT_FILTER), collection.get(VcsLogFilterCollection.HASH_FILTER)));
        this.myUserFilterModel.setFilter((VcsLogUserFilter)collection.get(VcsLogFilterCollection.USER_FILTER));
    }

    @Nullable
    protected FilterActionComponent createBranchComponent() {
        return new FilterActionComponent((Computable<? extends JComponent>)((Computable)() -> new BranchFilterPopupComponent(this.myUiProperties, this.myBranchFilterModel).initUi()));
    }

    @Nullable
    protected FilterActionComponent createUserComponent() {
        return new FilterActionComponent((Computable<? extends JComponent>)((Computable)() -> new UserFilterPopupComponent(this.myUiProperties, this.myLogData, this.myUserFilterModel).initUi()));
    }

    @Nullable
    protected FilterActionComponent createDateComponent() {
        return new FilterActionComponent((Computable<? extends JComponent>)((Computable)() -> new DateFilterPopupComponent(this.myDateFilterModel).initUi()));
    }

    @Nullable
    protected FilterActionComponent createStructureFilterComponent() {
        return new FilterActionComponent((Computable<? extends JComponent>)((Computable)() -> new StructureFilterPopupComponent(this.myUiProperties, this.myStructureFilterModel, this.myColorManager).initUi()));
    }

    private static class TextFilterField
    extends SearchTextField {
        @NotNull
        private final TextFilterModel myTextFilterModel;

        TextFilterField(@NotNull TextFilterModel model) {
            super(VcsLogClassicFilterUi.VCS_LOG_TEXT_FILTER_HISTORY);
            this.myTextFilterModel = model;
            this.setText(this.myTextFilterModel.getText());
            this.getTextEditor().addActionListener(e -> this.applyFilter());
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    try {
                        myTextFilterModel.setUnsavedText(e.getDocument().getText(0, e.getDocument().getLength()));
                    }
                    catch (BadLocationException ex) {
                        LOG.error((Throwable)ex);
                    }
                }
            });
            String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((String)"Vcs.Log.FocusTextFilter");
            if (!shortcutText.isEmpty()) {
                this.getTextEditor().setToolTipText(VcsLogBundle.message((String)"vcs.log.filter.search.tooltip", (Object[])new Object[]{shortcutText}));
            }
        }

        protected void applyFilter() {
            this.myTextFilterModel.setFilterText(this.getText());
            this.addCurrentTextToHistory();
        }

        protected void onFieldCleared() {
            this.myTextFilterModel.setFilter((FilterPair<VcsLogTextFilter, VcsLogHashFilter>)null);
        }

        protected void onFocusLost() {
            if (this.myTextFilterModel.hasUnsavedChanges()) {
                this.applyFilter();
            }
        }
    }

    private class UserFilterModel
    extends FilterModel.SingleFilterModel<VcsLogUserFilter> {
        UserFilterModel(@Nullable MainVcsLogUiProperties uiProperties, VcsLogFilterCollection filters) {
            super(VcsLogFilterCollection.USER_FILTER, uiProperties, filters);
        }

        @Override
        @NotNull
        protected VcsLogUserFilter createFilter(@NotNull List<String> values) {
            return VcsLogFilterObject.fromUserNames(values, VcsLogClassicFilterUi.this.myLogData);
        }

        @Override
        @NotNull
        protected List<String> getFilterValues(@NotNull VcsLogUserFilter filter) {
            return new ArrayList<String>(filter.getValuesAsText());
        }
    }

    private static class DateFilterModel
    extends FilterModel.SingleFilterModel<VcsLogDateFilter> {
        DateFilterModel(@NotNull MainVcsLogUiProperties uiProperties, @Nullable VcsLogFilterCollection filters) {
            super(VcsLogFilterCollection.DATE_FILTER, uiProperties, filters);
        }

        @Override
        @Nullable
        protected VcsLogDateFilter createFilter(@NotNull List<String> values) {
            if (values.size() != 2) {
                LOG.warn("Can not create date filter from " + values + " before and after dates are required.");
                return null;
            }
            String after = values.get(0);
            String before = values.get(1);
            try {
                return VcsLogFilterObject.fromDates(after.isEmpty() ? 0L : Long.parseLong(after), before.isEmpty() ? 0L : Long.parseLong(before));
            }
            catch (NumberFormatException e) {
                LOG.warn("Can not create date filter from " + values);
                return null;
            }
        }

        @Override
        @NotNull
        protected List<String> getFilterValues(@NotNull VcsLogDateFilter filter) {
            Date after = filter.getAfter();
            Date before = filter.getBefore();
            return Arrays.asList(after == null ? "" : Long.toString(after.getTime()), before == null ? "" : Long.toString(before.getTime()));
        }
    }

    public static class FileFilterModel
    extends FilterModel.PairFilterModel<VcsLogStructureFilter, VcsLogRootFilter> {
        @NotNull
        private static final String DIR = "dir:";
        @NotNull
        private static final String FILE = "file:";
        @NotNull
        private final Set<VirtualFile> myRoots;

        public FileFilterModel(@NotNull Set<VirtualFile> roots, @NotNull MainVcsLogUiProperties uiProperties, @Nullable VcsLogFilterCollection filters) {
            super(VcsLogFilterCollection.STRUCTURE_FILTER, VcsLogFilterCollection.ROOT_FILTER, uiProperties, filters);
            this.myRoots = roots;
        }

        @Override
        @NotNull
        protected List<String> getFilter1Values(@NotNull VcsLogStructureFilter filter) {
            return FileFilterModel.getFilterValues(filter);
        }

        @Override
        @NotNull
        protected List<String> getFilter2Values(@NotNull VcsLogRootFilter filter) {
            return FileFilterModel.getRootFilterValues(filter);
        }

        @NotNull
        public static List<String> getRootFilterValues(@NotNull VcsLogRootFilter filter) {
            return ContainerUtil.map((Collection)filter.getRoots(), VirtualFile::getPath);
        }

        @NotNull
        static List<String> getFilterValues(@NotNull VcsLogStructureFilter filter) {
            return ContainerUtil.map((Collection)filter.getFiles(), path2 -> (path2.isDirectory() ? DIR : FILE) + path2.getPath());
        }

        @Override
        @NotNull
        protected VcsLogStructureFilter createFilter1(@NotNull List<String> values) {
            return FileFilterModel.createStructureFilter(values);
        }

        @Override
        @Nullable
        protected VcsLogRootFilter createFilter2(@NotNull List<String> values) {
            ArrayList<VirtualFile> selectedRoots = new ArrayList<VirtualFile>();
            for (String path2 : values) {
                VirtualFile root = LocalFileSystem.getInstance().findFileByPath(path2);
                if (root != null) {
                    if (this.myRoots.contains(root)) {
                        selectedRoots.add(root);
                        continue;
                    }
                    LOG.warn("Can not find VCS root for filtering " + root);
                    continue;
                }
                LOG.warn("Can not filter by root that does not exist " + path2);
            }
            if (selectedRoots.isEmpty()) {
                return null;
            }
            return VcsLogFilterObject.fromRoots(selectedRoots);
        }

        @Nullable
        protected VcsLogRootFilter getRootFilter() {
            return (VcsLogRootFilter)this.getFilter2();
        }

        @Nullable
        public VcsLogStructureFilter getStructureFilter() {
            return (VcsLogStructureFilter)this.getFilter1();
        }

        @NotNull
        Set<VirtualFile> getRoots() {
            return this.myRoots;
        }

        protected void setStructureFilter(@NotNull VcsLogStructureFilter filter) {
            this.setFilter(new FilterPair<VcsLogStructureFilter, Object>(filter, null));
        }

        @NotNull
        static VcsLogStructureFilter createStructureFilter(@NotNull List<String> values) {
            return VcsLogFilterObject.fromPaths(ContainerUtil.map(values, path2 -> {
                if (path2.startsWith(DIR)) {
                    return VcsUtil.getFilePath((String)path2.substring(DIR.length()), (boolean)true);
                }
                if (path2.startsWith(FILE)) {
                    return VcsUtil.getFilePath((String)path2.substring(FILE.length()), (boolean)false);
                }
                return VcsUtil.getFilePath((String)path2);
            }));
        }
    }

    protected static class TextFilterModel
    extends FilterModel.PairFilterModel<VcsLogTextFilter, VcsLogHashFilter> {
        @Nullable
        private String myText;

        TextFilterModel(@NotNull MainVcsLogUiProperties properties, @Nullable VcsLogFilterCollection filters, @NotNull Disposable parentDisposable) {
            super(VcsLogFilterCollection.TEXT_FILTER, VcsLogFilterCollection.HASH_FILTER, properties, filters);
            VcsLogTextFilter textFilter;
            if (filters != null && (textFilter = (VcsLogTextFilter)filters.get(VcsLogFilterCollection.TEXT_FILTER)) != null) {
                this.myUiProperties.set(MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE, textFilter.matchesCase());
                this.myUiProperties.set(MainVcsLogUiProperties.TEXT_FILTER_REGEX, textFilter.isRegex());
            }
            VcsLogUiProperties.PropertiesChangeListener listener2 = new VcsLogUiProperties.PropertiesChangeListener(){

                @Override
                public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
                    if ((MainVcsLogUiProperties.TEXT_FILTER_REGEX.equals(property) || MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE.equals(property)) && this.getFilter1() != null) {
                        myFilter = this.getFilterFromProperties();
                        this.notifyFiltersChanged();
                    }
                }
            };
            properties.addChangeListener(listener2);
            Disposer.register((Disposable)parentDisposable, () -> properties.removeChangeListener(listener2));
        }

        @Override
        @Nullable
        protected FilterPair<VcsLogTextFilter, VcsLogHashFilter> getFilterFromProperties() {
            Object filterPair = super.getFilterFromProperties();
            if (filterPair == null) {
                return null;
            }
            VcsLogTextFilter textFilter = (VcsLogTextFilter)((FilterPair)filterPair).getFilter1();
            VcsLogHashFilter hashFilter = (VcsLogHashFilter)((FilterPair)filterPair).getFilter2();
            if (textFilter != null && StringUtil.isEmptyOrSpaces((String)textFilter.getText())) {
                LOG.warn("Saved text filter is empty. Removing.");
                textFilter = null;
            }
            if (textFilter != null) {
                VcsLogHashFilter hashFilterFromText = VcsLogFilterObject.fromHash(textFilter.getText());
                if (!Objects.equals(hashFilter, hashFilterFromText)) {
                    LOG.warn("Saved hash filter " + hashFilter + " is inconsistent with text filter. Replacing with " + hashFilterFromText);
                    hashFilter = hashFilterFromText;
                }
            } else if (hashFilter != null && !hashFilter.getHashes().isEmpty()) {
                textFilter = this.createTextFilter(StringUtil.join((Collection)hashFilter.getHashes(), (String)" "));
                LOG.warn("Saved hash filter " + hashFilter + " is inconsistent with empty text filter. Using text filter " + textFilter);
            }
            return new FilterPair<VcsLogTextFilter, VcsLogHashFilter>(textFilter, hashFilter);
        }

        @NotNull
        String getText() {
            if (this.myText != null) {
                return this.myText;
            }
            if (this.getFilter1() != null) {
                return ((VcsLogTextFilter)this.getFilter1()).getText();
            }
            return "";
        }

        void setUnsavedText(@NotNull String text2) {
            this.myText = text2;
        }

        boolean hasUnsavedChanges() {
            if (this.myText == null) {
                return false;
            }
            return this.getFilter1() == null || !this.myText.equals(((VcsLogTextFilter)this.getFilter1()).getText());
        }

        @Override
        public void setFilter(@Nullable FilterPair<VcsLogTextFilter, VcsLogHashFilter> filter) {
            super.setFilter(filter);
            this.myText = null;
        }

        @Override
        @NotNull
        protected List<String> getFilter1Values(@NotNull VcsLogTextFilter filter) {
            return Collections.singletonList(filter.getText());
        }

        @Override
        @NotNull
        protected List<String> getFilter2Values(@NotNull VcsLogHashFilter filter) {
            return new ArrayList<String>(filter.getHashes());
        }

        @Override
        @Nullable
        protected VcsLogTextFilter createFilter1(@NotNull List<String> values) {
            return this.createTextFilter((String)Objects.requireNonNull(ContainerUtil.getFirstItem(values)));
        }

        @Override
        @Nullable
        protected VcsLogHashFilter createFilter2(@NotNull List<String> values) {
            return VcsLogFilterObject.fromHashes(values);
        }

        @NotNull
        private VcsLogTextFilter createTextFilter(@NotNull String text2) {
            return VcsLogFilterObject.fromPattern(text2, this.myUiProperties.get(MainVcsLogUiProperties.TEXT_FILTER_REGEX), this.myUiProperties.get(MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE));
        }

        public void setFilterText(@NotNull String text2) {
            if (StringUtil.isEmptyOrSpaces((String)text2)) {
                this.setFilter((FilterPair<VcsLogTextFilter, VcsLogHashFilter>)null);
            } else {
                VcsLogTextFilter textFilter = this.createTextFilter(text2);
                VcsLogHashFilter hashFilter = VcsLogFilterObject.fromHash(text2);
                this.setFilter(new FilterPair<VcsLogTextFilter, VcsLogHashFilter>(textFilter, hashFilter));
            }
        }
    }

    public static class BranchFilterModel
    extends FilterModel<BranchFilters> {
        @NotNull
        private final VcsLogStorage myStorage;
        @NotNull
        private final Collection<VirtualFile> myRoots;
        @Nullable
        private Collection<VirtualFile> myVisibleRoots;
        @NotNull
        private final Computable<? extends VcsLogDataPack> myDataPackProvider;

        BranchFilterModel(@NotNull Computable<? extends VcsLogDataPack> dataPackProvider, @NotNull VcsLogStorage storage, @NotNull Collection<VirtualFile> roots, @NotNull MainVcsLogUiProperties properties, @Nullable VcsLogFilterCollection filters) {
            super(properties);
            this.myStorage = storage;
            this.myRoots = roots;
            this.myDataPackProvider = dataPackProvider;
            if (filters != null) {
                this.saveFilterToProperties(new BranchFilters((VcsLogBranchFilter)filters.get(VcsLogFilterCollection.BRANCH_FILTER), (VcsLogRevisionFilter)filters.get(VcsLogFilterCollection.REVISION_FILTER), (VcsLogRangeFilter)filters.get(VcsLogFilterCollection.RANGE_FILTER)));
            }
        }

        @Override
        public void setFilter(@Nullable BranchFilters filters) {
            if (filters != null && filters.isEmpty()) {
                filters = null;
            }
            boolean anyFilterDiffers = false;
            if (BranchFilterModel.filterDiffers(filters, BranchFilters::getBranchFilter, this.myFilter)) {
                BranchFilterModel.triggerFilterSet(filters, BranchFilters::getBranchFilter, VcsLogFilterCollection.BRANCH_FILTER.getName());
                anyFilterDiffers = true;
            }
            if (BranchFilterModel.filterDiffers(filters, BranchFilters::getRevisionFilter, this.myFilter)) {
                BranchFilterModel.triggerFilterSet(filters, BranchFilters::getRevisionFilter, VcsLogFilterCollection.REVISION_FILTER.getName());
                anyFilterDiffers = true;
            }
            if (BranchFilterModel.filterDiffers(filters, BranchFilters::getRangeFilter, this.myFilter)) {
                BranchFilterModel.triggerFilterSet(filters, BranchFilters::getRangeFilter, VcsLogFilterCollection.RANGE_FILTER.getName());
                anyFilterDiffers = true;
            }
            if (anyFilterDiffers) {
                super.setFilter(filters);
            }
        }

        @Override
        protected void saveFilterToProperties(@Nullable BranchFilters filters) {
            if (filters == null || filters.getBranchFilter() == null) {
                this.myUiProperties.saveFilterValues(VcsLogFilterCollection.BRANCH_FILTER.getName(), null);
            } else {
                this.myUiProperties.saveFilterValues(VcsLogFilterCollection.BRANCH_FILTER.getName(), BranchFilterModel.getBranchFilterValues(filters.getBranchFilter()));
            }
            if (filters == null || filters.getRevisionFilter() == null) {
                this.myUiProperties.saveFilterValues(VcsLogFilterCollection.REVISION_FILTER.getName(), null);
            } else {
                this.myUiProperties.saveFilterValues(VcsLogFilterCollection.REVISION_FILTER.getName(), BranchFilterModel.getRevisionFilterValues(filters.getRevisionFilter()));
            }
            if (filters == null || filters.getRangeFilter() == null) {
                this.myUiProperties.saveFilterValues(VcsLogFilterCollection.RANGE_FILTER.getName(), null);
            } else {
                this.myUiProperties.saveFilterValues(VcsLogFilterCollection.RANGE_FILTER.getName(), BranchFilterModel.getRangeFilterValues(filters.getRangeFilter()));
            }
        }

        @Override
        @Nullable
        protected BranchFilters getFilterFromProperties() {
            List<String> branchFilterValues = this.myUiProperties.getFilterValues(VcsLogFilterCollection.BRANCH_FILTER.getName());
            VcsLogBranchFilter branchFilter = null;
            if (branchFilterValues != null) {
                branchFilter = this.createBranchFilter(branchFilterValues);
            }
            List<String> revisionFilterValues = this.myUiProperties.getFilterValues(VcsLogFilterCollection.REVISION_FILTER.getName());
            VcsLogRevisionFilter revisionFilter = null;
            if (revisionFilterValues != null) {
                revisionFilter = this.createRevisionFilter(revisionFilterValues);
            }
            List<String> rangeFilterValues = this.myUiProperties.getFilterValues(VcsLogFilterCollection.RANGE_FILTER.getName());
            VcsLogRangeFilter rangeFilter = null;
            if (rangeFilterValues != null) {
                rangeFilter = BranchFilterModel.createRangeFilter(rangeFilterValues);
            }
            if (branchFilter == null && revisionFilter == null && rangeFilter == null) {
                return null;
            }
            return new BranchFilters(branchFilter, revisionFilter, rangeFilter);
        }

        public void onStructureFilterChanged(@Nullable VcsLogRootFilter rootFilter, @Nullable VcsLogStructureFilter structureFilter) {
            this.myVisibleRoots = rootFilter == null && structureFilter == null ? null : VcsLogUtil.getAllVisibleRoots(this.myRoots, rootFilter, structureFilter);
        }

        @Nullable
        public Collection<VirtualFile> getVisibleRoots() {
            return this.myVisibleRoots;
        }

        @NotNull
        VcsLogDataPack getDataPack() {
            return (VcsLogDataPack)this.myDataPackProvider.compute();
        }

        @Nullable
        protected VcsLogBranchFilter createBranchFilter(@NotNull List<String> values) {
            return VcsLogFilterObject.fromBranchPatterns(values, ContainerUtil.map2Set((Collection)this.getDataPack().getRefs().getBranches(), VcsRef::getName));
        }

        @Nullable
        protected VcsLogRevisionFilter createRevisionFilter(@NotNull List<String> values) {
            Pattern pattern = Pattern.compile("\\[(.*)\\](" + VcsLogUtil.HASH_REGEX.pattern() + ")");
            return VcsLogFilterObject.fromCommits(ContainerUtil.mapNotNull(values, s -> {
                Matcher matcher = pattern.matcher((CharSequence)s);
                if (!matcher.matches()) {
                    CommitId commitId;
                    if (s.length() == 40 && VcsLogUtil.HASH_REGEX.matcher((CharSequence)s).matches() && (commitId = this.findCommitId(HashImpl.build(s))) != null) {
                        return commitId;
                    }
                    LOG.warn("Could not parse '" + s + "' while creating revision filter");
                    return null;
                }
                MatchResult result2 = matcher.toMatchResult();
                VirtualFile root = LocalFileSystem.getInstance().findFileByPath(result2.group(1));
                if (root == null) {
                    LOG.warn("Root '" + result2.group(1) + "' does not exist");
                    return null;
                }
                if (!this.myRoots.contains(root)) {
                    LOG.warn("Root '" + result2.group(1) + "' is not registered");
                    return null;
                }
                return new CommitId(HashImpl.build(result2.group(2)), root);
            }));
        }

        @Nullable
        private static VcsLogRangeFilter createRangeFilter(@NotNull List<String> values) {
            if (values.isEmpty()) {
                return null;
            }
            return VcsLogFilterObject.fromRange(ContainerUtil.map(values, value -> {
                String TWO_DOTS = "..";
                int twoDots = value.indexOf(TWO_DOTS);
                if (twoDots <= 0) {
                    LOG.error("Incorrect range filter value: " + values);
                    return null;
                }
                return new VcsLogRangeFilter.RefRange(value.substring(0, twoDots), value.substring(twoDots + TWO_DOTS.length()));
            }));
        }

        @Nullable
        private CommitId findCommitId(@NotNull Hash hash) {
            for (VirtualFile root : this.myRoots) {
                CommitId commitId = new CommitId(hash, root);
                if (!this.myStorage.containsCommit(commitId)) continue;
                return commitId;
            }
            return null;
        }

        @NotNull
        private static List<String> getBranchFilterValues(@NotNull VcsLogBranchFilter filter) {
            return new ArrayList<String>(ContainerUtil.sorted((Collection)filter.getTextPresentation()));
        }

        @NotNull
        private static List<String> getRevisionFilterValues(@NotNull VcsLogRevisionFilter filter) {
            return ContainerUtil.map((Collection)filter.getHeads(), id -> "[" + id.getRoot().getPath() + "]" + id.getHash().asString());
        }

        @NotNull
        private static List<String> getRangeFilterValues(@NotNull VcsLogRangeFilter rangeFilter) {
            return new ArrayList<String>(rangeFilter.getTextPresentation());
        }

        @NotNull
        private static List<String> getRevisionFilter2Presentation(@NotNull VcsLogRevisionFilter filter) {
            return ContainerUtil.map((Collection)filter.getHeads(), id -> id.getHash().asString());
        }

        void setBranchFilter(@NotNull VcsLogBranchFilter branchFilter) {
            this.setFilter(new BranchFilters(branchFilter, null, null));
        }

        public void setRangeFilter(@NotNull VcsLogRangeFilter rangeFilter) {
            this.setFilter(new BranchFilters(null, null, rangeFilter));
        }

        @NotNull
        static List<String> getFilterPresentation(@NotNull BranchFilters filters) {
            List branchFilterValues = filters.getBranchFilter() == null ? Collections.emptyList() : BranchFilterModel.getBranchFilterValues(filters.getBranchFilter());
            List revisionFilterValues = filters.getRevisionFilter() == null ? Collections.emptyList() : BranchFilterModel.getRevisionFilter2Presentation(filters.getRevisionFilter());
            List rangeFilterValues = filters.getRangeFilter() == null ? Collections.emptyList() : BranchFilterModel.getRangeFilterValues(filters.getRangeFilter());
            return ContainerUtil.concat((List[])new List[]{branchFilterValues, revisionFilterValues, rangeFilterValues});
        }

        @Nullable
        BranchFilters createFilterFromPresentation(@NotNull List<String> values) {
            ArrayList<String> hashes = new ArrayList<String>();
            ArrayList<String> branches = new ArrayList<String>();
            ArrayList<String> ranges = new ArrayList<String>();
            for (String s : values) {
                int twoDots = s.indexOf("..");
                if (twoDots > 0 && twoDots == s.lastIndexOf("..")) {
                    ranges.add(s);
                    continue;
                }
                if (s.length() == 40 && VcsLogUtil.HASH_REGEX.matcher(s).matches()) {
                    hashes.add(s);
                    continue;
                }
                branches.add(s);
            }
            VcsLogBranchFilter branchFilter = branches.isEmpty() ? null : this.createBranchFilter(branches);
            VcsLogRevisionFilter hashFilter = hashes.isEmpty() ? null : this.createRevisionFilter(hashes);
            VcsLogRangeFilter refDiffFilter = ranges.isEmpty() ? null : BranchFilterModel.createRangeFilter(ranges);
            return new BranchFilters(branchFilter, hashFilter, refDiffFilter);
        }

        @Nullable
        public VcsLogBranchFilter getBranchFilter() {
            BranchFilters filter = (BranchFilters)this.getFilter();
            if (filter == null) {
                return null;
            }
            return filter.getBranchFilter();
        }

        @Nullable
        public VcsLogRevisionFilter getRevisionFilter() {
            BranchFilters filter = (BranchFilters)this.getFilter();
            if (filter == null) {
                return null;
            }
            return filter.getRevisionFilter();
        }

        @Nullable
        public VcsLogRangeFilter getRangeFilter() {
            BranchFilters filter = (BranchFilters)this.getFilter();
            if (filter == null) {
                return null;
            }
            return filter.getRangeFilter();
        }
    }

    protected static class FilterActionComponent
    extends DumbAwareAction
    implements CustomComponentAction {
        @NotNull
        private final Computable<? extends JComponent> myComponentCreator;

        public FilterActionComponent(@NotNull Computable<? extends JComponent> componentCreator) {
            this.myComponentCreator = componentCreator;
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
            return (JComponent)this.myComponentCreator.compute();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
        }
    }
}

