/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.vcs.versionBrowser.DateFilterComponent;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.FilterPopupComponent;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DateFilterPopupComponent
extends FilterPopupComponent<VcsLogDateFilter, FilterModel<VcsLogDateFilter>> {
    DateFilterPopupComponent(FilterModel<VcsLogDateFilter> filterModel) {
        super(VcsLogBundle.messagePointer((String)"vcs.log.date.filter.label", (Object[])new Object[0]), filterModel);
    }

    @Override
    @NotNull
    @Nls
    protected String getText(@NotNull VcsLogDateFilter filter) {
        Date after = filter.getAfter();
        Date before = filter.getBefore();
        if (after != null && before != null) {
            return DateFormatUtil.formatDate((Date)after) + "-" + DateFormatUtil.formatDate((Date)before);
        }
        if (after != null) {
            return VcsLogBundle.message((String)"vcs.log.date.filter.since", (Object[])new Object[]{DateFormatUtil.formatDate((Date)after)});
        }
        if (before != null) {
            return VcsLogBundle.message((String)"vcs.log.date.filter.since", (Object[])new Object[]{DateFormatUtil.formatDate((Date)before)});
        }
        return (String)ALL.get();
    }

    @Override
    @Nullable
    protected String getToolTip(@NotNull VcsLogDateFilter filter) {
        return null;
    }

    @Override
    protected ActionGroup createActionGroup() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(6, -1);
        Date oneDayBefore = cal.getTime();
        cal.add(6, -6);
        Date oneWeekBefore = cal.getTime();
        return new DefaultActionGroup(new AnAction[]{this.createAllAction(), new SelectAction(), new DateAction(oneDayBefore, VcsLogBundle.messagePointer((String)"vcs.log.date.filter.action.last.day", (Object[])new Object[0])), new DateAction(oneWeekBefore, VcsLogBundle.messagePointer((String)"vcs.log.date.filter.action.last.week", (Object[])new Object[0]))});
    }

    private class SelectAction
    extends DumbAwareAction {
        SelectAction() {
            super(VcsLogBundle.messagePointer((String)"vcs.log.filter.action.select", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DateFilterComponent dateComponent = new DateFilterComponent(false, DateFormatUtil.getDateFormat().getDelegate());
            VcsLogDateFilter currentFilter = (VcsLogDateFilter)DateFilterPopupComponent.this.myFilterModel.getFilter();
            if (currentFilter != null) {
                if (currentFilter.getBefore() != null) {
                    dateComponent.setBefore(currentFilter.getBefore().getTime());
                }
                if (currentFilter.getAfter() != null) {
                    dateComponent.setAfter(currentFilter.getAfter().getTime());
                }
            }
            DialogBuilder db = new DialogBuilder((Component)DateFilterPopupComponent.this);
            db.addOkAction();
            db.setCenterPanel((JComponent)dateComponent.getPanel());
            db.setPreferredFocusComponent((JComponent)dateComponent.getPanel());
            db.setTitle(VcsLogBundle.message((String)"vcs.log.date.filter.select.period.dialog.title", (Object[])new Object[0]));
            if (0 == db.show()) {
                DateFilterPopupComponent.this.myFilterModel.setFilter(VcsLogFilterObject.fromDates(dateComponent.getAfter(), dateComponent.getBefore()));
            }
        }
    }

    private class DateAction
    extends DumbAwareAction {
        @NotNull
        private final Date mySince;

        protected DateAction(@NotNull Date since, Supplier<String> text2) {
            super(text2);
            this.mySince = since;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DateFilterPopupComponent.this.myFilterModel.setFilter(VcsLogFilterObject.fromDates(this.mySince, null));
        }
    }
}

