/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions.history;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.history.actions.GetVersionAction;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.ui.actions.history.FileHistoryMetadataAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GetVersionFromHistoryAction
extends FileHistoryMetadataAction {
    @Override
    protected boolean isEnabled(@NotNull FileHistoryUi ui2, @Nullable VcsCommitMetadata detail, @NotNull AnActionEvent e) {
        VcsFileRevision fileRevision;
        FilePath filePath = (FilePath)e.getData(VcsDataKeys.FILE_PATH);
        if (filePath == null || filePath.isDirectory()) {
            return false;
        }
        return detail == null || !VcsHistoryUtil.isEmpty(fileRevision = ui2.createRevision(detail));
    }

    @Override
    protected void performAction(@NotNull Project project, @NotNull FileHistoryUi ui2, @NotNull VcsCommitMetadata detail, @NotNull AnActionEvent e) {
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return;
        }
        VcsFileRevision revision = ui2.createRevision(detail);
        if (!VcsHistoryUtil.isEmpty(revision)) {
            GetVersionAction.doGet(project, revision, (FilePath)e.getRequiredData(VcsDataKeys.FILE_PATH));
        }
    }
}

